/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.conversorexpressoesdinamico;

import com.touchcomp.basementor.model.vo.ConversorExpressoesDinamico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.convexpressoesdinamica.CompConvExpressoesDinamica;
import com.touchcomp.basementorservice.dao.impl.DaoConversorExpressoesDinamicoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.model.string.StringToken;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceConversorExpressoesDinamicoImpl
extends ServiceGenericEntityImpl<ConversorExpressoesDinamico, Long, DaoConversorExpressoesDinamicoImpl> {
    private CompConvExpressoesDinamica compConvExpressoesDinamica;

    @Autowired
    public ServiceConversorExpressoesDinamicoImpl(DaoConversorExpressoesDinamicoImpl dao, CompConvExpressoesDinamica compConvExpressoesDinamica) {
        super(dao);
        this.compConvExpressoesDinamica = compConvExpressoesDinamica;
    }

    public List<StringToken> getTokensConversor(Long idConversor) {
        ConversorExpressoesDinamico vo = (ConversorExpressoesDinamico)this.get(idConversor);
        if (vo != null) {
            return this.compConvExpressoesDinamica.getAuxTokens(vo, new ArrayList<StringToken>());
        }
        return new ArrayList<StringToken>();
    }

    public Double getResultadoExpressao(ConversorExpressoesDinamico vo, List<StringToken> tokens, Object source) throws ExceptionInvalidData {
        return this.compConvExpressoesDinamica.build(source, tokens, vo);
    }
}

