/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LogCotacaoCompra;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalICMSSTItem;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoCompra;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.aliquota.ExceptionAliquotaNaoEncontrada;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.moeda.ExceptionCotacaoMoeda;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.cotacaocompra.CompCotacaoCompra;
import com.touchcomp.basementorservice.components.cotacaocompra.CompFornecedorItemCotCompra;
import com.touchcomp.basementorservice.dao.impl.DaoCotacaoCompraImpl;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.aliquotast.ServiceAliquotaStImpl;
import com.touchcomp.basementorservice.service.impl.categoriast.ServiceCategoriaStImpl;
import com.touchcomp.basementorservice.service.impl.cotacaomoeda.ServiceCotacaoMoedaImpl;
import com.touchcomp.basementorservice.service.impl.gradecor.ServiceGradeCorImpl;
import com.touchcomp.basementorservice.service.impl.itemunidademedida.ServiceItemUnidadeMedidaImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscalicmsstitem.ServiceModeloFiscalICMSSTItemImpl;
import com.touchcomp.basementorservice.service.impl.moeda.ServiceMoedaImpl;
import com.touchcomp.basementorservice.service.impl.naturezaoperacao.ServiceNaturezaOperacaoImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.basementorservice.service.impl.ordemcompra.ServiceOrdemCompraImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorservice.service.impl.unidadefatfornecedor.ServiceUnidadeFatFornecedorImpl;
import com.touchcomp.basementorservice.service.impl.unidadefederativa.ServiceUnidadeFederativaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceCotacaoCompra;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.entities.ValidImpl;
import com.touchcomp.basementorvalidator.entities.impl.cotacaocompra.ValidCotacaoCompra;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOCotacaoCompra;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTODadosIcmsStCotacao;
import com.touchcomp.touchvomodel.vo.cotacaocompra.web.DTOFornecedorXProduto;
import com.touchcomp.touchvomodel.vo.modelofiscal.web.DTOModeloFiscalProdutoRes;
import com.touchcomp.touchvomodel.vo.planoconta.DTODadosContas;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCotacaoCompraImpl
extends ServiceGenericEntityImpl<CotacaoCompra, Long, DaoCotacaoCompraImpl>
implements ServiceCotacaoCompra {
    ServiceCotacaoMoedaImpl serviceCotacaoMoeda;
    ServiceMoedaImpl serviceMoeda;
    ServiceNecessidadeCompraImpl serviceNecessidadeCompra;
    ServiceOrdemCompraImpl serviceOrdemCompra;
    ServiceProdutoImpl serviceProduto;
    ServiceNaturezaOperacaoImpl serviceNaturezaOperacao;
    ServiceModeloFiscalImpl serviceModeloFiscal;
    ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor;
    ServiceGradeCorImpl serviceGradeCor;
    HelperCotacaoCompra helperCotacaoCompra;
    CompCotacaoCompra compCotacaoCompra;
    ServiceItemUnidadeMedidaImpl serviceItemUnidadeMedida;
    ServiceCategoriaStImpl serviceCategoriaSt;
    ServiceUnidadeFederativaImpl serviceUnidadeFederativa;
    ServiceModeloFiscalICMSSTItemImpl serviceModeloFiscalICMSSTItem;
    ServiceAliquotaStImpl serviceAliquotaSt;

    @Autowired
    public ServiceCotacaoCompraImpl(DaoCotacaoCompraImpl genericDao, ServiceCotacaoMoedaImpl serviceCotacaoMoeda, ServiceMoedaImpl serviceMoeda, ServiceOrdemCompraImpl serviceOrdemCompra, ServiceNecessidadeCompraImpl serviceNecessidadeCompra, ServiceProdutoImpl serviceProduto, ServiceNaturezaOperacaoImpl serviceNaturezaOperacao, ServiceModeloFiscalImpl serviceModeloFiscal, ServiceUnidadeFatFornecedorImpl serviceUnidadeFatFornecedor, ServiceGradeCorImpl serviceGradeCor, HelperCotacaoCompra helperCotacaoCompra, CompCotacaoCompra compCotacaoCompra, ServiceItemUnidadeMedidaImpl serviceItemUnidadeMedida, ServiceCategoriaStImpl serviceCategoriaSt, ServiceUnidadeFederativaImpl serviceUnidadeFederativa, ServiceModeloFiscalICMSSTItemImpl serviceModeloFiscalICMSSTItem, ServiceAliquotaStImpl serviceAliquotaSt) {
        super(genericDao);
        this.serviceCotacaoMoeda = serviceCotacaoMoeda;
        this.serviceMoeda = serviceMoeda;
        this.serviceNecessidadeCompra = serviceNecessidadeCompra;
        this.serviceOrdemCompra = serviceOrdemCompra;
        this.serviceProduto = serviceProduto;
        this.serviceNaturezaOperacao = serviceNaturezaOperacao;
        this.serviceModeloFiscal = serviceModeloFiscal;
        this.serviceUnidadeFatFornecedor = serviceUnidadeFatFornecedor;
        this.serviceGradeCor = serviceGradeCor;
        this.helperCotacaoCompra = helperCotacaoCompra;
        this.compCotacaoCompra = compCotacaoCompra;
        this.serviceItemUnidadeMedida = serviceItemUnidadeMedida;
        this.serviceCategoriaSt = serviceCategoriaSt;
        this.serviceUnidadeFederativa = serviceUnidadeFederativa;
        this.serviceModeloFiscalICMSSTItem = serviceModeloFiscalICMSSTItem;
        this.serviceAliquotaSt = serviceAliquotaSt;
    }

    @Override
    public CotacaoCompra beforeSave(CotacaoCompra vo) {
        OpcoesCompraSuprimentos opcoesCompraSuprimentos = null;
        if (this.getSharedData() != null) {
            opcoesCompraSuprimentos = this.getSharedData().getOpcoesCompraSuprimentos(vo.getEmpresa());
        }
        if (vo != null) {
            if (vo.getSituacaoCotacaoCompra() != null && this.isEquals(vo.getSituacaoCotacaoCompra().getEncerrarCotacao(), EnumConstantsMentorSimNao.SIM.getValue())) {
                vo.setFechada(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                vo.setDataFinalizacao(new Date());
            }
            if (vo.getItensCotacaoCompra() != null) {
                for (ItemCotacaoCompra it : vo.getItensCotacaoCompra()) {
                    it.setCotacaoCompra(vo);
                    if (it.getNecessidadesCompra() != null) {
                        for (NecessidadeCompra n : it.getNecessidadesCompra()) {
                            if (vo.getSituacaoCotacaoCompra() != null && this.isEquals(vo.getSituacaoCotacaoCompra().getDesativarNecessidadeRelacionada(), EnumConstantsMentorSimNao.SIM.getValue())) {
                                n.setDesativarNecessidade(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                                n.setMotivoDesativacao(MessagesBaseMentor.getMsg((String)"M.ERP.1066.002", (Object[])new Object[0]));
                                if (opcoesCompraSuprimentos != null && opcoesCompraSuprimentos.getSituacaoNecessidadeDesistencia() != null) {
                                    n.setSituacaoNecessidadeCompra(opcoesCompraSuprimentos.getSituacaoNecessidadeDesistencia());
                                } else {
                                    n.setSituacaoNecessidadeCompra(null);
                                }
                            }
                            n.setItemCotacaoCompraGerada(it);
                            this.serviceNecessidadeCompra.beforeSave(n);
                        }
                    }
                    if (it.getFornecedoresItemCotacaoCompra() == null) continue;
                    for (FornecedorItemCotacaoCompra f : it.getFornecedoresItemCotacaoCompra()) {
                        f.setItemCotacaoCompra(it);
                        if (f.getDataPrevFaturamento() != null) continue;
                        f.setDataPrevFaturamento(vo.getDataCotacaoCompra());
                    }
                }
            }
            if (vo.getOrdensCompra() != null) {
                for (OrdemCompra o : vo.getOrdensCompra()) {
                    o.setCotacaoCompra(vo);
                    this.serviceOrdemCompra.beforeSave(o);
                }
            }
            if (vo.getLogsCotacaoCompra() != null) {
                for (LogCotacaoCompra log : vo.getLogsCotacaoCompra()) {
                    log.setCotacaoCompra(vo);
                }
            }
            if (opcoesCompraSuprimentos != null) {
                this.helperCotacaoCompra.avaliaMelhorFornecedor(vo, opcoesCompraSuprimentos);
            }
        }
        return vo;
    }

    @Override
    public List<CotacaoCompra> get(EnumConstantsMentorSimNao filtrarDatas, Date dataIn, Date dataFinal, SituacaoCotacaoCompra situacaoCotacaoCompra, Empresa empresa) {
        return ((DaoCotacaoCompraImpl)this.getGenericDao()).get(filtrarDatas, dataIn, dataFinal, situacaoCotacaoCompra, empresa);
    }

    public List<CotacaoCompra> get(Empresa emp, SituacaoCotacaoCompra situacao) {
        return ((DaoCotacaoCompraImpl)this.getGenericDao()).get(emp, situacao);
    }

    public List<CotacaoCompra> getCotacoesVencidas(Empresa emp, Date date, SituacaoCotacaoCompra situacaoLibFornecedor, SituacaoCotacaoCompra situacaoEnvEmailForn) {
        return ((DaoCotacaoCompraImpl)this.getGenericDao()).getCotacoesVencidas(emp, date, situacaoLibFornecedor, situacaoEnvEmailForn);
    }

    public DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra novaCotacaoMoeda(DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra dto) throws ExceptionCotacaoMoeda {
        CotacaoMoeda cotacaoMoeda = (CotacaoMoeda)this.serviceCotacaoMoeda.get(dto.getCotacaoMoedaIdentificador());
        Moeda moeda = (Moeda)this.serviceMoeda.get(dto.getMoedaIdentificador());
        CompFornecedorItemCotCompra compFornecedorItemCotCompra = (CompFornecedorItemCotCompra)ConfApplicationContext.getBean(CompFornecedorItemCotCompra.class);
        return compFornecedorItemCotCompra.pesquisarCotacaoAtualMoeda(dto, cotacaoMoeda, moeda);
    }

    public DTODadosContas getParametrizaoContabilCotacao(Long modeloFiscal, Long produto, Long unidadeFatFornecedor, Long naturezaOperacao, Empresa empresa, OpcoesContabeis opcoesContabeis) throws ExceptionParametrizacao, ExceptionInvalidData {
        Produto voProduto = (Produto)this.serviceProduto.get(produto);
        if (voProduto == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1066.017"));
        }
        UnidadeFatFornecedor voUnidadeFatForn = (UnidadeFatFornecedor)this.serviceUnidadeFatFornecedor.get(unidadeFatFornecedor);
        if (voProduto == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1066.018"));
        }
        ModeloFiscal voModeloFiscal = (ModeloFiscal)this.serviceModeloFiscal.get(modeloFiscal);
        if (voProduto == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1066.020"));
        }
        NaturezaOperacao voNaturezaOperacao = (NaturezaOperacao)this.serviceNaturezaOperacao.get(naturezaOperacao);
        if (voProduto == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1066.019"));
        }
        CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
        DTODadosContas dados = comp.getDtoPlanoContasNfTerceiros(voModeloFiscal, voProduto, voUnidadeFatForn, voNaturezaOperacao, empresa, voUnidadeFatForn.getCategoriaPessoa(), opcoesContabeis);
        return dados;
    }

    public List<DTOModeloFiscalProdutoRes> getModelosFiscais(Long idProduto, Long idUnidadeFatForn, Long idNatOperacao, Empresa empresa) throws ExceptionObjNotFound {
        ArrayList<DTOModeloFiscalProdutoRes> ret = new ArrayList<DTOModeloFiscalProdutoRes>();
        Produto produto = (Produto)this.serviceProduto.getOrThrow(idProduto);
        UnidadeFatFornecedor unidadeFatForn = (UnidadeFatFornecedor)this.serviceUnidadeFatFornecedor.getOrThrow(idUnidadeFatForn);
        NaturezaOperacao naturezaOperacao = (NaturezaOperacao)this.serviceNaturezaOperacao.getOrThrow(idNatOperacao);
        HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
        List<ModeloFiscal> modelos = helper.getModelosFiscais(produto, unidadeFatForn, naturezaOperacao, empresa);
        if (modelos != null) {
            for (ModeloFiscal mod : modelos) {
                DTOModeloFiscalProdutoRes dto = new DTOModeloFiscalProdutoRes();
                dto.setIdentificador(mod.getIdentificador());
                dto.setDescricao(mod.toString());
                dto.setProdutoIdentificador(produto.getIdentificador());
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra> pesquisarFornecedoresSugeridos(DTOCotacaoCompra.DTOItemCotacaoCompra cotacao, Empresa empresa, OpcoesCompraSuprimentos opComp, OpcoesContabeis opCont) throws Exception {
        if (cotacao == null) {
            return new ArrayList<DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra>();
        }
        GradeCor grade = (GradeCor)this.serviceGradeCor.get(cotacao.getGradeCorIdentificador());
        NaturezaOperacao naturezaOperacao = (NaturezaOperacao)this.serviceNaturezaOperacao.get(cotacao.getNaturezaOperacaoIdentificador());
        CompFornecedorItemCotCompra comp = (CompFornecedorItemCotCompra)ConfApplicationContext.getBean(CompFornecedorItemCotCompra.class);
        List<FornecedorItemCotacaoCompra> fornecedores = comp.pesquisaFornecedoresSugeridos(grade, cotacao.getQuantidade(), naturezaOperacao, cotacao.getDataCadastro(), empresa, opComp, opCont);
        return this.buildToDTOGeneric(fornecedores, DTOCotacaoCompra.DTOFornecedorItemCotacaoCompra.class);
    }

    public List<DTOFornecedorXProduto> avaliarFornecedoresCotacao(DTOCotacaoCompra cotacao, OpcoesCompraSuprimentos opcoesCompraSuprimentos) {
        if (cotacao == null) {
            return null;
        }
        CotacaoCompra vo = (CotacaoCompra)this.buildToEntity(cotacao);
        this.helperCotacaoCompra.avaliaMelhorFornecedor(vo, opcoesCompraSuprimentos);
        return this.compCotacaoCompra.getFornecedorXItemCotacao(vo);
    }

    public EnumConstantsMentorSimNao cotacaoFechada(Long identificador) {
        Short fechada = ((DaoCotacaoCompraImpl)this.getDao()).getStatusCotacao(identificador);
        if (fechada == null) {
            return EnumConstantsMentorSimNao.NAO;
        }
        return EnumConstantsMentorSimNao.get((Object)fechada);
    }

    public ItemCotacaoCompra buildItem(Long idProduto, OpcoesCompraSuprimentos opcoes) throws ExceptionObjNotFound {
        ItemCotacaoCompra item = new ItemCotacaoCompra();
        GradeCor gradeCor = this.serviceGradeCor.getFirtByIdProduto(idProduto);
        item.setDataCadastro(new Date());
        item.setFatorConversao(Double.valueOf(1.0));
        item.setQuantidade(Double.valueOf(1.0));
        item.setNaturezaOperacao(opcoes.getNaturezaOperacao());
        if (gradeCor != null) {
            item.setUnidadeMedida(gradeCor.getProdutoGrade().getProduto().getUnidadeMedida());
            item.setGradeCor(gradeCor);
        }
        return item;
    }

    public DTODadosIcmsStCotacao getDadosIcmsSt(Long idModeloFiscal, Long idProduto, Long idCategoriaSt, Long idUfSubstituto, Long idUnidadeFatForn, Empresa empresa, OpcoesFaturamento opcoesFaturamento) throws ExceptionAliquotaNaoEncontrada, ExceptionObjNotFound {
        if (this.isEquals(opcoesFaturamento.getTipoCalculoST(), (short)0)) {
            return this.getDadosIcmsStPorCategoria(idModeloFiscal, idProduto, idCategoriaSt, idUfSubstituto, idUnidadeFatForn);
        }
        return this.getDadosIcmsStPorModelo(idModeloFiscal, idProduto, idCategoriaSt, idUfSubstituto, idUnidadeFatForn, empresa, opcoesFaturamento);
    }

    public DTODadosIcmsStCotacao getDadosIcmsStPorModelo(Long idModeloFiscal, Long idProduto, Long idCategoriaSt, Long idUfSubstituto, Long idUnidadeFatForn, Empresa empresa, OpcoesFaturamento opcoesFaturamento) throws ExceptionObjNotFound, ExceptionAliquotaNaoEncontrada {
        Produto produto = (Produto)this.serviceProduto.getOrThrow(idProduto);
        ModeloFiscal modeloFiscal = (ModeloFiscal)this.serviceModeloFiscal.get(idModeloFiscal);
        CategoriaSt categoriaStInf = (CategoriaSt)this.serviceCategoriaSt.get(idCategoriaSt);
        UnidadeFederativa ufSubstituto = (UnidadeFederativa)this.serviceUnidadeFederativa.get(idUfSubstituto);
        UnidadeFatFornecedor unidadeFatFornecedor = (UnidadeFatFornecedor)this.serviceUnidadeFatFornecedor.getOrThrow(idUnidadeFatForn);
        CategoriaSt cat = produto.getCategoriaSutr();
        if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms().getCategoriaST() != null) {
            cat = modeloFiscal.getModeloFiscalIcms().getCategoriaST();
        }
        ModeloFiscalICMSSTItem modeloFiscalICMSSTItem = null;
        DTODadosIcmsStCotacao result = new DTODadosIcmsStCotacao();
        if (categoriaStInf != null && ufSubstituto != null) {
            modeloFiscalICMSSTItem = this.serviceModeloFiscalICMSSTItem.getModelosFiscaisIcmsSTItem(produto.getNcm(), null, empresa, ufSubstituto, null, modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms(), null, cat, null, EnumConstantsMentorSimNao.get((Object)opcoesFaturamento.getUsarCategoriaPessoa()), unidadeFatFornecedor.getCategoriaPessoa());
            result.setCategoriaIcmsSt(categoriaStInf.toString());
            result.setCategoriaIcmsStIdentificador(categoriaStInf.getIdentificador());
            result.setUfSubstitutoIdentificador(ufSubstituto.getIdentificador());
            result.setUfSubstituto(ufSubstituto.toString());
        } else if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms() != null && this.isAffimative(modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt()) && produto != null && produto.getCategoriaSutr() != null) {
            modeloFiscalICMSSTItem = this.serviceModeloFiscalICMSSTItem.getModelosFiscaisIcmsSTItem(produto.getNcm(), null, empresa, unidadeFatFornecedor.getPessoa().getEndereco().getCidade().getUf(), null, modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms(), null, cat, null, EnumConstantsMentorSimNao.get((Object)opcoesFaturamento.getUsarCategoriaPessoa()), unidadeFatFornecedor.getCategoriaPessoa());
            result.setCategoriaIcmsSt(produto.getCategoriaSutr().toString());
            result.setCategoriaIcmsStIdentificador(produto.getCategoriaSutr().getIdentificador());
            result.setUfSubstitutoIdentificador(unidadeFatFornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf().getIdentificador());
            result.setUfSubstituto(unidadeFatFornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf().toString());
        }
        if (modeloFiscalICMSSTItem == null) {
            throw new ExceptionAliquotaNaoEncontrada("E.ERP.1066.032", new Object[]{categoriaStInf != null ? categoriaStInf.getNome() : MessagesBaseMentor.getMsg((String)"msg_nao_informado_cadastro_mod_fiscal_produto", (Object[])new Object[0]), produto != null && produto.getNcm() != null ? produto.getNcm().getCodigo() : MessagesBaseMentor.getMsg((String)"msg_nao_informado_cadastro_mod_fiscal_produto", (Object[])new Object[0]), ufSubstituto.getSigla(), empresa.getPessoa().getNome(), modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getCodigo()});
        }
        result.setAliquotaIcms(modeloFiscalICMSSTItem.getAliquotaIcms());
        result.setDescontoPadrao(modeloFiscalICMSSTItem.getDescontoPadrao());
        result.setIndiceAlteracao(modeloFiscalICMSSTItem.getIndiceAlteracao());
        return result;
    }

    public DTODadosIcmsStCotacao getDadosIcmsStPorCategoria(Long idModeloFiscal, Long idProduto, Long idCategoriaSt, Long idUfSubstituto, Long idUnidadeFatForn) throws ExceptionObjNotFound, ExceptionAliquotaNaoEncontrada {
        Produto produto = (Produto)this.serviceProduto.getOrThrow(idProduto);
        ModeloFiscal modeloFiscal = (ModeloFiscal)this.serviceModeloFiscal.get(idModeloFiscal);
        CategoriaSt categoriaStInf = (CategoriaSt)this.serviceCategoriaSt.get(idCategoriaSt);
        UnidadeFederativa ufSubstituto = (UnidadeFederativa)this.serviceUnidadeFederativa.get(idUfSubstituto);
        UnidadeFatFornecedor unidadeFatFornecedor = (UnidadeFatFornecedor)this.serviceUnidadeFatFornecedor.getOrThrow(idUnidadeFatForn);
        DTODadosIcmsStCotacao result = new DTODadosIcmsStCotacao();
        AliquotaSt aliquotaSt = null;
        if (categoriaStInf != null && ufSubstituto != null) {
            aliquotaSt = this.serviceAliquotaSt.get(categoriaStInf, ufSubstituto);
        } else if (modeloFiscal != null && modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms() != null && this.isAffimative(modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt()) && produto != null && produto.getCategoriaSutr() != null) {
            aliquotaSt = this.serviceAliquotaSt.get(produto.getCategoriaSutr(), unidadeFatFornecedor.getPessoa().getEndereco().getCidade().getUf());
            result.setCategoriaIcmsSt(produto.getCategoriaSutr().toString());
            result.setCategoriaIcmsStIdentificador(produto.getCategoriaSutr().getIdentificador());
            result.setUfSubstitutoIdentificador(unidadeFatFornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf().getIdentificador());
            result.setUfSubstituto(unidadeFatFornecedor.getFornecedor().getPessoa().getEndereco().getCidade().getUf().toString());
        }
        if (aliquotaSt == null) {
            throw new ExceptionAliquotaNaoEncontrada("E.ERP.1066.016", new Object[]{categoriaStInf != null ? categoriaStInf.getNome() : "", ufSubstituto != null ? ufSubstituto.getSigla() : ""});
        }
        result.setAliquotaIcms(aliquotaSt.getAliquotaIcms());
        result.setDescontoPadrao(aliquotaSt.getDescontoPadrao());
        result.setIndiceAlteracao(aliquotaSt.getIndiceAlteracao());
        return result;
    }

    public void buildOrdemCompraCotacao(Long idCotacao, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis) throws Exception {
        CotacaoCompra cotacao = (CotacaoCompra)this.get(idCotacao);
        if (this.isNull(cotacao).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1066.031", new Object[0]);
        }
        ValidCotacaoCompra validador = (ValidCotacaoCompra)ConfApplicationContext.getBean(ValidCotacaoCompra.class);
        ValidImpl result = validador.isValidBeforeGenerateOrdensCompra(cotacao, opcoes);
        if (result.hasErrors()) {
            throw new ExceptionValidacaoDados(result.getContainer().toString(), new Object[0]);
        }
        this.compCotacaoCompra.recalcularCotacao(cotacao, opcoes);
        this.helperCotacaoCompra.avaliaMelhorFornecedor(cotacao, opcoes);
        this.serviceOrdemCompra.buildOrdemCompraCotacao(cotacao, opcoes, user, emp, opcoesGerenciais, opcoesContabeis);
        this.saveOrUpdate(cotacao);
    }

    public void reabrirCotacao(String idStr) throws ExceptionObjNotFound, ExceptionValidacaoDados, Exception {
        if (this.isStrWithData(idStr) && ToolString.isALongNumber((String)idStr)) {
            Long identificador = Long.valueOf(idStr);
            CotacaoCompra vo = (CotacaoCompra)this.getOrThrow(identificador);
            if (this.isNotNull(vo).booleanValue()) {
                vo.getOrdensCompra().clear();
                vo.setFechada(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
                vo.setDataFinalizacao(null);
                this.saveOrUpdate(vo);
            }
        } else {
            throw new ExceptionValidacaoDados("E.ERP.1066.034", new Object[0]);
        }
    }

    @Override
    public CotacaoCompra beforeDeleteEntity(CotacaoCompra entity) {
        for (ItemCotacaoCompra itemCotacaoCompra : entity.getItensCotacaoCompra()) {
            if (itemCotacaoCompra.getNecessidadesCompra() != null) {
                for (NecessidadeCompra necessidadeCompra : itemCotacaoCompra.getNecessidadesCompra()) {
                    necessidadeCompra.setItemCotacaoCompraGerada(null);
                    this.serviceNecessidadeCompra.saveOrUpdate(necessidadeCompra);
                }
            }
            itemCotacaoCompra.setNecessidadesCompra(new ArrayList());
        }
        return entity;
    }
}

