/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cte;

import com.touchcomp.basementor.constants.ConstantsCte;
import com.touchcomp.basementor.model.vo.VersaoCTe;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.notafiscal.CompNotaFiscal;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.cte.ServiceCteImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.basementorxml.model.XMLCTe;
import com.touchcomp.basementorxml.service.impl.xmlcte.ServiceXMLCTeImpl;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceCteXMLImpl
extends ServiceGenericImpl {
    @Autowired
    ServiceCteImpl serviceCteImpl;
    @Autowired
    ServiceXMLCTeImpl serviceXML;

    public File getXMLsZipFile(String ... chaves) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLsZipFile(ToolMethods.toList((Object[])chaves));
    }

    public File getXMLsZipFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File zip = new File(tmpDir.getAbsolutePath() + File.separator + "arquivo_xml_documentos.zip");
        ToolZipUtils.compress((File)zip, this.getXMLsFile(ids));
        return zip;
    }

    public List<File> getXMLsFile(List<Long> ids) throws ExceptionIO, ExceptionInvalidData {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<Long> aux = new LinkedList<Long>();
        for (Long id : ids) {
            if (aux.contains(id)) continue;
            files.add(this.getXMLFile(id));
            aux.add(id);
        }
        return files;
    }

    public File getXMLFile(Long idNota) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLFile(idNota, false);
    }

    public String getXMLStr(Long idNota) throws ExceptionIO, ExceptionInvalidData {
        File f = this.getXMLFile(idNota, false);
        return ToolFile.getConteudoArquivo((File)f);
    }

    public File getXMLFile(Long idCTe, boolean removeInvalidUTF) throws ExceptionIO, ExceptionInvalidData {
        try {
            File tmpDir = ToolFile.getFileTMPDir();
            XMLCTe xmlCTe = this.serviceXML.getXmlCTeIdCTe(idCTe);
            if (xmlCTe == null) {
                throw new ExceptionInvalidData("E.ERP.1910.001", new Object[]{idCTe});
            }
            String xml = xmlCTe.getConteudoXML();
            if (removeInvalidUTF) {
                xml = ToolString.removeIllegalXMLChar((String)xml);
            }
            VersaoCTe versao = this.serviceCteImpl.getVersaoEmissao(idCTe);
            String chaveCTe = this.serviceCteImpl.getChave(idCTe);
            Document document = ToolJdom.getDocument((String)xml);
            Element e = null;
            if (xmlCTe.getConteudoAprovacao() != null) {
                Document a = ToolJdom.getDocument((String)xmlCTe.getConteudoAprovacao());
                Element rootApprovado = a.detachRootElement();
                if (!rootApprovado.getName().equals("protCTe")) {
                    e = new Element("protCTe");
                    Attribute at = new Attribute("versao", versao.getCodigo());
                    e.setAttribute(at);
                    e.setNamespace(rootApprovado.getNamespace());
                    e.addContent((Content)rootApprovado);
                } else {
                    e = rootApprovado;
                }
            }
            Element nfeProc = new Element("cteProc");
            Attribute at = new Attribute("versao", versao.getCodigo());
            nfeProc.setAttribute(at);
            Element root = document.detachRootElement();
            nfeProc.addContent((Content)root);
            if (e != null) {
                nfeProc.addContent((Content)e);
            }
            nfeProc.setNamespace(ConstantsCte.NAMESPACE_CTE);
            document.setRootElement(nfeProc);
            File temp = new File(tmpDir.getAbsolutePath() + File.separator + CompNotaFiscal.getFileNameCTe(chaveCTe));
            ToolJdom.writeXMLPretty((Document)document, (File)temp, (String)"ISO-8859-1");
            return temp;
        }
        catch (ExceptionJDom ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO((Exception)((Object)ex), new Object[0]);
        }
    }
}

