/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.cte;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.DadosSeguro;
import com.touchcomp.basementorclientwebservices.averbacaocte.model.Retorno;
import com.touchcomp.basementorclientwebservices.components.DocAverbaCteMdfeNfe;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorservice.service.impl.cte.ServiceCteImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorxml.model.XMLCTe;
import com.touchcomp.basementorxml.model.XMLEventoCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoCTe;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.XMLOutputter;

public class UtilEnviarAverbacaoCte {
    private static final ServiceCteImpl serviceCteImpl = (ServiceCteImpl)Context.get(ServiceCteImpl.class);
    private static final ServiceXMLCTe serviceXMLCTe = (ServiceXMLCTe)Context.get(ServiceXMLCTe.class);
    private static final DocAverbaCteMdfeNfe docAverbaCteMdfeNfe = (DocAverbaCteMdfeNfe)Context.get(DocAverbaCteMdfeNfe.class);
    private static final ServiceXMLEventoCTe serviceXMLEventoCTe = (ServiceXMLEventoCTe)Context.get(ServiceXMLEventoCTe.class);

    static Cte enviarAverbacaoAprovado(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionJDom {
        if (ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getUsuarioAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getSenhaAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getCodAtmAverbacao())) {
            XMLCTe xmlCte = serviceXMLCTe.getXmlCTeIdCTe(cte.getIdentificador());
            String xml = UtilEnviarAverbacaoCte.montarXmlAprovado(xmlCte, cte);
            Retorno a = docAverbaCteMdfeNfe.sendMsgCte(xml, opcoesFaturamentoTransp.getUsuarioAverbacao(), opcoesFaturamentoTransp.getSenhaAverbacao(), opcoesFaturamentoTransp.getCodAtmAverbacao());
            if (a != null && a.getAverbado() != null && a.getAverbado().getDadosSeguro() != null && !a.getAverbado().getDadosSeguro().isEmpty()) {
                cte.setNumeroAverbacao(((DadosSeguro)a.getAverbado().getDadosSeguro().get(0)).getNumeroAverbacao());
                cte.setAprovadoAverbacao(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
                return serviceCteImpl.saveOrUpdate(cte);
            }
            return cte;
        }
        return cte;
    }

    static Cte enviarAverbacaoAprovadoSemSalvar(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionJDom {
        XMLCTe xmlCte;
        if (ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getUsuarioAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getSenhaAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getCodAtmAverbacao()) && ToolMethods.isNotNull((Object)(xmlCte = serviceXMLCTe.getXmlCTeIdCTe(cte.getIdentificador()))).booleanValue() && ToolMethods.isNotNull((Object)xmlCte.getConteudoXML()).booleanValue() && ToolMethods.isNotNull((Object)xmlCte).booleanValue() && ToolMethods.isNotNull((Object)xmlCte.getConteudoAprovacao()).booleanValue()) {
            String xml = UtilEnviarAverbacaoCte.montarXmlAprovado(xmlCte, cte);
            Retorno a = docAverbaCteMdfeNfe.sendMsgCte(xml, opcoesFaturamentoTransp.getUsuarioAverbacao(), opcoesFaturamentoTransp.getSenhaAverbacao(), opcoesFaturamentoTransp.getCodAtmAverbacao());
            if (a != null && a.getAverbado() != null && a.getAverbado().getDadosSeguro() != null && !a.getAverbado().getDadosSeguro().isEmpty()) {
                cte.setNumeroAverbacao(((DadosSeguro)a.getAverbado().getDadosSeguro().get(0)).getNumeroAverbacao());
                cte.setAprovadoAverbacao(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            return cte;
        }
        return cte;
    }

    static Cte enviarAverbacaoCancelado(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws ExceptionJDom {
        if (ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getUsuarioAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getSenhaAverbacao()) && ToolMethods.isStrWithData((String)opcoesFaturamentoTransp.getCodAtmAverbacao())) {
            XMLEventoCTe xmlEventoCte = serviceXMLEventoCTe.getXMLEventoCTe(cte.getEvtCTeCancelamento().getIdentificador());
            String xml = UtilEnviarAverbacaoCte.montarXmlCancelado(xmlEventoCte, cte);
            xml = xml.replace("&#xD;", "").replace("&#13;", "");
            Retorno a = docAverbaCteMdfeNfe.sendMsgCte(xml, opcoesFaturamentoTransp.getUsuarioAverbacao(), opcoesFaturamentoTransp.getSenhaAverbacao(), opcoesFaturamentoTransp.getCodAtmAverbacao());
            cte.setCanceladoAverbacao(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            return serviceCteImpl.saveOrUpdate(cte);
        }
        return cte;
    }

    private static String montarXmlAprovado(XMLCTe xmlCte, Cte cte) throws ExceptionJDom {
        Document d = ToolJdom.getDocument((String)xmlCte.getConteudoXML());
        Element e = d.getRootElement();
        if (xmlCte.getConteudoAprovacao() != null) {
            Document a = ToolJdom.getDocument((String)xmlCte.getConteudoAprovacao());
            Element rootApprovado = a.detachRootElement();
            if (!rootApprovado.getName().equals("protCTe")) {
                e = new Element("protCTe");
                Attribute at = new Attribute("versao", cte.getVersaoCte().getCodigo());
                e.setAttribute(at);
                e.setNamespace(rootApprovado.getNamespace());
                e.addContent((Content)rootApprovado);
            } else {
                e = rootApprovado;
            }
        }
        Element nfeProc = new Element("cteProc");
        Attribute at = new Attribute("versao", cte.getVersaoCte().getCodigo());
        nfeProc.setAttribute(at);
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/cte"));
        return new XMLOutputter().outputString(nfeProc);
    }

    private static String montarXmlCancelado(XMLEventoCTe xmlEventoCte, Cte cte) throws ExceptionJDom {
        Document d = new Document();
        if (xmlEventoCte.getConteudoEnviado() != null) {
            d = ToolJdom.getDocument((String)xmlEventoCte.getConteudoEnviado());
        }
        Element e = null;
        if (xmlEventoCte.getConteudoRecebido() != null) {
            Document a = ToolJdom.getDocument((String)xmlEventoCte.getConteudoRecebido());
            e = a.detachRootElement();
        }
        Element nfeProc = new Element("procCancCTe");
        Attribute at = new Attribute("versao", cte.getVersaoCte().getCodigo());
        nfeProc.setAttribute(at);
        nfeProc.setNamespace(Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/cte"));
        Element root = d.detachRootElement();
        nfeProc.addContent((Content)root);
        if (e != null) {
            nfeProc.addContent((Content)e);
        }
        return new XMLOutputter().outputString(nfeProc);
    }
}

