/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.dashboardcontabil;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoNormEnc;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IndiceEconomico;
import com.touchcomp.basementor.model.vo.IntervaloControleCont;
import com.touchcomp.basementor.model.vo.IntervaloControleContPer;
import com.touchcomp.basementor.model.vo.LinhasIndiceEconomico;
import com.touchcomp.basementor.model.vo.MetaControleContabil;
import com.touchcomp.basementorexceptions.exceptions.impl.indiceeconomico.ExceptionIndiceEconomico;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.service.impl.buildindiceeconomico.ServiceBuildIndiceEconomicoImpl;
import com.touchcomp.basementorservice.service.impl.centroresultadocontfin.ServiceCentroResultadoContFinImpl;
import com.touchcomp.basementorservice.service.impl.indiceeconomico.ServiceIndiceEconomicoImpl;
import com.touchcomp.basementorservice.service.impl.intervalocontrolecont.ServiceIntervaloControleContImpl;
import com.touchcomp.basementorservice.service.impl.metacontrolecontabil.ServiceMetaControleContabilImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.dashboardcontabil.DTOPainelDashboardContabil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceDashboardContabilImpl {
    private ServiceIntervaloControleContImpl serviceIntervaloControleCont;
    private ServiceMetaControleContabilImpl serviceMetaControleContabil;
    private ServiceIndiceEconomicoImpl serviceIndiceEconomico;
    private ServiceCentroResultadoContFinImpl serviceCentroResultadoContFin;
    private ServiceBuildIndiceEconomicoImpl serviceBuildIndiceEconomicoImpl;

    @Autowired
    public void ServiceDashboardContabilImpl(ServiceIntervaloControleContImpl serviceIntervaloControleCont, ServiceMetaControleContabilImpl serviceMetaControleContabil, ServiceIndiceEconomicoImpl serviceIndiceEconomico, ServiceCentroResultadoContFinImpl serviceCentroResultadoContFin, ServiceBuildIndiceEconomicoImpl serviceBuildIndiceEconomicoImpl) {
        this.serviceIntervaloControleCont = serviceIntervaloControleCont;
        this.serviceMetaControleContabil = serviceMetaControleContabil;
        this.serviceIndiceEconomico = serviceIndiceEconomico;
        this.serviceCentroResultadoContFin = serviceCentroResultadoContFin;
        this.serviceBuildIndiceEconomicoImpl = serviceBuildIndiceEconomicoImpl;
    }

    public LinkedList<DTOPainelDashboardContabil> processar(Long indiceGer, Long centroResult, Long metaCont, Long interv, Empresa empresa, EnumConstantsTipoSaldoNormEnc tipo, EnumConstantsMentorSimNao desconsiderarEncerramento) throws ExceptionIndiceEconomico, ExceptionValidacaoDados, ExceptionObjNotFound {
        if (indiceGer == null || interv <= 0L) {
            throw new ExceptionValidacaoDados("E.ERP.1470.001", new Object[0]);
        }
        if (interv == null || interv <= 0L) {
            throw new ExceptionValidacaoDados("E.ERP.1470.002", new Object[0]);
        }
        IndiceEconomico indice = (IndiceEconomico)this.serviceIndiceEconomico.getOrThrow(indiceGer);
        CentroResultadoContFin centroResultado = (CentroResultadoContFin)this.serviceCentroResultadoContFin.get(centroResult);
        IntervaloControleCont intervalo = (IntervaloControleCont)this.serviceIntervaloControleCont.getOrThrow(interv);
        MetaControleContabil metas = (MetaControleContabil)this.serviceMetaControleContabil.get(interv);
        return this.calcular(indice, empresa, centroResultado, intervalo, metas, tipo, desconsiderarEncerramento);
    }

    public LinkedList<DTOPainelDashboardContabil> processar(IndiceEconomico indice, CentroResultadoContFin centroResultado, MetaControleContabil metas, IntervaloControleCont intervalo, Empresa empresa, EnumConstantsTipoSaldoNormEnc tipo, EnumConstantsMentorSimNao desconsiderarEncerramento) throws ExceptionIndiceEconomico, ExceptionValidacaoDados {
        if (indice == null) {
            throw new ExceptionValidacaoDados("E.ERP.1470.001", new Object[0]);
        }
        if (intervalo == null) {
            throw new ExceptionValidacaoDados("E.ERP.1470.002", new Object[0]);
        }
        return this.calcular(indice, empresa, centroResultado, intervalo, metas, tipo, desconsiderarEncerramento);
    }

    private LinkedList<DTOPainelDashboardContabil> calcular(IndiceEconomico indice, Empresa empresa, CentroResultadoContFin centroResultado, IntervaloControleCont intervalo, MetaControleContabil metas, EnumConstantsTipoSaldoNormEnc tipo, EnumConstantsMentorSimNao desconsiderarEncerramento) throws ExceptionIndiceEconomico {
        LinkedList<DTOPainelDashboardContabil> processedData = new LinkedList<DTOPainelDashboardContabil>();
        for (IntervaloControleContPer per : intervalo.getIntervalos()) {
            indice = (IndiceEconomico)this.serviceIndiceEconomico.get(indice.getIdentificador());
            List<HashMap> returned = this.serviceBuildIndiceEconomicoImpl.gerarIndiceEconomico(indice, per, empresa, centroResultado, intervalo, metas, tipo, desconsiderarEncerramento);
            this.processData(returned, processedData, per);
        }
        return processedData;
    }

    private void processData(List<HashMap> dados, LinkedList<DTOPainelDashboardContabil> processedData, IntervaloControleContPer per) {
        for (Map map : dados) {
            LinhasIndiceEconomico linha = (LinhasIndiceEconomico)map.get("F_LINHA");
            DTOPainelDashboardContabil found = null;
            for (DTOPainelDashboardContabil aux : processedData) {
                if (!TMethods.isEquals((Object)aux.getIdentificadorLinhaReferencia(), (Object)linha.getIdentificador())) continue;
                found = aux;
                break;
            }
            if (found == null) {
                found = new DTOPainelDashboardContabil();
                found.setLinhaReferencia(linha.getDescricao());
                found.setIdentificadorLinhaReferencia(linha.getIdentificador());
                found.setLinhas(new ArrayList());
                processedData.add(found);
            }
            DTOPainelDashboardContabil.DTOVlrPainelDashboardContabil valores = new DTOPainelDashboardContabil.DTOVlrPainelDashboardContabil();
            valores.setValorRealizado(linha.getValor());
            valores.setValorMeta(linha.getValorMeta());
            valores.setPercMetaReal(linha.getPercMetaRealizado());
            valores.setDifMetaReal(linha.getDifMetaReal());
            valores.setIntervaloControleContPer(per.getDescricao());
            valores.setIdentificadorIntervaloControleContPer(per.getIdentificador());
            found.getLinhas().add(valores);
        }
    }
}

