/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.database;

import com.touchcomp.basementor.model.impl.MapaVinculacoesRegistrosBD;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.dao.impl.database.DaoFirebird;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchvomodel.temp.database.DTODBIndex;
import com.touchcomp.touchvomodel.temp.database.DTODBProcess;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServiceFirebird
extends ServiceGenericImpl {
    @Autowired
    DaoFirebird daoFirebird;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void recomputeIndex(String ... entities) throws ExceptionReflection {
        for (String entity : entities) {
            String table = ToolReflections.getTableName((String)entity);
            this.recomputeIndexInternal(table);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void recomputeIndex(Class ... entities) {
        for (Class entity : entities) {
            String table = ToolReflections.getTableName((Class)entity);
            this.recomputeIndexInternal(table);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void desvinculaRegistrosForeignKeys(Class ... entities) throws ExceptionReflection {
        for (Class entity : entities) {
            String table = ToolReflections.getTableName((Class)entity);
            this.daoFirebird.desvinculaRegistrosForeignKeys(table);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<MapaVinculacoesRegistrosBD> getMapaVinculacaoTabela(String table, Long idRegistroPesq) {
        return this.daoFirebird.getMapaVinculacaoTabela(table, idRegistroPesq);
    }

    public List<MapaVinculacoesRegistrosBD> getMapaVinculacaoEntidade(Class<?> aClass) {
        return this.getMapaVinculacaoEntidade(aClass, null);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<MapaVinculacoesRegistrosBD> getMapaVinculacaoEntidade(Class<?> entidade, Long idRegistroPesq) {
        String table = ToolReflections.getTableName(entidade);
        return this.daoFirebird.getMapaVinculacaoTabela(table, idRegistroPesq);
    }

    private void recomputeIndexInternal(String table) {
        if (table != null) {
            List<DTODBIndex> indexes = this.daoFirebird.getIndex(table);
            this.daoFirebird.recomputeIndex(indexes);
        }
    }

    public List<DTODBProcess> getRunningProccess() {
        return this.daoFirebird.getRunningProcess();
    }

    public boolean cancelRunningProcess(Long processId) {
        return this.daoFirebird.cancelRunningProcess(processId) > 0;
    }

    public void setDefaultId(Long identificador, List<MapaVinculacoesRegistrosBD> mapaVinculacoes) {
        this.daoFirebird.setDefaultId(identificador, mapaVinculacoes);
    }
}

