/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.deparaitensnotapropria;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.DeParaItensNotaPropria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.dao.impl.DaoDeParaItensNotaPropriaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.incidenciaicms.ServiceIncidenciaIcmsImpl;
import com.touchcomp.basementorservice.service.impl.modelofiscal.ServiceModeloFiscalImpl;
import com.touchcomp.basementorservice.service.impl.produto.ServiceProdutoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceDeParaItensNotaPropriaImpl
extends ServiceGenericEntityImpl<DeParaItensNotaPropria, Long, DaoDeParaItensNotaPropriaImpl> {
    @Autowired
    public ServiceDeParaItensNotaPropriaImpl(DaoDeParaItensNotaPropriaImpl dao) {
        super(dao);
    }

    public DeParaItensNotaPropria getDePara(String codigoProduto, Cliente cliente, String cstIcms) {
        return ((DaoDeParaItensNotaPropriaImpl)this.getDao()).getDePara(codigoProduto, cliente, cstIcms);
    }

    public DeParaItensNotaPropria getDePara(String codigoProduto, Cliente cliente) {
        return ((DaoDeParaItensNotaPropriaImpl)this.getDao()).getDePara(codigoProduto, cliente);
    }

    public DeParaItensNotaPropria getDePara(String codigoProduto, String descricao, UnidadeFatCliente unid, String cstIcms, NaturezaOperacao nat, Empresa emp) {
        ServiceModeloFiscalImpl serviceMod = (ServiceModeloFiscalImpl)Context.get(ServiceModeloFiscalImpl.class);
        ServiceProdutoImpl serviceProd = (ServiceProdutoImpl)Context.get(ServiceProdutoImpl.class);
        ServiceIncidenciaIcmsImpl serviceInc = (ServiceIncidenciaIcmsImpl)Context.get(ServiceIncidenciaIcmsImpl.class);
        ServiceProdutoImpl serviceProduto = (ServiceProdutoImpl)Context.get(ServiceProdutoImpl.class);
        DeParaItensNotaPropria depara = this.getDePara(codigoProduto, unid.getCliente(), cstIcms);
        if (depara != null) {
            return depara;
        }
        IncidenciaIcms inc = serviceInc.findByCodigo(cstIcms);
        depara = this.getDePara(codigoProduto, unid.getCliente());
        if (depara != null) {
            if (ToolMethods.isEquals((Object)depara.getModeloFiscal().getModeloFiscalIcms().getIncidenciaIcms(), (Object)cstIcms)) {
                depara.setCstIcms(cstIcms);
                return this.saveOrUpdate(depara);
            }
            ModeloFiscal mod = serviceMod.getFirst(depara.getProduto(), unid.getCategoriaPessoa(), unid.getPessoa().getEndereco().getCidade().getUf(), nat, unid.getPessoa().getComplemento().getCnpj(), unid.getPessoa().getComplemento().getContribuinteEstado(), unid.getPessoa().getComplemento().getHabilitarSuframa(), emp, inc);
            if (mod == null) {
                return depara;
            }
            DeParaItensNotaPropria novo = new DeParaItensNotaPropria();
            novo.setCliente(depara.getCliente());
            novo.setCodigo(depara.getCodigo());
            novo.setCstIcms(cstIcms);
            novo.setDescricao(depara.getDescricao());
            novo.setNaturezaOperacao(nat);
            novo.setProduto(depara.getProduto());
            novo.setModeloFiscal(mod);
            return novo;
        }
        DeParaItensNotaPropria novo = new DeParaItensNotaPropria();
        novo.setCliente(unid.getCliente());
        novo.setCodigo(codigoProduto);
        novo.setCstIcms(cstIcms);
        novo.setDescricao(descricao);
        novo.setNaturezaOperacao(nat);
        Produto prod = serviceProd.getByCodigoAuxiliar(codigoProduto);
        novo.setProduto(prod);
        if (prod != null) {
            ModeloFiscal mod = serviceMod.getFirst(prod, unid.getCategoriaPessoa(), unid.getPessoa().getEndereco().getCidade().getUf(), nat, unid.getPessoa().getComplemento().getCnpj(), unid.getPessoa().getComplemento().getContribuinteEstado(), unid.getPessoa().getComplemento().getHabilitarSuframa(), emp, inc);
            novo.setModeloFiscal(mod);
        }
        return novo;
    }
}

