/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.detalhamentoimpostos;

import com.touchcomp.basementor.constants.enums.dctf.EnumConstTipoDCTF;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostos;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostosImp;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.vo.detalhamentoimpostos.web.DTOImportacaoMIT;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SCompModuloImportacaoTributos
extends ServiceGenericImpl {
    public File exportacaoMIT(DetalhamentoImpostos vo) throws ExceptionIO {
        DTOImportacaoMIT data = new DTOImportacaoMIT();
        data.setPeriodoApuracao(this.getPeriodoApuracao(vo));
        data.setDadosIniciais(this.getDadosApuracao(vo));
        DTOImportacaoMIT.DTOImportacaoMITDebitos debitos = new DTOImportacaoMIT.DTOImportacaoMITDebitos();
        if (SCompModuloImportacaoTributos.isWithData(vo.getImpostos())) {
            List<DetalhamentoImpostosImp> irpj = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.IRPJ.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> csll = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.CSLL.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> irrf = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.IRRF.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> ipi = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.IPI.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> iof = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.IOF.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> pis = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.PIS_PASEP.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> cofins = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.COFINS.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> cide = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.CIDE.getValue())).collect(Collectors.toList());
            List<DetalhamentoImpostosImp> ret = vo.getImpostos().stream().filter(i -> TMethods.isEquals((Object)i.getTipoImposto(), (Object)EnumConstTipoDCTF.RET.getValue())).collect(Collectors.toList());
            debitos.setIrpj(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(irpj)));
            debitos.setCsll(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(csll)));
            debitos.setIrrf(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(irrf)));
            debitos.setIpi(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(ipi)));
            debitos.setIof(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(iof)));
            debitos.setPisPasep(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(pis)));
            debitos.setCofins(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(cofins)));
            debitos.setContribuicoesDiversas(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(cide)));
            debitos.setRetPagamentoUnificado(new DTOImportacaoMIT.DTOImportacaoMITListaDebitos(this.getDTODebitos(ret)));
            data.setDebitos(debitos);
        }
        String fileName = "impostos_dctf_" + String.valueOf(data.getPeriodoApuracao().getMesApuracao()) + "_" + String.valueOf(data.getPeriodoApuracao().getAnoApuracao());
        File file = ToolFile.createTempFile((String)fileName, (String)".json");
        ToolFile.writeStringInFile((File)file, (String)ToolJson.toJson((Object)data));
        return file;
    }

    public DTOImportacaoMIT.DTOImportacaoMITPeriodoApuracao getPeriodoApuracao(DetalhamentoImpostos vo) {
        DTOImportacaoMIT.DTOImportacaoMITPeriodoApuracao periodo = new DTOImportacaoMIT.DTOImportacaoMITPeriodoApuracao();
        if (this.isNotNull(vo.getPeriodo()).booleanValue()) {
            periodo.setAnoApuracao(Integer.valueOf(ToolDate.getYearFromDate((Date)vo.getPeriodo())));
            periodo.setMesApuracao(Integer.valueOf(ToolDate.getMonthFromDate((Date)vo.getPeriodo()) + 1));
        }
        return periodo;
    }

    public DTOImportacaoMIT.DTOImportacaoMITDadosIniciais getDadosApuracao(DetalhamentoImpostos vo) {
        DTOImportacaoMIT.DTOImportacaoMITDadosIniciais dados = new DTOImportacaoMIT.DTOImportacaoMITDadosIniciais();
        if (this.isNotNull(vo.getQualificacaoPj()).booleanValue() && ToolString.isAIntegerNumber((String)vo.getQualificacaoPj().getCodigo())) {
            dados.setQualificacaoPj(Integer.valueOf(vo.getQualificacaoPj().getCodigo()));
        }
        if (this.isNotNull(vo.getRegimePisCofins()).booleanValue() && ToolString.isAIntegerNumber((String)vo.getRegimePisCofins().getCodigo())) {
            dados.setRegimePisCofins(Integer.valueOf(vo.getRegimePisCofins().getCodigo()));
        }
        if (this.isNotNull(vo.getTributacaoLucro()).booleanValue() && ToolString.isAIntegerNumber((String)vo.getTributacaoLucro().getCodigo())) {
            dados.setTributacaoLucro(Integer.valueOf(vo.getTributacaoLucro().getCodigo()));
        }
        if (this.isNotNull(vo.getVariacoesMonetarias()).booleanValue() && ToolString.isAIntegerNumber((String)vo.getVariacoesMonetarias().getCodigo())) {
            dados.setVariacoesMonetarias(Integer.valueOf(vo.getVariacoesMonetarias().getCodigo()));
        }
        dados.setResponsavelApuracao(this.getResponsavelAp(vo));
        return dados;
    }

    public DTOImportacaoMIT.DTOImportacaoMITResponsavelAp getResponsavelAp(DetalhamentoImpostos vo) {
        DTOImportacaoMIT.DTOImportacaoMITResponsavelAp responsavel = new DTOImportacaoMIT.DTOImportacaoMITResponsavelAp();
        if (TMethods.isNotNull((Object)vo.getPessoa()).booleanValue()) {
            responsavel.setCpfResponsavel(vo.getPessoa().getComplemento().getCnpj());
            responsavel.setEmailResponsavel(vo.getPessoa().getComplemento().getEmailPrincipal());
        }
        DTOImportacaoMIT.DTOImportacaoMITRegistroCrc registro = new DTOImportacaoMIT.DTOImportacaoMITRegistroCrc();
        registro.setNumRegistro(vo.getRegistroCRC());
        if (TMethods.isNotNull((Object)vo.getUfExpedicaoCrc()).booleanValue()) {
            registro.setUfRegistro(vo.getUfExpedicaoCrc().getSigla());
        }
        responsavel.setRegistroCrc(registro);
        DTOImportacaoMIT.DTOImportacaoMITTelResponsavel telResponsavel = new DTOImportacaoMIT.DTOImportacaoMITTelResponsavel();
        String telefone = vo.getPessoa().getComplemento().getFone1();
        if (!TMethods.isStrWithData((String)telefone)) {
            telefone = vo.getPessoa().getComplemento().getCel1();
        }
        if (TMethods.isStrWithData((String)telefone)) {
            telResponsavel.setDdd(telefone.substring(0, 2));
            telResponsavel.setNumTelefone(telefone.substring(2, telefone.length()));
        }
        responsavel.setTelResponsavel(telResponsavel);
        return responsavel;
    }

    public List<DTOImportacaoMIT.DTOImportacaoMITDebito> getDTODebitos(List<DetalhamentoImpostosImp> impostos) {
        ArrayList<DTOImportacaoMIT.DTOImportacaoMITDebito> listaDebitos = new ArrayList<DTOImportacaoMIT.DTOImportacaoMITDebito>();
        if (SCompModuloImportacaoTributos.isWithData(impostos)) {
            for (DetalhamentoImpostosImp imp : impostos) {
                DTOImportacaoMIT.DTOImportacaoMITDebito dto = new DTOImportacaoMIT.DTOImportacaoMITDebito();
                dto.setCnpjEstabelecimento(imp.getCnpj());
                if (this.isNotNull(imp.getCodigoReceita()).booleanValue()) {
                    dto.setCodigoDebito(imp.getCodigoReceita().getCodigo());
                }
                dto.setIdDebito(imp.getIdentificador());
                dto.setValorDebito(imp.getDebito());
                listaDebitos.add(dto);
            }
        }
        return listaDebitos;
    }
}

