/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.detalhamentoimpostos;

import com.touchcomp.basementor.constants.enums.dctf.EnumConstTipoDCTF;
import com.touchcomp.basementor.model.vo.ApuracaoCSLLIRPJ;
import com.touchcomp.basementor.model.vo.ApuracaoCSLLReal;
import com.touchcomp.basementor.model.vo.ApuracaoIPI;
import com.touchcomp.basementor.model.vo.ApuracaoIRPJReal;
import com.touchcomp.basementor.model.vo.ApuracaoPisCofins;
import com.touchcomp.basementor.model.vo.ContribOutrasEntidadesFundos;
import com.touchcomp.basementor.model.vo.ContribPrevPatronal;
import com.touchcomp.basementor.model.vo.ContribuicaoPrevSegurados;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostoIrrf;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostos;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostosFgts;
import com.touchcomp.basementor.model.vo.DetalhamentoImpostosImp;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoDetalhamentoImpostosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.aberturaperiodo.ServiceAberturaPeriodoImpl;
import com.touchcomp.basementorservice.service.impl.apuracaocsllirpj.ServiceApuracaoCSLLIRPJImpl;
import com.touchcomp.basementorservice.service.impl.apuracaoipi.ServiceApuracaoIpiImpl;
import com.touchcomp.basementorservice.service.impl.apuracaopiscofins.ServiceApuracaoPisCofinsImpl;
import com.touchcomp.basementorservice.service.impl.apuracaoreinf.ServiceApuracaoReinfImpl;
import com.touchcomp.basementorservice.service.impl.calculoinssempresa.ServiceCalculoInssEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.detalhamentoimpostos.SCompModuloImportacaoTributos;
import com.touchcomp.basementorservice.service.impl.empresacontabilidade.ServiceEmpresaContabilidadeImpl;
import com.touchcomp.basementorservice.service.impl.periodoferias.ServicePeriodoFeriasImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.apuracaoimpostosfederais.web.DTOApuracaoImpostosFederais;
import com.touchcomp.touchvomodel.vo.detalhamentoimpostos.web.DTODetalhamentoImpostos;
import com.touchcomp.touchvomodel.vo.detalhamentoimpostos.web.DTODetalhamentoImpostosV2;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceDetalhamentoImpostoImpl
extends ServiceGenericEntityImpl<DetalhamentoImpostos, Long, DaoDetalhamentoImpostosImpl> {
    @Autowired
    private ServiceCalculoInssEmpresaImpl serviceCalculoInssEmpresaImpl;
    @Autowired
    private ServiceApuracaoReinfImpl serviceApuracaoReinfImpl;
    @Autowired
    private ServiceAberturaPeriodoImpl serviceAberturaPeriodoImpl;
    @Autowired
    private ServiceRecisaoImpl serviceRecisaoImpl;
    @Autowired
    private ServicePeriodoFeriasImpl servicePeriodoFeriasImpl;
    @Autowired
    private ServiceApuracaoCSLLIRPJImpl serviceApuracaoCSLLIRPJ;
    @Autowired
    private ServiceApuracaoIpiImpl serviceApuracaoIpi;
    @Autowired
    private ServiceApuracaoPisCofinsImpl serviceApuracaoPisCofins;
    @Autowired
    private ServiceEmpresaContabilidadeImpl serviceEmpresaContabilidade;
    @Autowired
    private SCompModuloImportacaoTributos mit;

    @Autowired
    public ServiceDetalhamentoImpostoImpl(DaoDetalhamentoImpostosImpl genericDao) {
        super(genericDao);
    }

    @Override
    public DetalhamentoImpostos beforeSave(DetalhamentoImpostos vo) {
        vo.setPeriodo(ToolDate.getDataInicial((Date)vo.getPeriodo()));
        if (ServiceDetalhamentoImpostoImpl.isWithData(vo.getImpostos())) {
            vo.getImpostos().forEach(i -> i.setDetalhamentoImpostos(vo));
        }
        return vo;
    }

    public DTODetalhamentoImpostos getDetalhamentoImpostos(Long periodo, Long grupoEmpresa) {
        Date dataPeriodo = new Date(periodo);
        if (this.isNull(dataPeriodo).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1984.001", new Object[]{periodo}));
        }
        DTOApuracaoImpostosFederais apuracaoImpostosFederais = new DTOApuracaoImpostosFederais();
        DTODetalhamentoImpostos dto = new DTODetalhamentoImpostos();
        dto.setApuracaoImpostosFederais(apuracaoImpostosFederais);
        this.calcularInssEmpresa(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        this.calcularReinf4020e4020NI(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        this.calcularReinf4010e4040(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        this.calcularReinf2010(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        this.calcularAberturaPeriodo(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        this.calcularRecisao(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        this.calcularPeriodoFerias(apuracaoImpostosFederais, ToolDate.getFirtDateOnMonth((Date)dataPeriodo), grupoEmpresa);
        return dto;
    }

    private void calcularInssEmpresa(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        List<HashMap> calculoInssEmpresa = this.serviceCalculoInssEmpresaImpl.getDadosInssByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        for (HashMap m : calculoInssEmpresa) {
            apuracaoImpostosFederais.setTotalInssFuncionario((Double)m.get("valorTotalInssFunc"));
            apuracaoImpostosFederais.setTotalInssIndividual((Double)m.get("vlrContribuinteIndividual"));
            apuracaoImpostosFederais.setTotalInssFrete((Double)m.get("vlrTotalAutonomoFrete"));
            apuracaoImpostosFederais.setTotalInssFuncionarioEmpresa((Double)m.get("valorTotalInssEmpresa"));
            apuracaoImpostosFederais.setTotalInssIndividualEmpresa((Double)m.get("vlrTotalAutonomo"));
            apuracaoImpostosFederais.setTotalInssFreteEmpresa((Double)m.get("vlrAutonomoFreteEmpresa"));
            apuracaoImpostosFederais.setTotalAposentadoriaEspecial15((Double)m.get("valorAposentadoriaEspecial15"));
            apuracaoImpostosFederais.setTotalAposentadoriaEspecial20((Double)m.get("valorAposentadoriaEspecial20"));
            apuracaoImpostosFederais.setTotalAposentadoriaEspecial((Double)m.get("valorAposentadoriaEspecial"));
            apuracaoImpostosFederais.setTotalFunruralFisica((Double)m.get("valorFunruralFisica"));
            apuracaoImpostosFederais.setTotalFunruralJuridica((Double)m.get("valorFunruralJuridica"));
            apuracaoImpostosFederais.setTotalFunruralFisicaOE((Double)m.get("valorFunruralFisicaOE"));
            apuracaoImpostosFederais.setTotalFunruralJuridicaOE((Double)m.get("valorFunruralJuridicaOE"));
            apuracaoImpostosFederais.setTotalInssTerceiros((Double)m.get("vlrTerceiros"));
            apuracaoImpostosFederais.setTotalRat((Double)m.get("valorTotalRat"));
            apuracaoImpostosFederais.setTotalSestSenac((Double)m.get("vlrTotalSescSenac"));
            apuracaoImpostosFederais.setTotalSalarioFamilia((Double)m.get("vlrSalarioFamilia"));
            apuracaoImpostosFederais.setTotalSalarioMaternidade((Double)m.get("salarioMaternidade"));
        }
    }

    private void calcularReinf4020e4020NI(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        List<HashMap> itensReinf4020 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4020ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        List<HashMap> itensReinf4020NI = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4020NIByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        itensReinf4020.addAll(itensReinf4020NI);
        Double totalCofins = 0.0;
        Double totalPis = 0.0;
        Double totalCsll = 0.0;
        Double totalAgregadoReinf = 0.0;
        Double totalIrpj = 0.0;
        for (HashMap m : itensReinf4020) {
            totalCofins = totalCofins + (this.isNotNull(m.get("valorCofins")) != false ? (Double)m.get("valorCofins") : 0.0);
            totalPis = totalPis + (this.isNotNull(m.get("valorPis")) != false ? (Double)m.get("valorPis") : 0.0);
            totalCsll = totalCsll + (this.isNotNull(m.get("valorCsll")) != false ? (Double)m.get("valorCsll") : 0.0);
            totalAgregadoReinf = totalAgregadoReinf + (this.isNotNull(m.get("valorAgregado")) != false ? (Double)m.get("valorAgregado") : 0.0);
            totalIrpj = totalIrpj + (this.isNotNull(m.get("valorIrrf")) != false ? (Double)m.get("valorIrrf") : 0.0);
        }
        apuracaoImpostosFederais.setTotalCofins(totalCofins);
        apuracaoImpostosFederais.setTotalPis(totalPis);
        apuracaoImpostosFederais.setTotalCsll(totalCsll);
        apuracaoImpostosFederais.setTotalAgregadoReinf(totalAgregadoReinf);
        apuracaoImpostosFederais.setTotalIrpj(totalIrpj);
    }

    private void calcularReinf4010e4040(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        Double itensReinf4010 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4010ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        Double itensReinf4040 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4040ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        Double irrfTerceiros = 0.0;
        irrfTerceiros = this.isNotNull(itensReinf4010) != false ? itensReinf4010 : 0.0;
        irrfTerceiros = irrfTerceiros + (this.isNotNull(itensReinf4040) != false ? itensReinf4040 : 0.0);
        apuracaoImpostosFederais.setIrrfTerceiros(irrfTerceiros);
    }

    private void calcularReinf2010(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        List<HashMap> itensReinf2010 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf2010ByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        List dtoItensReinf2010 = itensReinf2010.stream().map(i -> {
            DTOApuracaoImpostosFederais.DTOItensReinf2010 item = new DTOApuracaoImpostosFederais.DTOItensReinf2010();
            item.setCnpjTerceiros2010((String)i.get("cnpj"));
            item.setTotalInssLei9711((Double)i.get("vrInss"));
            return item;
        }).collect(Collectors.toList());
        apuracaoImpostosFederais.setItensReinf2010(dtoItensReinf2010);
    }

    private void calcularAberturaPeriodo(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        List<HashMap> aberturaPeriodo = this.serviceAberturaPeriodoImpl.getDetalhamentoImpostoByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        List<HashMap> aberturaPeriodoIrrf = this.serviceAberturaPeriodoImpl.getDetalhamentoImpostoByDataPagamentoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        for (HashMap m : aberturaPeriodo) {
            apuracaoImpostosFederais.setPisSobreFolha((Double)m.get("valorPis"));
            Double fgtsMensal = this.isNotNull(m.get("vrFgtsSalario")) != false ? (Double)m.get("vrFgtsSalario") : 0.0;
            fgtsMensal = fgtsMensal + (this.isNotNull(m.get("vrFgtsFerias")) != false ? (Double)m.get("vrFgtsFerias") : 0.0);
            fgtsMensal = fgtsMensal + (this.isNotNull(m.get("vrFgts13Sal")) != false ? (Double)m.get("vrFgts13Sal") : 0.0);
            apuracaoImpostosFederais.setFgtsMensal(fgtsMensal);
        }
        for (HashMap m : aberturaPeriodoIrrf) {
            Double irrfSobreFolha = this.isNotNull(m.get("vrIrrfSalario")) != false ? (Double)m.get("vrIrrfSalario") : 0.0;
            irrfSobreFolha = irrfSobreFolha + (this.isNotNull(m.get("vrIrrf13Sal")) != false ? (Double)m.get("vrIrrf13Sal") : 0.0);
            apuracaoImpostosFederais.setIrrfSobreFolha(irrfSobreFolha);
        }
    }

    private void calcularRecisao(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        List<HashMap> recisaoVlrTotalGrrf = this.serviceRecisaoImpl.getDetalhamentoImpostoByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        for (HashMap m : recisaoVlrTotalGrrf) {
            apuracaoImpostosFederais.setFgtsRescisorio((Double)m.get("vlrTotalGrrf"));
            apuracaoImpostosFederais.setIrrfRescisorioSalario((Double)m.get("vrlIrrf"));
            apuracaoImpostosFederais.setIrrfRescisorio13((Double)m.get("vlrIrrf13"));
        }
    }

    private void calcularPeriodoFerias(DTOApuracaoImpostosFederais apuracaoImpostosFederais, Date dataPeriodo, Long grupoEmpresa) {
        Double periodoFeriasVrIrrfFerias = this.servicePeriodoFeriasImpl.getDetalhamentoImpostoByPeriodoGrupoEmpresa(dataPeriodo, grupoEmpresa);
        apuracaoImpostosFederais.setIrrfSobreFerias(Double.valueOf(this.isNotNull(periodoFeriasVrIrrfFerias) != false ? periodoFeriasVrIrrfFerias : 0.0));
    }

    private void apurarValoresCsllIrpj(DetalhamentoImpostos vo, Date periodo, Empresa empresa) {
        ApuracaoCSLLIRPJ apuracaoCSLLIRPJ = this.serviceApuracaoCSLLIRPJ.getApuracaoCSLLIRPJPorPeridoAndEmpresa(periodo, empresa);
        if (this.isNotNull(apuracaoCSLLIRPJ).booleanValue()) {
            DetalhamentoImpostosImp i;
            if (ServiceDetalhamentoImpostoImpl.isWithData(apuracaoCSLLIRPJ.getApuracaoIRPJReal())) {
                ArrayList<DetalhamentoImpostosImp> irpj = new ArrayList<DetalhamentoImpostosImp>();
                for (ApuracaoIRPJReal airpj : apuracaoCSLLIRPJ.getApuracaoIRPJReal()) {
                    i = new DetalhamentoImpostosImp();
                    i.setTipoImposto(Short.valueOf(EnumConstTipoDCTF.IRPJ.getValue()));
                    i.setDebito(airpj.getValorIRPJRecolher());
                    i.setValorSuspenso(Double.valueOf(0.0));
                    i.setSaldoPagar(airpj.getValorIRPJRecolher());
                    irpj.add(i);
                }
                vo.getImpostos().addAll(irpj);
            }
            if (ServiceDetalhamentoImpostoImpl.isWithData(apuracaoCSLLIRPJ.getApuracaoCSLLReal())) {
                ArrayList<DetalhamentoImpostosImp> csll = new ArrayList<DetalhamentoImpostosImp>();
                for (ApuracaoCSLLReal acsll : apuracaoCSLLIRPJ.getApuracaoCSLLReal()) {
                    i = new DetalhamentoImpostosImp();
                    i.setTipoImposto(Short.valueOf(EnumConstTipoDCTF.CSLL.getValue()));
                    i.setDebito(acsll.getValorCSLL());
                    i.setValorSuspenso(Double.valueOf(0.0));
                    i.setSaldoPagar(acsll.getValorCSLL());
                    csll.add(i);
                }
                vo.getImpostos().addAll(csll);
            }
        }
    }

    private void apurarValoresIpi(DetalhamentoImpostos vo, Date periodo, Empresa empresa) {
        List<ApuracaoIPI> apuracaoIpi = this.serviceApuracaoIpi.findApuracaoIPIPeriodo(periodo, empresa);
        if (ServiceDetalhamentoImpostoImpl.isWithData(apuracaoIpi)) {
            ArrayList<DetalhamentoImpostosImp> ipi = new ArrayList<DetalhamentoImpostosImp>();
            for (ApuracaoIPI aipi : apuracaoIpi) {
                DetalhamentoImpostosImp i = new DetalhamentoImpostosImp();
                i.setCnpj(aipi.getEmpresa().getPessoa().getComplemento().getCnpj());
                i.setTipoImposto(Short.valueOf(EnumConstTipoDCTF.IPI.getValue()));
                i.setDebito(aipi.getSaldoDevedor());
                i.setValorSuspenso(Double.valueOf(0.0));
                i.setSaldoPagar(aipi.getSaldoDevedor());
                ipi.add(i);
            }
            vo.getImpostos().addAll(ipi);
        }
    }

    private void apurarValoresPisCofins(DetalhamentoImpostos vo, Date periodo, Empresa empresa) {
        List<ApuracaoPisCofins> apuracaoPisCofins = this.serviceApuracaoPisCofins.findApuracaoPisCofinsPeriodo(periodo, empresa.getEmpresaDados().getGrupoEmpresa());
        if (ServiceDetalhamentoImpostoImpl.isWithData(apuracaoPisCofins)) {
            ArrayList<DetalhamentoImpostosImp> pis = new ArrayList<DetalhamentoImpostosImp>();
            ArrayList<DetalhamentoImpostosImp> cofins = new ArrayList<DetalhamentoImpostosImp>();
            for (ApuracaoPisCofins apPisCofins : apuracaoPisCofins) {
                DetalhamentoImpostosImp i;
                if (this.isNotNull(apPisCofins.getApuracaoPis()).booleanValue()) {
                    i = new DetalhamentoImpostosImp();
                    i.setTipoImposto(Short.valueOf(EnumConstTipoDCTF.PIS_PASEP.getValue()));
                    i.setValorSuspenso(Double.valueOf(0.0));
                    if (this.isNotNull(apPisCofins.getApuracaoPis().getTitulo()).booleanValue()) {
                        i.setDebito(apPisCofins.getApuracaoPis().getTitulo().getValor());
                        i.setSaldoPagar(apPisCofins.getApuracaoPis().getTitulo().getValor());
                    }
                    pis.add(i);
                }
                if (!this.isNotNull(apPisCofins.getApuracaoCofins()).booleanValue()) continue;
                i = new DetalhamentoImpostosImp();
                i.setTipoImposto(Short.valueOf(EnumConstTipoDCTF.COFINS.getValue()));
                i.setValorSuspenso(Double.valueOf(0.0));
                if (this.isNotNull(apPisCofins.getApuracaoCofins().getTitulo()).booleanValue()) {
                    i.setDebito(apPisCofins.getApuracaoCofins().getTitulo().getValor());
                    i.setSaldoPagar(apPisCofins.getApuracaoCofins().getTitulo().getValor());
                }
                cofins.add(i);
            }
            vo.getImpostos().addAll(pis);
            vo.getImpostos().addAll(cofins);
        }
    }

    private void apurarValoresInss(DetalhamentoImpostos vo, Date periodo, Empresa empresa) {
        List<HashMap> calculoInssEmpresa = this.serviceCalculoInssEmpresaImpl.getDadosInssByPeriodoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador());
        if (ServiceDetalhamentoImpostoImpl.isWithData(calculoInssEmpresa)) {
            for (HashMap m : calculoInssEmpresa) {
                ContribuicaoPrevSegurados inss = new ContribuicaoPrevSegurados();
                inss.setTotalInssFuncionario(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorTotalInssFunc"))));
                inss.setTotalInssIndividual(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrContribuinteIndividual"))));
                inss.setTotalInssFrete(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrTotalAutonomoFrete"))));
                vo.setContPrevSeg(inss);
                ContribPrevPatronal inssFunc = new ContribPrevPatronal();
                inssFunc.setTotalInssFuncionarioEmpresa(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorTotalInssEmpresa"))));
                inssFunc.setTotalInssIndividualEmpresa(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrTotalAutonomo"))));
                inssFunc.setTotalInssFreteEmpresa(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrAutonomoFreteEmpresa"))));
                inssFunc.setTotalInssLei9711(Double.valueOf(0.0));
                vo.setContPrevPatr(inssFunc);
                ContribOutrasEntidadesFundos inssOutasEnt = new ContribOutrasEntidadesFundos();
                inssOutasEnt.setTotalAposentadoriaEspecial15(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorAposentadoriaEspecial15"))));
                inssOutasEnt.setTotalAposentadoriaEspecial20(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorAposentadoriaEspecial20"))));
                inssOutasEnt.setTotalAposentadoriaEspecial(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorAposentadoriaEspecial"))));
                inssOutasEnt.setTotalFunruralFisica(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorFunruralFisica"))));
                inssOutasEnt.setTotalFunruralJuridica(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorFunruralJuridica"))));
                inssOutasEnt.setTotalFunruralFisicaOE(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorFunruralFisicaOE"))));
                inssOutasEnt.setTotalFunruralJuridicaOE(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorFunruralJuridicaOE"))));
                inssOutasEnt.setTotalInssTerceiros(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrTerceiros"))));
                inssOutasEnt.setTotalRat(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorTotalRat"))));
                inssOutasEnt.setTotalSestSenac(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrTotalSescSenac"))));
                inssOutasEnt.setTotalSalarioFamilia(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrSalarioFamilia"))));
                inssOutasEnt.setTotalSalarioMaternidade(ToolNumber.asZeroIfNull((Double)((Double)m.get("salarioMaternidade"))));
                vo.setContOutEntidFund(inssOutasEnt);
            }
        }
    }

    private void apurarValoresFgtsIrrf(DetalhamentoImpostos vo, Date periodo, Empresa empresa) {
        List<HashMap> aberturaPeriodo;
        DetalhamentoImpostoIrrf irrf = new DetalhamentoImpostoIrrf();
        DetalhamentoImpostosFgts fgts = new DetalhamentoImpostosFgts();
        List<HashMap> recisaoVlrTotalGrrf = this.serviceRecisaoImpl.getDetalhamentoImpostoByPeriodoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador());
        if (ServiceDetalhamentoImpostoImpl.isWithData(recisaoVlrTotalGrrf)) {
            for (HashMap m : recisaoVlrTotalGrrf) {
                fgts.setFgtsRescisorio(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrTotalGrrf"))));
                irrf.setIrrfRescisorio(ToolNumber.asZeroIfNull((Double)((Double)m.get("vrlIrrf"))));
                irrf.setIrrfRescisorio13(ToolNumber.asZeroIfNull((Double)((Double)m.get("vlrIrrf13"))));
            }
        }
        if (ServiceDetalhamentoImpostoImpl.isWithData(aberturaPeriodo = this.serviceAberturaPeriodoImpl.getDetalhamentoImpostoByPeriodoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador()))) {
            for (HashMap m : aberturaPeriodo) {
                Double fgtsMensal = ToolNumber.asZeroIfNull((Double)((Double)m.get("vrFgtsSalario")));
                fgtsMensal = fgtsMensal + ToolNumber.asZeroIfNull((Double)((Double)m.get("vrFgtsFerias")));
                fgtsMensal = fgtsMensal + ToolNumber.asZeroIfNull((Double)((Double)m.get("vrFgts13Sal")));
                fgts.setFgtsMensal(fgtsMensal);
                vo.setTotalPisSobreFolha(ToolNumber.asZeroIfNull((Double)((Double)m.get("valorPis"))));
            }
        }
        vo.setTotalizadoresFgts(fgts);
        this.apurarValoresIrrf(irrf, periodo, empresa);
        vo.setTotalizadoresIrrf(irrf);
    }

    private void apurarValoresIrrf(DetalhamentoImpostoIrrf irrf, Date periodo, Empresa empresa) {
        List<HashMap> aberturaPeriodoIrrf = this.serviceAberturaPeriodoImpl.getDetalhamentoImpostoByDataPagamentoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador());
        if (ServiceDetalhamentoImpostoImpl.isWithData(aberturaPeriodoIrrf)) {
            for (HashMap m : aberturaPeriodoIrrf) {
                Double irrfSobreFolha = ToolNumber.asZeroIfNull((Double)((Double)m.get("vrIrrfSalario")));
                irrfSobreFolha = irrfSobreFolha + ToolNumber.asZeroIfNull((Double)((Double)m.get("vrIrrf13Sal")));
                irrf.setIrrfSobreFolha(irrfSobreFolha);
            }
        }
        Double itensReinf4010 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4010ByPeriodoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador());
        Double itensReinf4040 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4040ByPeriodoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador());
        Double irrfTerceiros = ToolNumber.asZeroIfNull((Double)itensReinf4010);
        irrfTerceiros = irrfTerceiros + ToolNumber.asZeroIfNull((Double)itensReinf4040);
        irrf.setIrrfTerceiros(irrfTerceiros);
        Double periodoFeriasVrIrrfFerias = this.servicePeriodoFeriasImpl.getDetalhamentoImpostoByPeriodoGrupoEmpresa(periodo, empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador());
        irrf.setIrrfSobreFerias(ToolNumber.asZeroIfNull((Double)periodoFeriasVrIrrfFerias));
    }

    private void calcularTotalAgregadoReinf(DetalhamentoImpostos vo) {
        if (this.isNotNull(vo.getEmpresa()).booleanValue() && this.isNotNull(vo.getPeriodo()).booleanValue()) {
            List<HashMap> itensReinf4020 = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4020ByPeriodoGrupoEmpresa(vo.getPeriodo(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador());
            List<HashMap> itensReinf4020NI = this.serviceApuracaoReinfImpl.getDadosDetalhamentoImpostoItensReinf4020NIByPeriodoGrupoEmpresa(vo.getPeriodo(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador());
            itensReinf4020.addAll(itensReinf4020NI);
            Double totalAgregadoReinf = 0.0;
            for (HashMap m : itensReinf4020) {
                totalAgregadoReinf = totalAgregadoReinf + ToolNumber.asZeroIfNull((Double)((Double)m.get("valorAgregado")));
            }
            vo.setTotalAgregadoReinf(totalAgregadoReinf);
        }
    }

    public DTODetalhamentoImpostosV2 carregarApuracao(Date periodo, Empresa empresa) {
        EmpresaContabilidade empresaCont = this.serviceEmpresaContabilidade.findByEmpresa(empresa);
        DetalhamentoImpostos vo = new DetalhamentoImpostos();
        vo.setPeriodo(periodo);
        vo.setRegistroCRC(empresaCont.getCrc());
        vo.setUfExpedicaoCrc(empresaCont.getUfExpedicaoCrc());
        vo.setPessoa(empresaCont.getPessoa());
        vo.setEmpresa(empresa);
        this.apurarValoresCsllIrpj(vo, periodo, empresa);
        this.apurarValoresIpi(vo, periodo, empresa);
        this.apurarValoresPisCofins(vo, periodo, empresa);
        this.apurarValoresInss(vo, periodo, empresa);
        this.apurarValoresFgtsIrrf(vo, periodo, empresa);
        this.calcularTotalizadores(vo);
        return this.buildToDTOGeneric(vo, DTODetalhamentoImpostosV2.class);
    }

    public void calcularTotalizadores(DetalhamentoImpostos vo) {
        if (this.isNotNull(vo).booleanValue()) {
            Double totalApurado = 0.0;
            Double totalDeducoes = 0.0;
            if (this.isNotNull(vo.getContPrevSeg()).booleanValue()) {
                Double totalPrevSeg = ToolNumber.asZeroIfNull((Double)vo.getContPrevSeg().getTotalInssFrete());
                totalPrevSeg = totalPrevSeg + ToolNumber.asZeroIfNull((Double)vo.getContPrevSeg().getTotalInssFuncionario());
                totalPrevSeg = totalPrevSeg + ToolNumber.asZeroIfNull((Double)vo.getContPrevSeg().getTotalInssIndividual());
                vo.setTotalCpsPrevSeg(ToolFormatter.arrredondarNumero((Double)totalPrevSeg, (int)2));
                totalApurado = totalApurado + totalPrevSeg;
            }
            if (this.isNotNull(vo.getContPrevPatr()).booleanValue()) {
                Double totalPatronal = ToolNumber.asZeroIfNull((Double)vo.getContPrevPatr().getTotalInssFreteEmpresa());
                totalPatronal = totalPatronal + ToolNumber.asZeroIfNull((Double)vo.getContPrevPatr().getTotalInssFuncionarioEmpresa());
                totalPatronal = totalPatronal + ToolNumber.asZeroIfNull((Double)vo.getContPrevPatr().getTotalInssIndividualEmpresa());
                totalPatronal = totalPatronal + ToolNumber.asZeroIfNull((Double)vo.getContPrevPatr().getTotalInssLei9711());
                vo.setTotalCpsPatronal(ToolFormatter.arrredondarNumero((Double)totalPatronal, (int)2));
                totalApurado = totalApurado + totalPatronal;
            }
            if (this.isNotNull(vo.getContOutEntidFund()).booleanValue()) {
                Double totalOutEnt = ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalAposentadoriaEspecial());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalAposentadoriaEspecial15());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalAposentadoriaEspecial20());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalFunruralFisica());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalFunruralFisicaOE());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalFunruralJuridica());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalFunruralJuridicaOE());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalInssTerceiros());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalRat());
                totalOutEnt = totalOutEnt + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalSestSenac());
                totalDeducoes = totalDeducoes + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalSalarioFamilia());
                totalDeducoes = totalDeducoes + ToolNumber.asZeroIfNull((Double)vo.getContOutEntidFund().getTotalSalarioMaternidade());
                vo.setTotalCpsOutrasEntidades(ToolFormatter.arrredondarNumero((Double)totalOutEnt, (int)2));
                totalApurado = totalApurado + totalOutEnt;
            }
            if (this.isNotNull(vo.getTotalizadoresIrrf()).booleanValue()) {
                Double totalIrrf = ToolNumber.asZeroIfNull((Double)vo.getTotalizadoresIrrf().getIrrfRescisorio());
                totalIrrf = totalIrrf + ToolNumber.asZeroIfNull((Double)vo.getTotalizadoresIrrf().getIrrfSobreFerias());
                totalIrrf = totalIrrf + ToolNumber.asZeroIfNull((Double)vo.getTotalizadoresIrrf().getIrrfSobreFolha());
                totalIrrf = totalIrrf + ToolNumber.asZeroIfNull((Double)vo.getTotalizadoresIrrf().getIrrfTerceiros());
                vo.setTotalIrrf(ToolFormatter.arrredondarNumero((Double)totalIrrf, (int)2));
                totalApurado = totalApurado + totalIrrf;
            }
            if (this.isNotNull(vo.getTotalizadoresFgts()).booleanValue()) {
                Double totalFgts = ToolNumber.asZeroIfNull((Double)vo.getTotalizadoresFgts().getFgtsMensal());
                totalFgts = totalFgts + ToolNumber.asZeroIfNull((Double)vo.getTotalizadoresFgts().getFgtsRescisorio());
                vo.setTotalFgts(ToolFormatter.arrredondarNumero((Double)totalFgts, (int)2));
                totalApurado = totalApurado + totalFgts;
            }
            this.calcularTotalAgregadoReinf(vo);
            totalApurado = totalApurado + vo.getTotalAgregadoReinf();
            totalApurado = totalApurado + vo.getTotalPisSobreFolha();
            vo.setTotalApurado(ToolFormatter.arrredondarNumero((Double)totalApurado, (int)2));
            vo.setTotalDeducoes(ToolFormatter.arrredondarNumero((Double)totalDeducoes, (int)2));
            vo.setTotalApuradoLiquido(Double.valueOf(totalApurado - totalDeducoes));
        }
    }

    public File exportarArquivoMIT(Long idDetalhamentoImpostos) throws ExceptionObjNotFound, ExceptionIO {
        DetalhamentoImpostos vo = (DetalhamentoImpostos)this.getOrThrow(idDetalhamentoImpostos);
        return this.mit.exportacaoMIT(vo);
    }

    public DTODetalhamentoImpostosV2.DTODetalhamentoImpostosImp novoDetalhamentoImposto(Short tipoImposto) {
        EnumConstTipoDCTF tipoImp = EnumConstTipoDCTF.get((Object)tipoImposto);
        DetalhamentoImpostosImp vo = new DetalhamentoImpostosImp();
        vo.setTipoImposto(tipoImp.getEnumId());
        return this.buildToDTOGeneric(vo, DTODetalhamentoImpostosV2.DTODetalhamentoImpostosImp.class);
    }
}

