/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.devolucaovendas;

import com.touchcomp.basementor.constants.enums.analisecustoprod.EnumAnaCustoTipoProcDevolucoes;
import com.touchcomp.basementor.model.vo.BloqueioAlteracaoEstoque;
import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.DevolucaoVendasItens;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDadosRuntime;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.helpers.impl.naturezaoperacao.HelperNaturezaOperacao;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.bloqueioalteracaoestoque.ServiceBloqueioAlteracaoEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.devolucaovendas.ServiceDevolucaoVendasImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceProcCustoDevolucaoVendasImpl
extends ServiceGenericImpl {
    final CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais;
    final ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropriaImpl;
    final ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl;
    final HelperNaturezaOperacao helperNaturezaOperacao;
    final ServiceDevolucaoVendasImpl serviceDevolucaoVendasImpl;
    final ServiceBloqueioAlteracaoEstoqueImpl serviceBloqueioAlteracaoEstoqueImpl;

    public ServiceProcCustoDevolucaoVendasImpl(CompLancamentosEntradaSaidaFiscais compLancamentosEntradaSaidaFiscais, ServiceNotaFiscalPropriaImpl serviceNotaFiscalPropriaImpl, ServiceNotaFiscalTerceirosImpl serviceNotaFiscalTerceirosImpl, HelperNaturezaOperacao helperNaturezaOperacao, ServiceDevolucaoVendasImpl serviceDevolucaoVendasImpl, ServiceBloqueioAlteracaoEstoqueImpl serviceBloqueioAlteracaoEstoqueImpl) {
        this.compLancamentosEntradaSaidaFiscais = compLancamentosEntradaSaidaFiscais;
        this.serviceNotaFiscalPropriaImpl = serviceNotaFiscalPropriaImpl;
        this.serviceNotaFiscalTerceirosImpl = serviceNotaFiscalTerceirosImpl;
        this.helperNaturezaOperacao = helperNaturezaOperacao;
        this.serviceDevolucaoVendasImpl = serviceDevolucaoVendasImpl;
        this.serviceBloqueioAlteracaoEstoqueImpl = serviceBloqueioAlteracaoEstoqueImpl;
    }

    public void reprocessarValorCustoNotasDevolucao(Date dataInicial, Date dataFinal, Empresa empresa, EnumAnaCustoTipoProcDevolucoes tipoReprocessamento) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        OpcoesContabeis opcoesContabeis = this.getSharedData().getOpcoesContabeis(empresa);
        List<DevolucaoVendas> devolucoes = this.serviceDevolucaoVendasImpl.findDevolucoesVendas(dataInicial, dataFinal, empresa);
        Date dataBaseBusca = null;
        if (this.isEquals(tipoReprocessamento, EnumAnaCustoTipoProcDevolucoes.ATUALIZAR_VALOR_CUSTO_ULT_PERIODO_FECHADO)) {
            BloqueioAlteracaoEstoque bloqueio = this.serviceBloqueioAlteracaoEstoqueImpl.getLast(empresa);
            dataBaseBusca = bloqueio.getDataBloqueio();
        }
        for (DevolucaoVendas devolucao : devolucoes) {
            if (devolucao.getNotaPropriaGerada() != null) {
                this.reprocessarValorCustoNotaPropria(devolucao.getNotaPropriaGerada(), devolucao, opcoesContabeis, dataBaseBusca);
                continue;
            }
            if (devolucao.getNotaTerceirosGerada() == null) continue;
            this.reprocessarValorCustoNotaTerceiros(devolucao.getNotaTerceirosGerada(), devolucao, opcoesContabeis, dataBaseBusca);
        }
    }

    private void reprocessarValorCustoNotaPropria(NotaFiscalPropria nota, DevolucaoVendas devolucao, OpcoesContabeis opcoes, Date dataBaseBusca) throws ExceptionInvalidData, ExceptionValidacaoDadosRuntime, ExceptionReflection {
        for (ItemNotaFiscalPropria item : nota.getItensNotaPropria()) {
            List datasDevolucoes = this.getDatasItensDevolvidos(item.getProduto(), devolucao);
            Double valorCusto = 0.0;
            Iterator iterator = datasDevolucoes.iterator();
            while (iterator.hasNext()) {
                Date dataNotaOrigem;
                Date dataConsideradaBusca = dataNotaOrigem = (Date)iterator.next();
                if (dataBaseBusca != null && dataNotaOrigem.before(dataBaseBusca)) {
                    dataConsideradaBusca = dataBaseBusca;
                }
                valorCusto = valorCusto + this.helperNaturezaOperacao.getValorSugConfNatOperacaoNFe(item.getModeloFiscal(), nota.getNaturezaOperacao(), item.getProduto(), nota.getEmpresa(), dataConsideradaBusca);
            }
            valorCusto = valorCusto / (double)datasDevolucoes.size();
            for (GradeItemNotaFiscalPropria g : item.getGradesNotaFiscalPropria()) {
                if (!(valorCusto > 0.0) || TMethods.isAffirmative((Number)item.getInfVrCustoManual())) continue;
                g.setValorCusto(valorCusto);
            }
        }
        LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(nota, opcoes);
        if (nota.getIntegracaoNotaPropriaNotas() != null) {
            nota.getIntegracaoNotaPropriaNotas().setLoteContabil(loteContabil);
        } else {
            IntegracaoNotaPropriaNotas i = new IntegracaoNotaPropriaNotas();
            i.setNotaPropria(nota);
            i.setLoteContabil(loteContabil);
            nota.setIntegracaoNotaPropriaNotas(i);
        }
        this.serviceNotaFiscalPropriaImpl.saveOrUpdate(nota);
    }

    private void reprocessarValorCustoNotaTerceiros(NotaFiscalTerceiros nota, DevolucaoVendas devolucao, OpcoesContabeis opcoes, Date dataBaseBusca) throws ExceptionInvalidData {
        for (ItemNotaTerceiros item : nota.getItemNotaTerceiros()) {
            List datasDevolucoes = this.getDatasItensDevolvidos(item.getProduto(), devolucao);
            Double valorCusto = 0.0;
            Iterator iterator = datasDevolucoes.iterator();
            while (iterator.hasNext()) {
                Date dataNotaOrigem;
                Date dataConsideradaBusca = dataNotaOrigem = (Date)iterator.next();
                if (dataBaseBusca != null && dataNotaOrigem.before(dataBaseBusca)) {
                    dataConsideradaBusca = dataBaseBusca;
                }
                valorCusto = valorCusto + this.helperNaturezaOperacao.getValorSugConfNatOperacaoNFe(item.getModeloFiscal(), item.getNaturezaOperacao(), item.getProduto(), nota.getEmpresa(), dataConsideradaBusca);
            }
            valorCusto = valorCusto / (double)datasDevolucoes.size();
            for (GradeItemNotaTerceiros g : item.getGrade()) {
                if (!(valorCusto > 0.0) || TMethods.isAffirmative((Number)item.getInfVrCustoManual())) continue;
                g.setValorCusto(valorCusto);
            }
        }
        LoteContabil loteContabil = this.compLancamentosEntradaSaidaFiscais.contabilizar(nota, opcoes);
        if (nota.getIntegracaoNotaTerceiros() != null) {
            nota.getIntegracaoNotaTerceiros().setLoteContabil(loteContabil);
        }
        this.serviceNotaFiscalTerceirosImpl.saveOrUpdate(nota);
    }

    private List getDatasItensDevolvidos(Produto produto, DevolucaoVendas devolucao) {
        ArrayList<Date> datas = new ArrayList<Date>();
        for (DevolucaoVendasItens item : devolucao.getDevolucaoItens()) {
            Date data;
            if (item.getItemNotaPropria() != null && item.getItemNotaPropria().getProduto().equals((Object)produto) && !datas.contains(data = ToolDate.dataSemHora((Date)item.getItemNotaPropria().getNotaFiscalPropria().getDataEmissaoNota()))) {
                datas.add(data);
            }
            if (item.getItemNotaTerceiros() != null && item.getItemNotaTerceiros().getProduto().equals((Object)produto) && !datas.contains(data = ToolDate.dataSemHora((Date)item.getItemNotaTerceiros().getNotaFiscalTerceiros().getDataEntrada()))) {
                datas.add(data);
            }
            if (item.getItemNFCe() == null || !item.getItemNFCe().getProduto().equals((Object)produto) || datas.contains(data = ToolDate.dataSemHora((Date)item.getItemNFCe().getNfce().getDataEmissao()))) continue;
            datas.add(data);
        }
        return datas;
    }
}

