/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.emissaoavisotrabalhado;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmissaoAvisoTrabalhado;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocTipoAvisoPrevio;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoEmissaoAvisoTrabalhadoImpl;
import com.touchcomp.basementorservice.helpers.impl.emissaoavisotrabalhado.HelperEmissaoAvisoTrabalhado;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.esoctipoavisoprevio.ServiceEsocTipoAvisoPrevioImpl;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.emissaoavisotrabalhado.web.DTOEmissaoAvisoTrabalhado;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEmissaoAvisoTrabalhadoImpl
extends ServiceGenericEntityImpl<EmissaoAvisoTrabalhado, Long, DaoEmissaoAvisoTrabalhadoImpl> {
    @Autowired
    private ServiceEsocTipoAvisoPrevioImpl serviceEsocTipoAvisoPrevio;
    @Autowired
    private ServiceColaboradorImpl serviceColaborador;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    @Autowired
    private HelperEmissaoAvisoTrabalhado helper;

    @Autowired
    public ServiceEmissaoAvisoTrabalhadoImpl(DaoEmissaoAvisoTrabalhadoImpl dao) {
        super(dao);
    }

    public DTOEmissaoAvisoTrabalhado validarDataEmissaoAviso(DTOEmissaoAvisoTrabalhado dto, WebDTOResult result) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        if (this.isNull(dto.getColaboradorIdentificador()).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1689.001", new Object[0]);
        }
        if (this.isNull(dto.getTipoAvisoIdentificador()).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1689.002", new Object[0]);
        }
        if (this.isNull(dto.getDataEmissaoAviso()).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1689.003", new Object[0]);
        }
        EsocTipoAvisoPrevio tipoAviso = (EsocTipoAvisoPrevio)this.serviceEsocTipoAvisoPrevio.getOrThrow(dto.getTipoAvisoIdentificador());
        Colaborador colaborador = (Colaborador)this.serviceColaborador.getOrThrow(dto.getColaboradorIdentificador());
        this.helper.build(dto).setDatasEmissaoAviso(colaborador, tipoAviso);
        List<FeriasColaborador> ferias = this.serviceFeriasColaborador.getFerias(dto.getColaboradorIdentificador(), dto.getDataAfastamento());
        if (TMethods.isWithData(ferias)) {
            result.setMessage(MessagesBaseMentor.getMsg((String)"M.ERP.1689.001", (Object[])new Object[0]));
        }
        return dto;
    }

    public void exclusaoEventoEmissaoAviso(EmissaoAvisoTrabalhado vo) {
        if (!TMethods.isWithData((Collection)vo.getPreEventosEsocial())) {
            List eventos = vo.getPreEventosEsocial();
            vo.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setEmissaoAviso(null);
                this.serviceEsocPreEvento.delete(e);
            }
        }
        this.delete(vo);
    }
}

