/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.empresa;

import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.ponto.model.empresaintegracao.DTOPontoEmpresaIntegracao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoEmpresaImpl;
import com.touchcomp.basementorservice.helpers.impl.centroresultado.HelperCentroResultado;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centroresultadocontfin.ServiceCentroResultadoContFinImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaOpcoes;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.DTOComboObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEmpresaImpl
extends ServiceGenericEntityImpl<Empresa, Long, DaoEmpresaImpl>
implements ServiceEmpresa {
    @Autowired
    public ServiceEmpresaImpl(DaoEmpresaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public Empresa findByCnpj(String cnpj) {
        return ((DaoEmpresaImpl)this.getGenericDao()).findByCnpj(cnpj);
    }

    public Empresa findByCnpjOrThrow(String cnpj) throws ExceptionObjNotFound {
        Empresa emp = ((DaoEmpresaImpl)this.getGenericDao()).findByCnpj(cnpj);
        this.throwIfNull(emp, (Serializable)((Object)cnpj));
        return emp;
    }

    @Override
    public Empresa get(Pessoa pessoa) {
        return ((DaoEmpresaImpl)this.getGenericDao()).get(pessoa);
    }

    public List<Empresa> get(Long idEmpresaInicial, Long idEmpresaFinal) {
        return ((DaoEmpresaImpl)this.getGenericDao()).get(idEmpresaInicial, idEmpresaFinal);
    }

    public List<DTOComboObject> getDTOEmpresasAtivas() {
        List<DTOComboObject> ret = ((DaoEmpresaImpl)this.getDao()).getDTOEmpresasAtivas();
        Collections.sort(ret, (aux1, aux2) -> aux1.getTitle().compareTo(aux2.getTitle()));
        return ret;
    }

    @Override
    public Empresa findEmpresaPorEmpresaDados(EmpresaDados empresaDados) {
        return ((DaoEmpresaImpl)this.getDao()).findEmpresaPorEmpresaDados(empresaDados.getIdentificador());
    }

    @Override
    public Empresa saveOrUpdateOnly(Empresa entity) {
        Empresa e = super.saveOrUpdateOnly(entity);
        if (e.getEmpresaDados().getCentroResultadoContFin() == null && this.getBean(ServiceCentroResultadoContFinImpl.class) != null) {
            List<CentroResultadoContFin> crs = this.getBean(ServiceCentroResultadoContFinImpl.class).getCentroResultadorPorEmpresa(e);
            CentroResultadoContFin cr = null;
            if (TMethods.isWithData(crs)) {
                cr = crs.get(0);
            }
            if (cr == null && this.getBean(ServiceCentroResultadoContFinImpl.class) != null) {
                cr = this.getBean(ServiceCentroResultadoContFinImpl.class).saveOrUpdate(this.getBean(HelperCentroResultado.class).getDefault(e));
            }
            e.getEmpresaDados().setCentroResultadoContFin(cr);
            e = super.saveOrUpdate(e);
        }
        if (this.getBean(ServiceEmpresaOpcoes.class) != null) {
            this.getBean(ServiceEmpresaOpcoes.class).createOpcoesDefault(e);
        }
        return e;
    }

    public Empresa getOrThrowNotExists(String id) throws ExceptionObjNotFound {
        Empresa emp = (Empresa)this.get(id);
        if (emp == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0049.001"));
        }
        return emp;
    }

    public Empresa getEager(Long idEmpresa) {
        Empresa emp = ((DaoEmpresaImpl)this.getDao()).getEager(idEmpresa);
        return emp;
    }

    public List<DTOPontoEmpresaIntegracao> findEmpresasPontoEletronico() {
        return ((DaoEmpresaImpl)this.getGenericDao()).findEmpresasPontoEletronico();
    }

    public <Z> List<Z> getEmpresasAtivas(Class<Z> aClass) {
        List<Empresa> emps = ((DaoEmpresaImpl)this.getDao()).getEmpresasAtivas();
        return this.buildToDTOGeneric(emps, aClass);
    }
}

