/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.empresarh;

import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.HoraExtraHorTrab;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.dao.impl.DaoEmpresaRhImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresaRh;
import com.touchcomp.basementorservice.service.interfaces.ServiceEsocial;
import com.touchcomp.touchvomodel.vo.empresarh.web.DTOEmpresaRh;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEmpresaRhImpl
extends ServiceGenericEntityImpl<EmpresaRh, Long, DaoEmpresaRhImpl>
implements ServiceEmpresaRh {
    @Autowired
    private ServiceEsocial serviceEsocial;

    @Autowired
    public ServiceEmpresaRhImpl(DaoEmpresaRhImpl genericDao) {
        super(genericDao);
    }

    @Override
    public EmpresaRh beforeSave(EmpresaRh vo) {
        if (vo.getHorasExtras() != null) {
            vo.getHorasExtras().forEach(i -> i.setEmpresaRh(vo));
        }
        return vo;
    }

    @Override
    public EmpresaRh saveOrUpdateEsocial(EmpresaRh entity, Usuario user, OpcoesESocial opcoes) throws ExceptionEsocial, ExceptionJaxb, ExceptionReflection {
        EmpresaRh saved = super.saveOrUpdate(entity);
        this.serviceEsocial.avaliarGerarEventoEsocial((InterfaceVOEsocial)saved, entity.getEmpresa(), user, opcoes);
        return saved;
    }

    @Override
    public EmpresaRh getEmpresaRh(Empresa empresa) {
        return ((DaoEmpresaRhImpl)this.getGenericDao()).getEmpresaRh(empresa);
    }

    public EmpresaRh getByIdEmpresa(Long idEmpresa) {
        return ((DaoEmpresaRhImpl)this.getDao()).getByIdEmpresa(idEmpresa);
    }

    public DTOEmpresaRh.DTOHoraExtraHorTrab novaHoraExtra() {
        return this.buildToDTOGeneric(new HoraExtraHorTrab(), DTOEmpresaRh.DTOHoraExtraHorTrab.class);
    }

    public DTOEmpresaRh getByIdEmpresaDTO(Long identificador, Class<DTOEmpresaRh> aClass) {
        EmpresaRh op = this.getByIdEmpresa(identificador);
        if (op == null) {
            return null;
        }
        return this.buildToDTO(op, aClass);
    }
}

