/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.encerramentocontabil;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.constants.enums.lancamentocontabil.ConstEnumOrigemLoteContabil;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.BloqueioAlteracaoEstoque;
import com.touchcomp.basementor.model.vo.BloqueioBaixaTitulos;
import com.touchcomp.basementor.model.vo.BloqueioCTePeriodo;
import com.touchcomp.basementor.model.vo.BloqueioComProducao;
import com.touchcomp.basementor.model.vo.BloqueioContabil;
import com.touchcomp.basementor.model.vo.BloqueioGeral;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoContabil;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoContabilEmpresa;
import com.touchcomp.basementor.model.vo.BloqueioLancamentoCtrcCte;
import com.touchcomp.basementor.model.vo.BloqueioMovFolhas;
import com.touchcomp.basementor.model.vo.BloqueioMovimentoBancario;
import com.touchcomp.basementor.model.vo.BloqueioNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.BloqueioNotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.BloqueioRequisicao;
import com.touchcomp.basementor.model.vo.BloqueioTransfContaValor;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.EncerramentoContabilItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SaldoContaAno;
import com.touchcomp.basementorservice.components.lancamentocontabil.CompLancamentoBase;
import com.touchcomp.basementorservice.dao.impl.DaoEncerramentoContabilImpl;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.encerramentocontabil.ServiceEncerramentoContabilPorCentroResultadoImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ServiceEncerramentoContabilImpl
extends ServiceGenericEntityImpl<EncerramentoContabil, Long, DaoEncerramentoContabilImpl> {
    final ServicePlanoContaImpl servicePlanoConta;
    final ServiceSaldoContaImpl serviceSaldoConta;
    final ServiceEmpresa serviceEmpresa;
    final HelperLoteContabil helperLoteContabil;

    @Autowired
    public ServiceEncerramentoContabilImpl(DaoEncerramentoContabilImpl genericDao, ServiceSaldoContaImpl serviceSaldoConta, ServicePlanoContaImpl servicePlanoConta, ServiceEmpresa serviceEmpresa, HelperLoteContabil helperLoteContabil) {
        super(genericDao);
        this.serviceSaldoConta = serviceSaldoConta;
        this.servicePlanoConta = servicePlanoConta;
        this.serviceEmpresa = serviceEmpresa;
        this.helperLoteContabil = helperLoteContabil;
    }

    public EncerramentoContabil getVerificarExisteEncerramentoContabilNasDatas(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoEncerramentoContabilImpl)this.getGenericDao()).getVerificarExisteEncerramentoContabilNasDatas(dataInicial, dataFinal, grupoEmpresa);
    }

    public List<EncerramentoContabil> getVerificarExisteEncerramentosContabilNasDatas(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoEncerramentoContabilImpl)this.getGenericDao()).getVerificarExisteEncerramentosContabilNasDatas(dataInicial, dataFinal, grupoEmpresa);
    }

    public EncerramentoContabil salvarSaldosAntesFechTotalPeriodo(EncerramentoContabil vo) {
        List<SaldoContaContabil> saldos = this.serviceSaldoConta.findSaldosConta(null, null, null, null, vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador(), EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsTipoSaldo.TIPO_SALDO_GERAL, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, EnumConstantsOrdenacao.ORDEM_NUMERICA);
        EncerramentoContabilItem i = new EncerramentoContabilItem();
        i.setEncerramentoContabil(vo);
        i.setEmpresa(vo.getEmpresa());
        i.setSaldoContasAno(this.saldosContaToSaldosContaAno(saldos, vo, i));
        i.setCentroResultadoContFin(null);
        ArrayList<EncerramentoContabilItem> itens = new ArrayList<EncerramentoContabilItem>();
        itens.add(i);
        vo.setItensEncerramentoContabil(itens);
        vo = ((DaoEncerramentoContabilImpl)this.getGenericDao()).saveOrUpdate(vo);
        return vo;
    }

    protected List<SaldoContaAno> saldosContaToSaldosContaAno(List<SaldoContaContabil> saldos, EncerramentoContabil vo, EncerramentoContabilItem item) {
        ArrayList<SaldoContaAno> result = new ArrayList<SaldoContaAno>();
        for (SaldoContaContabil saldoAntesFech : saldos) {
            PlanoConta pc = (PlanoConta)this.servicePlanoConta.get(saldoAntesFech.getIdPlanoConta());
            SaldoContaAno saldoAno = new SaldoContaAno();
            saldoAno.setAno(vo.getAno());
            saldoAno.setDataBase(vo.getDataFinal());
            saldoAno.setConta(pc);
            saldoAno.setValorCreditoAntesEnc(saldoAntesFech.getValorCredito());
            saldoAno.setValorDebitoAntesEnc(saldoAntesFech.getValorDebito());
            saldoAno.setSaldoAnteriorAntesEnc(saldoAntesFech.getSaldoAnterior());
            saldoAno.setSaldoAntesEnc(saldoAntesFech.getSaldoAtual());
            saldoAno.setEncerramentoContabilItem(item);
            saldoAno.setGrupoEmpresa(item.getEmpresa().getEmpresaDados().getGrupoEmpresa());
            result.add(saldoAno);
        }
        return result;
    }

    public EncerramentoContabil encerramentoContabil(EncerramentoContabil vo) {
        for (EncerramentoContabilItem i : vo.getItensEncerramentoContabil()) {
            List<SaldoContaContabil> saldos = this.getSaldosContaResultado(vo.getDataFinal(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa(), i.getCentroResultadoContFin());
            i.setLoteLancRes(this.getLoteLancResultado(saldos, vo, i));
        }
        vo = ((DaoEncerramentoContabilImpl)this.getGenericDao()).saveOrUpdate(vo);
        return vo;
    }

    private List<SaldoContaContabil> getSaldosContaResultado(Date dataFim, GrupoEmpresa grupo, CentroResultadoContFin centroResultadoContFin) {
        EnumConstantsTipoSaldo tipoSaldo = EnumConstantsTipoSaldo.TIPO_SALDO_GERAL;
        Long idCentroResultadoInicial = null;
        Long idCentroResultadoFinal = null;
        if (!this.isNull(centroResultadoContFin).booleanValue()) {
            tipoSaldo = EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO;
            idCentroResultadoInicial = idCentroResultadoFinal = centroResultadoContFin.getIdentificador();
        }
        ArrayList<SaldoContaContabil> response = new ArrayList<SaldoContaContabil>();
        List<PlanoConta> contas = this.servicePlanoConta.findContasAnaliticaResultado();
        for (PlanoConta p : contas) {
            SaldoContaContabil s = this.serviceSaldoConta.findSaldoContaUnica(idCentroResultadoInicial, idCentroResultadoFinal, p.getCodigo(), dataFim, dataFim, grupo.getIdentificador(), tipoSaldo);
            response.add(s);
        }
        return response;
    }

    protected LoteContabil getLoteLancResultado(List<SaldoContaContabil> saldos, EncerramentoContabil vo, EncerramentoContabilItem item) {
        LoteContabil lote = this.helperLoteContabil.criaRecriaLoteContabil(vo.getDataFinal(), item.getEmpresa(), ConstEnumOrigemLoteContabil.ENCERRAMENTO_CONTABIL);
        List<Lancamento> lancResultado = this.gerarLancamentoResultado(saldos, vo.getContaResultado(), lote, vo.getHistoricoPadrao(), vo.getHistorico(), item.getEmpresa());
        lote.setLancamentos(lancResultado);
        if (lote.getLancamentos().isEmpty()) {
            return null;
        }
        return lote;
    }

    protected List<Lancamento> gerarLancamentoResultado(List<SaldoContaContabil> saldos, PlanoConta contaResultado, LoteContabil lote, HistoricoPadrao historico, String complHistorico, Empresa empresa) {
        LinkedList<Lancamento> response = new LinkedList<Lancamento>();
        for (SaldoContaContabil s : saldos) {
            PlanoConta pc;
            if (s.getIdPlanoConta() == null || (pc = (PlanoConta)this.servicePlanoConta.get(s.getIdPlanoConta())).getMarca().intValue() != EnumConstSinteticoAnalitico.ANALITICO.getValueInt() || s.getSaldoAtual() == 0.0) continue;
            Lancamento lanc = CompLancamentoBase.newLancamento(lote, empresa);
            lanc.setHistoricoPadrao(historico);
            lanc.setHistorico(complHistorico);
            if (s.getSaldoAtual() > 0.0) {
                lanc.setPlanoContaDeb(contaResultado);
                lanc.setPlanoContaCred(pc);
                lanc.setValor(s.getSaldoAtual());
            } else {
                lanc.setPlanoContaDeb(pc);
                lanc.setPlanoContaCred(contaResultado);
                lanc.setValor(Double.valueOf(s.getSaldoAtual() * -1.0));
            }
            response.add(lanc);
        }
        return response;
    }

    public EncerramentoContabil salvarSaldosAtuais(EncerramentoContabil vo) {
        vo = (EncerramentoContabil)((DaoEncerramentoContabilImpl)this.getDao()).get(vo.getIdentificador());
        vo.setBloquearPeriodo(Short.valueOf((short)1));
        this.salvarEAtualizarSaldosAnuais(vo);
        vo.setBloqueioGeral(this.createBloqueio(vo));
        vo = ((DaoEncerramentoContabilImpl)this.getGenericDao()).saveOrUpdate(vo);
        return vo;
    }

    protected void salvarEAtualizarSaldosAnuais(EncerramentoContabil vo) {
        Long idCentroResultado = null;
        EnumConstantsTipoSaldo tipoSaldo = EnumConstantsTipoSaldo.TIPO_SALDO_GERAL;
        for (EncerramentoContabilItem e : vo.getItensEncerramentoContabil()) {
            if (!this.isNull(e.getCentroResultadoContFin()).booleanValue()) {
                idCentroResultado = e.getCentroResultadoContFin().getIdentificador();
                tipoSaldo = EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO;
            }
            List<SaldoContaContabil> saldosAtuais = this.serviceSaldoConta.findSaldosConta(idCentroResultado, idCentroResultado, null, null, vo.getDataInicial(), vo.getDataFinal(), vo.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador(), EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, tipoSaldo, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, EnumConstantsOrdenacao.ORDEM_NUMERICA);
            for (SaldoContaAno saldo : e.getSaldoContasAno()) {
                PlanoConta pc = saldo.getConta();
                SaldoContaContabil saldoAtual = null;
                int counter = 0;
                for (SaldoContaContabil aux : saldosAtuais) {
                    if (aux.getIdPlanoConta().longValue() == pc.getIdentificador().longValue()) {
                        saldoAtual = aux;
                        break;
                    }
                    ++counter;
                }
                saldosAtuais.remove(counter);
                if (saldoAtual != null) {
                    saldo.setSaldoAnterior(saldoAtual.getSaldoAnterior());
                    saldo.setValorCredito(saldoAtual.getValorCredito());
                    saldo.setValorDebito(saldoAtual.getValorDebito());
                }
                saldo.setEncerramentoContabilItem(e);
            }
        }
    }

    protected BloqueioGeral createBloqueio(EncerramentoContabil vo) {
        BloqueioGeral bloqueioGeral = new BloqueioGeral();
        bloqueioGeral.setDescricao("Bloqueio gerado pelo Encerramento do Exercicio Contabil de " + vo.getAno().toString() + " do Grupo de Empresa " + vo.getGrupoEmpresa().getDescricao());
        ArrayList<BloqueioAlteracaoEstoque> bloqueiosAlteracaoEstoque = new ArrayList<BloqueioAlteracaoEstoque>();
        ArrayList<BloqueioBaixaTitulos> bloqueiosBaixaTitulos = new ArrayList<BloqueioBaixaTitulos>();
        ArrayList<BloqueioCTePeriodo> bloqueiosCTePeriodos = new ArrayList<BloqueioCTePeriodo>();
        ArrayList<BloqueioComProducao> bloqueiosComProducao = new ArrayList<BloqueioComProducao>();
        ArrayList<BloqueioLancamentoCtrcCte> bloqueiosLancCtrc = new ArrayList<BloqueioLancamentoCtrcCte>();
        ArrayList<BloqueioMovimentoBancario> bloqueiosMovBancarios = new ArrayList<BloqueioMovimentoBancario>();
        ArrayList<BloqueioMovFolhas> bloqueiosMovFolhas = new ArrayList<BloqueioMovFolhas>();
        ArrayList<BloqueioNotaFiscalPropria> bloqueiosNotasProprias = new ArrayList<BloqueioNotaFiscalPropria>();
        ArrayList<BloqueioNotaFiscalTerceiros> bloqueiosNotasTerceiros = new ArrayList<BloqueioNotaFiscalTerceiros>();
        ArrayList<BloqueioRequisicao> bloqueiosRequisicao = new ArrayList<BloqueioRequisicao>();
        ArrayList<BloqueioTransfContaValor> bloqueiosTransfContaValor = new ArrayList<BloqueioTransfContaValor>();
        for (EmpresaDados empresaDados : vo.getGrupoEmpresa().getEmpresas()) {
            Empresa e = this.serviceEmpresa.findEmpresaPorEmpresaDados(empresaDados);
            if (this.isNull(e).booleanValue()) continue;
            BloqueioAlteracaoEstoque bloqueioAlteracaoEstoque = new BloqueioAlteracaoEstoque();
            bloqueioAlteracaoEstoque.setDataCadastro(new Date());
            bloqueioAlteracaoEstoque.setDataBloqueio(vo.getDataFinal());
            bloqueioAlteracaoEstoque.setDescricao("Bloqueio gerado pelo Encerramento Contabil do grupo de empresa: " + vo.getGrupoEmpresa().toString());
            bloqueioAlteracaoEstoque.setEmpresa(e);
            bloqueioAlteracaoEstoque.setBloqueioGeral(bloqueioGeral);
            bloqueiosAlteracaoEstoque.add(bloqueioAlteracaoEstoque);
            BloqueioBaixaTitulos bloqueioBaixaTitulos = new BloqueioBaixaTitulos();
            bloqueioBaixaTitulos.setEmpresa(e);
            bloqueioBaixaTitulos.setDataFinal(vo.getDataFinal());
            bloqueioBaixaTitulos.setBloqueioGeral(bloqueioGeral);
            bloqueiosBaixaTitulos.add(bloqueioBaixaTitulos);
            BloqueioCTePeriodo bloqueioCTePeriodo = new BloqueioCTePeriodo();
            bloqueioCTePeriodo.setEmpresa(e);
            bloqueioCTePeriodo.setDataFinal(vo.getDataFinal());
            bloqueioCTePeriodo.setBloqueioGeral(bloqueioGeral);
            bloqueiosCTePeriodos.add(bloqueioCTePeriodo);
            BloqueioComProducao bloqueioComProducao = new BloqueioComProducao();
            bloqueioComProducao.setEmpresa(e);
            bloqueioComProducao.setDataBloqueio(vo.getDataFinal());
            bloqueioComProducao.setBloqueioGeral(bloqueioGeral);
            bloqueiosComProducao.add(bloqueioComProducao);
            BloqueioLancamentoCtrcCte bloqueioLancamentoCtrcCte = new BloqueioLancamentoCtrcCte();
            bloqueioLancamentoCtrcCte.setEmpresa(e);
            bloqueioLancamentoCtrcCte.setDataFinal(vo.getDataFinal());
            bloqueioLancamentoCtrcCte.setBloqueioGeral(bloqueioGeral);
            bloqueiosLancCtrc.add(bloqueioLancamentoCtrcCte);
            BloqueioMovFolhas bloqueioMovFolhas = new BloqueioMovFolhas();
            bloqueioMovFolhas.setEmpresa(e);
            bloqueioMovFolhas.setDataFinal(vo.getDataFinal());
            bloqueioMovFolhas.setBloqueioGeral(bloqueioGeral);
            bloqueiosMovFolhas.add(bloqueioMovFolhas);
            BloqueioMovimentoBancario bloqueioMovimentoBancario = new BloqueioMovimentoBancario();
            bloqueioMovimentoBancario.setEmpresa(e);
            bloqueioMovimentoBancario.setDataFinal(vo.getDataFinal());
            bloqueioMovimentoBancario.setBloqueioGeral(bloqueioGeral);
            bloqueiosMovBancarios.add(bloqueioMovimentoBancario);
            BloqueioNotaFiscalPropria bloqueioNotaFiscalPropria = new BloqueioNotaFiscalPropria();
            bloqueioNotaFiscalPropria.setEmpresa(e);
            bloqueioNotaFiscalPropria.setDataFinal(vo.getDataFinal());
            bloqueioNotaFiscalPropria.setBloqueioGeral(bloqueioGeral);
            bloqueiosNotasProprias.add(bloqueioNotaFiscalPropria);
            BloqueioNotaFiscalTerceiros bloqueioNotaFiscalTerceiros = new BloqueioNotaFiscalTerceiros();
            bloqueioNotaFiscalTerceiros.setEmpresa(e);
            bloqueioNotaFiscalTerceiros.setDataFinal(vo.getDataFinal());
            bloqueioNotaFiscalTerceiros.setBloqueioGeral(bloqueioGeral);
            bloqueiosNotasTerceiros.add(bloqueioNotaFiscalTerceiros);
            BloqueioRequisicao bloqueioRequisicao = new BloqueioRequisicao();
            bloqueioRequisicao.setEmpresa(e);
            bloqueioRequisicao.setDataFinal(vo.getDataFinal());
            bloqueioRequisicao.setBloqueioGeral(bloqueioGeral);
            bloqueiosRequisicao.add(bloqueioRequisicao);
            BloqueioTransfContaValor bloqueioTransfContaValor = new BloqueioTransfContaValor();
            bloqueioTransfContaValor.setEmpresa(e);
            bloqueioTransfContaValor.setDataFinal(vo.getDataFinal());
            bloqueioTransfContaValor.setBloqueioGeral(bloqueioGeral);
            bloqueiosTransfContaValor.add(bloqueioTransfContaValor);
        }
        bloqueioGeral.setBloqueioAlteracaoEstoque(bloqueiosAlteracaoEstoque);
        bloqueioGeral.setBloqueioBaixaTitulo(bloqueiosBaixaTitulos);
        bloqueioGeral.setBloqueioComProducao(bloqueiosComProducao);
        bloqueioGeral.setBloqueioCTePeriodo(bloqueiosCTePeriodos);
        bloqueioGeral.setBloqueioLancamentoCtrcCte(bloqueiosLancCtrc);
        bloqueioGeral.setBloqueioMovFolhas(bloqueiosMovFolhas);
        bloqueioGeral.setBloqueioNFPropria(bloqueiosNotasProprias);
        bloqueioGeral.setBloqueioNFTerceiros(bloqueiosNotasTerceiros);
        bloqueioGeral.setBloqueioRequisicao(bloqueiosRequisicao);
        bloqueioGeral.setBloqueioTransfContaValor(bloqueiosTransfContaValor);
        bloqueioGeral.setBloqueiMovBancario(bloqueiosMovBancarios);
        BloqueioContabil bloqueioContabil = new BloqueioContabil();
        bloqueioContabil.setAno(vo.getAno());
        bloqueioContabil.setDataCadastro(new Date());
        bloqueioContabil.setDataBase(vo.getDataFinal());
        bloqueioContabil.setGrupoEmpresa(vo.getGrupoEmpresa());
        bloqueioContabil.setBloqueioGeral(bloqueioGeral);
        bloqueioGeral.setBloqueioContabil(bloqueioContabil);
        BloqueioLancamentoContabil bloqueioLancamentoContabil = new BloqueioLancamentoContabil();
        bloqueioLancamentoContabil.setDataFinal(vo.getDataFinal());
        bloqueioLancamentoContabil.setGrupoEmpresa(vo.getGrupoEmpresa());
        bloqueioLancamentoContabil.setBloqueioGeral(bloqueioGeral);
        bloqueioGeral.setBloqueioLancamentoContabil(bloqueioLancamentoContabil);
        for (EmpresaDados empresaDados : vo.getGrupoEmpresa().getEmpresas()) {
            Empresa e = this.serviceEmpresa.findEmpresaPorEmpresaDados(empresaDados);
            BloqueioLancamentoContabilEmpresa bloqueioLancamentoContabilEmpresa = new BloqueioLancamentoContabilEmpresa();
            bloqueioLancamentoContabilEmpresa.setBloqueio(bloqueioLancamentoContabil);
            bloqueioLancamentoContabilEmpresa.setCentroResultadoContFin(e.getEmpresaDados().getCentroResultadoContFin());
            bloqueioLancamentoContabil.getBloqueioLancamentoContabilEmpresa().add(bloqueioLancamentoContabilEmpresa);
        }
        bloqueioGeral.setEncerramentoContabil(vo);
        return bloqueioGeral;
    }

    public EncerramentoContabil gerarLancamentoLucroPrejuizo(EncerramentoContabil vo) {
        EnumConstantsTipoSaldo tipoSaldo = EnumConstantsTipoSaldo.TIPO_SALDO_GERAL;
        List listItens = vo.getItensEncerramentoContabil();
        for (EncerramentoContabilItem i : vo.getItensEncerramentoContabil()) {
            SaldoContaContabil saldo;
            Long idCentroResultado = null;
            if (!this.isNull(i.getCentroResultadoContFin()).booleanValue()) {
                idCentroResultado = i.getCentroResultadoContFin().getIdentificador();
                tipoSaldo = EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO;
            }
            if (this.isEquals((saldo = this.serviceSaldoConta.findSaldoContaUnica(idCentroResultado, idCentroResultado, vo.getContaResultado().getCodigo(), vo.getDataFinal(), vo.getDataFinal(), i.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador(), tipoSaldo)).getSaldoAtual(), 0)) continue;
            this.criarLancamento(vo, saldo, i);
        }
        vo.setItensEncerramentoContabil(listItens);
        vo = ((DaoEncerramentoContabilImpl)this.getDao()).saveOrUpdate(vo);
        return vo;
    }

    protected EncerramentoContabilItem criarLancamento(EncerramentoContabil vo, SaldoContaContabil saldo, EncerramentoContabilItem itemEncerrante) {
        Lancamento lanc = CompLancamentoBase.newLancamento(vo.getEmpresa());
        lanc.setHistoricoPadrao(vo.getHistoricoPadraoLanc());
        lanc.setHistorico(vo.getHistoricoLanc());
        if (saldo.getSaldoAtual() < 0.0) {
            lanc.setPlanoContaDeb(vo.getContaResultado());
            lanc.setPlanoContaCred(vo.getContaCredora());
        } else {
            lanc.setPlanoContaDeb(vo.getContaDevedora());
            lanc.setPlanoContaCred(vo.getContaResultado());
        }
        lanc.setValor(Double.valueOf(Math.abs(saldo.getSaldoAtual())));
        LoteContabil loteContabil = this.helperLoteContabil.criaRecriaLoteContabil(vo.getDataFinal(), itemEncerrante.getEmpresa(), ConstEnumOrigemLoteContabil.ENCERRAMENTO_CONTABIL);
        lanc.setLoteContabil(loteContabil);
        lanc.setDataLancamento(lanc.getLoteContabil().getDataLote());
        lanc.setCentroResultadoContFin(itemEncerrante.getEmpresa().getEmpresaDados().getCentroResultadoContFin());
        ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
        if (lanc.getValor() > 0.0) {
            lancamentos.add(lanc);
        }
        loteContabil.setLancamentos(lancamentos);
        itemEncerrante.setLoteLancLucroPrejuizo(loteContabil);
        return itemEncerrante;
    }

    public EncerramentoContabil getVerificarExisteEncerramentoContabilDeDataFinal(Date dataFinal, GrupoEmpresa grupoEmpresa) {
        return ((DaoEncerramentoContabilImpl)this.getGenericDao()).getVerificarExisteEncerramentoContabilDeDataFinal(dataFinal, grupoEmpresa);
    }

    @Override
    public boolean delete(EncerramentoContabil entity) {
        return ((DaoEncerramentoContabilImpl)this.getDao()).delete(entity);
    }

    public EncerramentoContabil getVerificarExisteEncerramentoContabilNaDataEmpresaBloquearPeriodo(Date dataFinal, Empresa empresa, Short bloquearPeriodo) {
        return ((DaoEncerramentoContabilImpl)this.getGenericDao()).getVerificarExisteEncerramentoContabilNaDataEmpresaBloquearPeriodo(dataFinal, empresa, bloquearPeriodo);
    }

    @Override
    public EncerramentoContabil saveOrUpdateOnly(EncerramentoContabil vo) {
        ServiceEncerramentoContabilPorCentroResultadoImpl serviceEncerramentoContabilPorCentroResultado = (ServiceEncerramentoContabilPorCentroResultadoImpl)Context.get(ServiceEncerramentoContabilPorCentroResultadoImpl.class);
        vo = this.isEquals(this.getSharedData().getOpcoesContabeis(vo.getEmpresa()).getGerarEncerramentoContabilPorCentroResultado(), (short)1) ? serviceEncerramentoContabilPorCentroResultado.salvarSaldosAntesFechTotalPeriodoCR(vo) : serviceEncerramentoContabilPorCentroResultado.salvarSaldosAntesFechTotalPeriodo(vo);
        vo = serviceEncerramentoContabilPorCentroResultado.encerramentoContabil(vo);
        vo = serviceEncerramentoContabilPorCentroResultado.gerarLancamentoLucroPrejuizo(vo);
        vo = serviceEncerramentoContabilPorCentroResultado.salvarSaldosAtuais(vo);
        return vo;
    }
}

