/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.encerramentocontabil;

import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsNivelContaRet;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsOrdenacao;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldo;
import com.touchcomp.basementor.constants.enums.saldocontabil.EnumConstantsTipoSaldoRetorno;
import com.touchcomp.basementor.model.impl.SaldoContaContabil;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.EncerramentoContabilItem;
import com.touchcomp.basementorservice.dao.impl.DaoEncerramentoContabilImpl;
import com.touchcomp.basementorservice.helpers.impl.lotecontabil.HelperLoteContabil;
import com.touchcomp.basementorservice.service.impl.centroresultadocontfin.ServiceCentroResultadoContFinImpl;
import com.touchcomp.basementorservice.service.impl.encerramentocontabil.ServiceEncerramentoContabilImpl;
import com.touchcomp.basementorservice.service.impl.planoconta.ServicePlanoContaImpl;
import com.touchcomp.basementorservice.service.impl.saldoconta.ServiceSaldoContaImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEmpresa;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEncerramentoContabilPorCentroResultadoImpl
extends ServiceEncerramentoContabilImpl {
    ServiceCentroResultadoContFinImpl serviceCentroResultadoContFin;

    @Autowired
    public ServiceEncerramentoContabilPorCentroResultadoImpl(DaoEncerramentoContabilImpl genericDao, ServiceSaldoContaImpl serviceSaldoConta, ServicePlanoContaImpl servicePlanoConta, ServiceEmpresa serviceEmpresa, ServiceCentroResultadoContFinImpl serviceCentroResultadoContFin, HelperLoteContabil helper) {
        super(genericDao, serviceSaldoConta, servicePlanoConta, serviceEmpresa, helper);
        this.serviceCentroResultadoContFin = serviceCentroResultadoContFin;
    }

    public EncerramentoContabil salvarSaldosAntesFechTotalPeriodoCR(EncerramentoContabil vo) {
        List<CentroResultadoContFin> centrosResultados = this.serviceCentroResultadoContFin.getCentroResultadorPorGrupoDeEmpresa(vo.getGrupoEmpresa());
        ArrayList<EncerramentoContabilItem> itens = new ArrayList<EncerramentoContabilItem>();
        for (CentroResultadoContFin c : centrosResultados) {
            List<SaldoContaContabil> saldos = this.serviceSaldoConta.findSaldosConta(c.getIdentificador(), c.getIdentificador(), null, null, vo.getDataInicial(), vo.getDataFinal(), c.getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador(), EnumConstantsTipoSaldoRetorno.TODOS_SALDOS, EnumConstantsTipoSaldo.TIPO_SALDO_CENTRO_RESULTADO, EnumConstantsNivelContaRet.TODOS_NIVEIS_CONTAS, EnumConstantsOrdenacao.ORDEM_NUMERICA);
            EncerramentoContabilItem i = new EncerramentoContabilItem();
            i.setEmpresa(c.getEmpresa());
            i.setCentroResultadoContFin(c);
            i.setEncerramentoContabil(vo);
            i.setSaldoContasAno(this.saldosContaToSaldosContaAno(saldos, vo, i));
            itens.add(i);
        }
        vo.setItensEncerramentoContabil(itens);
        vo = ((DaoEncerramentoContabilImpl)this.getGenericDao()).saveOrUpdate(vo);
        return vo;
    }
}

