/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.endereco;

import com.touchcomp.basementor.model.impl.ImplLogradouro;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementorenderecos.service.impl.logradouro.ServiceEnderecoLogradouroImpl;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorservice.dao.impl.DaoEnderecoImpl;
import com.touchcomp.basementorservice.helpers.impl.empresa.HelperEmpresa;
import com.touchcomp.basementorservice.helpers.impl.endereco.HelperEndereco;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoessistema.HelperOpcoesSistema;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.impl.endereco.UtilConsultaEnderecoWebService;
import com.touchcomp.basementorservice.service.impl.endereco.UtilPesquisaEnderecoBD;
import com.touchcomp.basementorservice.service.interfaces.ServiceUnidadeFederativa;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.List;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ServiceEnderecoImpl
extends ServiceGenericEntityImpl<Endereco, Long, DaoEnderecoImpl> {
    final ServiceEnderecoLogradouroImpl serviceEnderecoLogradouroEnd;
    final ServiceCidadeImpl serviceCidadeImpl;
    final HelperEndereco helperEndereco;
    final ServiceUnidadeFederativa serviceUnidadeFederativa;
    final HelperOpcoesSistema helperOpcoesSistema;
    final HelperEmpresa helperEmpresa;

    public ServiceEnderecoImpl(ServiceEnderecoLogradouroImpl serviceEnderecoLogradouroEnd, ServiceCidadeImpl serviceCidadeImpl, HelperEndereco helperEndereco, ServiceUnidadeFederativa serviceUnidadeFederativa, HelperOpcoesSistema helperOpcoesSistema, HelperEmpresa helperEmpresa, DaoEnderecoImpl genericDao) {
        super(genericDao);
        this.serviceEnderecoLogradouroEnd = serviceEnderecoLogradouroEnd;
        this.serviceCidadeImpl = serviceCidadeImpl;
        this.helperEndereco = helperEndereco;
        this.serviceUnidadeFederativa = serviceUnidadeFederativa;
        this.helperOpcoesSistema = helperOpcoesSistema;
        this.helperEmpresa = helperEmpresa;
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoViaCep"}, keyGenerator="customKeyGenerator")
    public Cidade getCidadeByCep(String cep) throws ExceptionBase {
        return new UtilConsultaEnderecoWebService(this.serviceCidadeImpl, this.serviceUnidadeFederativa, this.helperOpcoesSistema, this.helperEmpresa).getCidadeByCep(cep, this.getSharedData().getOpcoesSistema());
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoViaCep"}, keyGenerator="customKeyGenerator")
    public ImplLogradouro getLogroudroByCep(String cep, Empresa empresa) throws ExceptionBase {
        return new UtilConsultaEnderecoWebService(this.serviceCidadeImpl, this.serviceUnidadeFederativa, this.helperOpcoesSistema, this.helperEmpresa).getLogradouroByCep(cep, empresa, this.getSharedData().getOpcoesSistema());
    }

    @Cacheable(cacheNames={"buscaDadosEnderecoViaCep"}, keyGenerator="customKeyGenerator")
    public ImplLogradouro getLogroudroByCepBDEnderecos(String cep) {
        return new UtilPesquisaEnderecoBD(this.serviceEnderecoLogradouroEnd, this.serviceCidadeImpl).pesquisaEnderecoCep(cep);
    }

    public Cidade pesquisaOuConsultaCidade(String cep, String codIbge, Empresa empresa) throws ExceptionBase {
        ImplLogradouro imp;
        if (!TMethods.isStrWithData((String)cep) && !TMethods.isStrWithData((String)codIbge)) {
            return null;
        }
        if (TMethods.isStrWithData((String)cep) && (imp = this.getLogroudroByCepBDEnderecos(cep)) != null) {
            return imp.getCidade();
        }
        Cidade cid = this.serviceCidadeImpl.getCidade(this.helperEndereco.getCepPrincipal(cep), codIbge);
        if (cid != null) {
            return cid;
        }
        if (!TMethods.isStrWithData((String)cep)) {
            return null;
        }
        ImplLogradouro imp2 = this.getLogroudroByCep(cep, empresa);
        if (imp2 != null) {
            return imp2.getCidade();
        }
        return null;
    }

    public List<Endereco> getByCep(String cep) {
        return ((DaoEnderecoImpl)this.getDao()).findByCep(cep);
    }
}

