/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.endereco;

import com.touchcomp.basementor.constants.enums.opcoessistema.EnumConstOpSistemaOp;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.impl.ImplLogradouro;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementorclientwebservices.viacep.WEBConsultaEnderecoImpl;
import com.touchcomp.basementorclientwebservices.viacep.constants.EnumConstProvedorConsEndereco;
import com.touchcomp.basementorclientwebservices.viacep.model.DTOConsultaEndereco;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.empresa.HelperEmpresa;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoessistema.HelperOpcoesSistema;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceUnidadeFederativa;
import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

class UtilConsultaEnderecoWebService {
    private final ServiceCidadeImpl serviceCidade;
    private final ServiceUnidadeFederativa serviceUnidadeFederativa;
    private final HelperOpcoesSistema helperOpcoesSistema;
    private final HelperEmpresa helperEmpresa;

    public UtilConsultaEnderecoWebService(ServiceCidadeImpl serviceCidade, ServiceUnidadeFederativa serviceUnidadeFederativa, HelperOpcoesSistema helperOpcoesSistema, HelperEmpresa helperEmpresa) {
        this.serviceCidade = serviceCidade;
        this.serviceUnidadeFederativa = serviceUnidadeFederativa;
        this.helperOpcoesSistema = helperOpcoesSistema;
        this.helperEmpresa = helperEmpresa;
    }

    public Cidade getCidadeByCep(String cep, OpcoesSistema opcoes) throws ExceptionBase {
        ImplLogradouro logradouro = this.getLogradouroByCep(cep, null, opcoes);
        if (TMethods.isNotNull((Object)logradouro).booleanValue()) {
            return logradouro.getCidade();
        }
        return null;
    }

    private DTOConsultaEndereco callWebService(String cep, Empresa empresa, OpcoesSistema opcoesSistema) throws ExceptionBase {
        Short provedor = (Short)CompOpcoes.getOption(this.helperOpcoesSistema.build(opcoesSistema).getItens(), (EnumOpDinamicasInterface)EnumConstOpSistemaOp.PROVEDOR_CONSULTA_ENDERECOS, Short.class);
        ToolDownloadWeb.InternalProxy pr = this.helperEmpresa.build(empresa).getProxy();
        DTOConsultaEndereco endereco = new WEBConsultaEnderecoImpl().getEndereco(EnumConstProvedorConsEndereco.get((Object)provedor), cep, pr);
        return endereco;
    }

    public ImplLogradouro getLogradouroByCep(String cep, Empresa empresa, OpcoesSistema opcoes) throws ExceptionBase {
        DTOConsultaEndereco end = this.callWebService(cep, empresa, opcoes);
        if (end == null || end.getUf() == null) {
            return null;
        }
        String logradouro = end.getLogradouro();
        String complemento = end.getComplemento();
        String bairro = end.getBairro();
        String localidade = end.getLocalidade();
        String uf = end.getUf();
        String ibge = end.getIbge();
        Cidade cidade = this.getCidade(uf, ibge, localidade);
        ImplLogradouro log = new ImplLogradouro();
        if (bairro != null) {
            log.setBairro(bairro.toUpperCase());
        }
        log.setCep(cep);
        log.setCidade(cidade);
        if (logradouro != null) {
            log.setLogradouro(logradouro.toUpperCase());
        }
        if (complemento != null) {
            log.setComplemento(complemento.toUpperCase());
        }
        log.setLogradouro(ToolString.clearSpecialCharacXML((String)log.getLogradouro()));
        log.setBairro(ToolString.clearSpecialCharacXML((String)log.getBairro()));
        return log;
    }

    private Cidade getCidade(String uf, String ibge, String localidade) {
        Cidade cidade = this.serviceCidade.getByCodigoIBGECompleto(ibge);
        if (cidade == null) {
            cidade = new Cidade();
            cidade.setCodIbge(ibge);
            cidade.setCodIbgeCompleto(ibge);
            cidade.setDataCadastro(new Date());
            cidade.setDescricao(ToolString.clearSpecialCharacXML((String)localidade));
            cidade.setUf(this.serviceUnidadeFederativa.getBySigla(uf));
            cidade = this.serviceCidade.saveOrUpdate(cidade);
        }
        return cidade;
    }
}

