/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.endereco;

import com.touchcomp.basementor.model.impl.ImplLogradouro;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementorenderecos.model.LogradouroEnd;
import com.touchcomp.basementorenderecos.service.impl.logradouro.ServiceEnderecoLogradouroImpl;
import com.touchcomp.basementorservice.service.impl.cidade.ServiceCidadeImpl;
import com.touchcomp.basementortools.tools.string.ToolString;

class UtilPesquisaEnderecoBD {
    final ServiceEnderecoLogradouroImpl serviceEnderecoLogradouroEnd;
    final ServiceCidadeImpl serviceCidadeImpl;

    public UtilPesquisaEnderecoBD(ServiceEnderecoLogradouroImpl serviceEnderecoLogradouroEnd, ServiceCidadeImpl serviceCidadeImpl) {
        this.serviceEnderecoLogradouroEnd = serviceEnderecoLogradouroEnd;
        this.serviceCidadeImpl = serviceCidadeImpl;
    }

    public ImplLogradouro pesquisaEnderecoCep(String cep) {
        LogradouroEnd l = this.serviceEnderecoLogradouroEnd.getByCep(cep = ToolString.refina((String)cep));
        if (l != null) {
            Cidade c = this.serviceCidadeImpl.getByCodigoIBGECompleto(l.getBairro().getCidade().getUnidadeFederativa().getCodigoIBGE() + l.getBairro().getCidade().getCodIBGE());
            ImplLogradouro log = new ImplLogradouro();
            if (l.getBairro() != null && l.getBairro().getDescricao() != null) {
                log.setBairro(l.getBairro().getDescricao().toUpperCase());
            }
            log.setCep(l.getCep());
            log.setCidade(c);
            if (l.getDescricao() != null) {
                log.setLogradouro(l.getDescricao().toUpperCase());
            }
            return log;
        }
        Cidade c = this.serviceCidadeImpl.getByCep(cep);
        if (c != null) {
            ImplLogradouro log = new ImplLogradouro();
            log.setCep(cep);
            log.setCidade(c);
            return log;
        }
        return null;
    }
}

