/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.enviomensagens;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.modeloenviomensagens.ConstEnumTpEnvioMsg;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.EnvioMensagens;
import com.touchcomp.basementor.model.vo.EnvioMensagensMsg;
import com.touchcomp.basementor.model.vo.ModeloEnvioMensagens;
import com.touchcomp.basementor.model.vo.ModeloEnvioMsgBI;
import com.touchcomp.basementor.model.vo.ModeloEnvioMsgPessoa;
import com.touchcomp.basementor.model.vo.ObjectObsDinamica;
import com.touchcomp.basementor.model.vo.TelefonePessoa;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.CompBusinessIntelligence;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.components.obsdinamica.CompOBSDinamica;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataResultBI;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.ServiceFileDownloadImpl;
import com.touchcomp.basementorservice.service.impl.modeloenviomensagens.ServiceModeloEnvioMensagensImpl;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.stringformat.ToolStringFormater;
import com.touchcomp.touchvomodel.vo.enviomensagens.DTOEnvioMensagens;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBuildMensagensImpl
extends ServiceGenericImpl {
    @Autowired
    CompBusinessIntelligence compBusinessIntelligence;
    @Autowired
    ServiceFileDownloadImpl serviceDownload;
    @Autowired
    ServiceModeloEnvioMensagensImpl ServiceModeloEnvioMensagensImpl;
    @Autowired
    ServiceBuildBusinessIntelligenceImpl serviceBuild;
    @Autowired
    private CompOBSDinamica compOBSDinamica;

    public List<DTOEnvioMensagens.DTOMensagem> buildMessages(Long idModelo) throws ExceptionBuildBI, ExceptionIO, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidState, ExceptionObjNotFound {
        return this.buildMessages((ModeloEnvioMensagens)this.ServiceModeloEnvioMensagensImpl.getOrThrow(idModelo));
    }

    public List<DTOEnvioMensagens.DTOMensagem> buildMessages(ModeloEnvioMensagens modelo) throws ExceptionBuildBI, ExceptionIO, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidState {
        LinkedList<DestinatarioInternal> destinatarios = new LinkedList<DestinatarioInternal>();
        this.addDestinatariosFixos(modelo, destinatarios);
        this.addDestinatariosDinamicos(modelo, destinatarios);
        boolean enviarUmPraTodos = modelo.getBusinessIntelligence() == null;
        return this.montarMensagens(modelo, destinatarios, enviarUmPraTodos);
    }

    public EnvioMensagens buildEnvioMensagens(ModeloEnvioMensagens modelo) throws ExceptionBuildBI, ExceptionIO, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidState {
        List<DTOEnvioMensagens.DTOMensagem> mensagens = this.buildMessages(modelo);
        EnvioMensagens env = new EnvioMensagens();
        env.setDataAgendamentoEnvio(new Date());
        env.setDataCadastro(new Date());
        env.setDescricao(modelo.getDescricao());
        env.setEmpresa(modelo.getEmpresa());
        env.setModeloEnvioMensagens(modelo);
        for (DTOEnvioMensagens.DTOMensagem mensagen : mensagens) {
            EnvioMensagensMsg msg = new EnvioMensagensMsg();
            msg.setChavesArquivosAnexados(ToolString.cut((String)mensagen.getChavesArquivosAnexados(), (int)5000));
            msg.setDescStatusEnvio(ToolString.cut((String)mensagen.getDescStatusEnvio(), (int)500));
            msg.setEnviadoComSucesso(mensagen.getEnviadoComSucesso());
            msg.setEnvioMensagens(env);
            msg.setDescricao(ToolString.cut((String)mensagen.getTituloEmail(), (int)500));
            msg.setIndice(mensagen.getIndice());
            msg.setNumeroDestinatario(ToolString.cut((String)mensagen.getNumeroDestinatario(), (int)100));
            msg.setStatusCode(ToolString.cut((String)mensagen.getStatusCode(), (int)300));
            msg.setStatusDetailCode(ToolString.cut((String)mensagen.getStatusDetailCode(), (int)500));
            msg.setTexto(mensagen.getTexto());
            env.getMensagens().add(msg);
        }
        return env;
    }

    private void addDestinatariosDinamicos(ModeloEnvioMensagens modelo, List<DestinatarioInternal> destinatarios) throws ExceptionBuildBI, ExceptionIO {
        if (modelo.getBusinessIntelligence() == null || modelo.getBusinessIntelligencePref() == null) {
            return;
        }
        DataResultBI out = this.compBusinessIntelligence.buildBIData(modelo.getBusinessIntelligence(), modelo.getBusinessIntelligencePref(), CompBIDefaultParams.getDefParamsMap(modelo.getEmpresa(), null, null, new Object[0]));
        for (Map map : out.getData()) {
            Object outrasIdentificacoes = map.get(modelo.getNomeColunaIdentDestinatario());
            Object descricaoDestinatario = map.get(modelo.getNomeColunaDesc());
            if (outrasIdentificacoes == null || outrasIdentificacoes.toString().trim().length() <= 0) continue;
            destinatarios.add(new DestinatarioInternal(this, String.valueOf(descricaoDestinatario), outrasIdentificacoes.toString(), map));
        }
    }

    private void addDestinatariosFixos(ModeloEnvioMensagens modelo, List<DestinatarioInternal> destinatarios) {
        if (TMethods.isEquals((Object)modelo.getTipoEnvio(), (Object)ConstEnumTpEnvioMsg.EMAIL.getValue())) {
            for (ModeloEnvioMsgPessoa modeloEnvioMsgPessoa : modelo.getPessoasEnvio()) {
                StringBuilder sb = new StringBuilder();
                for (EmailPessoa em : modeloEnvioMsgPessoa.getPessoa().getComplemento().getEmails()) {
                    if (!TMethods.isAffirmative((Number)em.getAtivo()) || !TMethods.isAffirmative((Number)em.getEnviarDadosRelacionamento())) continue;
                    sb.append(em.getEmail());
                    sb.append("; ");
                }
                destinatarios.add(new DestinatarioInternal(this, modeloEnvioMsgPessoa.getPessoa().getNome(), sb.toString()));
            }
        } else {
            for (ModeloEnvioMsgPessoa modeloEnvioMsgPessoa : modelo.getPessoasEnvio()) {
                for (TelefonePessoa em : modeloEnvioMsgPessoa.getPessoa().getComplemento().getOutrosTelefones()) {
                    if (!TMethods.isAffirmative((Number)em.getEnviarSMS())) continue;
                    destinatarios.add(new DestinatarioInternal(this, modeloEnvioMsgPessoa.getPessoa().getNome(), em.getTelefone()));
                }
            }
        }
    }

    private List<DTOEnvioMensagens.DTOMensagem> montarMensagens(ModeloEnvioMensagens modelo, List<DestinatarioInternal> destinatarios, boolean enviarUmPraTodos) throws ExceptionIO, ExceptionBuildBI, ExceptionReflection, ExceptionInvalidData, ExceptionInvalidState {
        DefaultBIParamsMap<String, Object> paramsFormatted = CompBIDefaultParams.getDefParamsMap(modelo.getEmpresa(), null, null, new Object[0]);
        LinkedList<String> anexos = new LinkedList<String>();
        LinkedList<DTOEnvioMensagens.DTOMensagem> mensagens = new LinkedList<DTOEnvioMensagens.DTOMensagem>();
        if (enviarUmPraTodos) {
            List<DTOUploadDownloadFileConfig.DTOItem> temp = this.prepareGenerateBIs(modelo, paramsFormatted);
            for (DTOUploadDownloadFileConfig.DTOItem dto : temp) {
                anexos.add(dto.getChave());
            }
        }
        int indice = 0;
        for (DestinatarioInternal destinatario : destinatarios) {
            String tituloEmail;
            String mensagemEmail;
            paramsFormatted.putAll(destinatario.params);
            if (!enviarUmPraTodos) {
                anexos.clear();
                List<DTOUploadDownloadFileConfig.DTOItem> temp = this.prepareGenerateBIs(modelo, paramsFormatted);
                for (DTOUploadDownloadFileConfig.DTOItem dto : temp) {
                    anexos.add(dto.getChave());
                }
            }
            this.converteTodosParamestrosString(paramsFormatted);
            ObjectObsDinamica obsDinamica = modelo.getModeloEmailMensagem().getObjectObsDinamica();
            if (obsDinamica != null) {
                mensagemEmail = this.compOBSDinamica.build(paramsFormatted, obsDinamica.getObservacao());
                tituloEmail = this.compOBSDinamica.build(paramsFormatted, modelo.getModeloEmailMensagem().getTituloEmail());
            } else {
                mensagemEmail = ToolStringFormater.formatObj((String)modelo.getModeloEmailMensagem().getModelo(), paramsFormatted);
                tituloEmail = ToolStringFormater.formatObj((String)modelo.getModeloEmailMensagem().getTituloEmail(), paramsFormatted);
            }
            String[] destinatariosIdentificacao = new String[]{destinatario.getIdentificadorDestinatario()};
            if (!TMethods.isEquals((Object)modelo.getTipoEnvio(), (Object)ConstEnumTpEnvioMsg.EMAIL.getValue())) {
                destinatariosIdentificacao = TString.splitString((String)destinatario.getIdentificadorDestinatario(), (char[])new char[]{'.', '-'});
            }
            if (!TMethods.isEquals((Object)modelo.getTipoEnvio(), (Object)ConstEnumTpEnvioMsg.EMAIL.getValue()) && TMethods.isWithData((Number)modelo.getTamanhoMaximoMsg())) {
                mensagemEmail = ToolString.cut((String)mensagemEmail, (int)modelo.getTamanhoMaximoMsg().shortValue());
            }
            for (String dest : destinatariosIdentificacao) {
                DTOEnvioMensagens.DTOMensagem msg = new DTOEnvioMensagens.DTOMensagem();
                msg.setDescricao(destinatario.getDescricaoDestinatario());
                msg.setIndice(Integer.valueOf(indice));
                msg.setNumeroDestinatario(dest);
                msg.setTexto(mensagemEmail);
                msg.setTituloEmail(tituloEmail);
                msg.setChavesArquivosAnexados(TString.asString(anexos, (String)";"));
                mensagens.add(msg);
                ++indice;
            }
        }
        return mensagens;
    }

    private DefaultBIParamsMap<String, Object> converteTodosParamestrosString(Map<String, Object> params) {
        DefaultBIParamsMap<String, Object> temp = new DefaultBIParamsMap<String, Object>();
        Set<String> keys = params.keySet();
        keys.forEach(item -> {
            Object found = params.get(item);
            if (found != null && ToolReflections.isPrimitive(found)) {
                OpFinder op = CompRestrictionsFactory.getRestrictions(found.getClass(), (String)"dd_MM_yyyy");
                temp.put(item, op.convertValueToString(found));
            } else {
                temp.put(item, null);
            }
        });
        return temp;
    }

    private List<DTOUploadDownloadFileConfig.DTOItem> prepareGenerateBIs(ModeloEnvioMensagens modelo, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI, ExceptionInvalidState {
        LinkedList<DTOUploadDownloadFileConfig.DTOItem> files = new LinkedList<DTOUploadDownloadFileConfig.DTOItem>();
        for (ModeloEnvioMsgBI i : modelo.getBusinessIntelligenceAnexos()) {
            BusinessIntelligence bi = i.getBusinessIntelligence();
            Object nomeArquivo = i.getNomeArquivo();
            if (!TMethods.isStrWithData((String)nomeArquivo)) {
                nomeArquivo = "dados_bi_" + bi.getIdentificador();
            }
            if (ToolMethods.isAffirmative((Number)i.getAnexarArquivo())) {
                File file = this.compBusinessIntelligence.prepareGenerateBIFile(bi, i.getBusinessIntelligencePref(), (String)nomeArquivo, ConstEnumFormImprBI.valueOfByValue((Number)i.getFormatoGerArquivo().getFormatoGeracaoBI().getTipo()), params);
                String extFileName = ToolFile.getExtFileWithDot((String)nomeArquivo);
                if (!TMethods.isStrWithData((String)extFileName) && !((String)nomeArquivo).endsWith(extFileName)) {
                    nomeArquivo = (String)nomeArquivo + ToolFile.getExtFileWithDot((File)file);
                }
                if (!TMethods.isStrWithData((String)extFileName)) {
                    nomeArquivo = (String)nomeArquivo + ToolFile.getExtFileWithDot((File)file);
                }
                DTOUploadDownloadFileConfig.DTOItem item = this.serviceDownload.registerCopyFile(file, (String)nomeArquivo, true);
                files.add(item);
                continue;
            }
            DataResultBI dataResult = this.serviceBuild.gerarBI(bi, EnumConstTipoSistema.WEB, params);
            params.put(nomeArquivo, dataResult.getData());
        }
        return files;
    }

    class DestinatarioInternal {
        private String descricaoDestinatario;
        private String identificadorDestinatario;
        private Map<String, Object> params;

        public DestinatarioInternal(ServiceBuildMensagensImpl this$0, String descricaoDestinatario, String identificadorDestinatario) {
            this.identificadorDestinatario = identificadorDestinatario;
            this.params = new HashMap<String, Object>();
        }

        public DestinatarioInternal(ServiceBuildMensagensImpl this$0, String descricaoDestinatario, String identificadorDestinatario, Map<String, Object> params) {
            this.identificadorDestinatario = identificadorDestinatario;
            this.params = params;
        }

        @Generated
        public String getDescricaoDestinatario() {
            return this.descricaoDestinatario;
        }

        @Generated
        public String getIdentificadorDestinatario() {
            return this.identificadorDestinatario;
        }

        @Generated
        public Map<String, Object> getParams() {
            return this.params;
        }

        @Generated
        public void setDescricaoDestinatario(String descricaoDestinatario) {
            this.descricaoDestinatario = descricaoDestinatario;
        }

        @Generated
        public void setIdentificadorDestinatario(String identificadorDestinatario) {
            this.identificadorDestinatario = identificadorDestinatario;
        }

        @Generated
        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DestinatarioInternal)) {
                return false;
            }
            DestinatarioInternal other = (DestinatarioInternal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$descricaoDestinatario = this.getDescricaoDestinatario();
            String other$descricaoDestinatario = other.getDescricaoDestinatario();
            if (this$descricaoDestinatario == null ? other$descricaoDestinatario != null : !this$descricaoDestinatario.equals(other$descricaoDestinatario)) {
                return false;
            }
            String this$identificadorDestinatario = this.getIdentificadorDestinatario();
            String other$identificadorDestinatario = other.getIdentificadorDestinatario();
            if (this$identificadorDestinatario == null ? other$identificadorDestinatario != null : !this$identificadorDestinatario.equals(other$identificadorDestinatario)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DestinatarioInternal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $descricaoDestinatario = this.getDescricaoDestinatario();
            result = result * 59 + ($descricaoDestinatario == null ? 43 : $descricaoDestinatario.hashCode());
            String $identificadorDestinatario = this.getIdentificadorDestinatario();
            result = result * 59 + ($identificadorDestinatario == null ? 43 : $identificadorDestinatario.hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServiceBuildMensagensImpl.DestinatarioInternal(descricaoDestinatario=" + this.getDescricaoDestinatario() + ", identificadorDestinatario=" + this.getIdentificadorDestinatario() + ", params=" + String.valueOf(this.getParams()) + ")";
        }
    }
}

