/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.enviomensagens;

import com.touchcomp.basementor.constants.enums.configservicosterceiros.impl.ConstantsEnvioMensagens;
import com.touchcomp.basementor.constants.enums.modeloenviomensagens.ConstEnumTpEnvioMsg;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.EnvioMensagens;
import com.touchcomp.basementor.model.vo.EnvioMensagensMsg;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementorclientwebservices.enviomensagens.WEBEnvioMensagens;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessage;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessageProvider;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessageType;
import com.touchcomp.basementorclientwebservices.enviomensagens.model.WebEnvMensagem;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.helpers.impl.configservicosterceiros.HelperConfigServicosTerceiros;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.enviomensagens.ServiceEnvioMensagensImpl;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.ServiceFileDownloadImpl;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEnviarMensagensImpl
extends ServiceGenericImpl {
    @Autowired
    HelperConfigServicosTerceiros helperConfigServicosTerceiros;
    @Autowired
    ServiceEnvioMensagensImpl serviceEnvioMensagens;
    @Autowired
    ServiceFileDownloadImpl serviceFileDownloadImpl;
    @Autowired
    WEBEnvioMensagens sender;

    public void enviarMensagens(Long idEnvio) throws ExceptionIO, ExceptionObjNotFound, ExceptionInvalidData, ExceptionInvalidState {
        EnvioMensagens env = (EnvioMensagens)this.serviceEnvioMensagens.getOrThrow(idEnvio);
        this.enviarMensagens(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enviarMensagens(EnvioMensagens env) throws ExceptionIO, ExceptionInvalidData, ExceptionInvalidState {
        EnvioMensagens envioMensagens = env;
        synchronized (envioMensagens) {
            env = this.serviceEnvioMensagens.refresh(env);
            if (this.isEquals(env.getModeloEnvioMensagens().getTipoEnvio(), ConstEnumTpEnvioMsg.EMAIL.getValue())) {
                this.enviarEmails(env);
            } else {
                this.enviarSMSWhats(env);
            }
        }
    }

    private void enviarSMSWhats(EnvioMensagens env) throws ExceptionIO, ExceptionInvalidData, ExceptionInvalidState {
        ConfigServicosTerceiros config = env.getModeloEnvioMensagens().getConfigServicosTerceiros();
        this.helperConfigServicosTerceiros.build(config);
        String provider = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.PROVEDOR.getChave(), "E.ERP.1838.001");
        String token = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.API_TOKEN.getChave(), "E.ERP.1838.001");
        String identificadorEnvio = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.IDENTIFICADOR_REMETENTE.getChave());
        String tipoMensagem = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.TIPO_MENSAGEM.getChave(), "E.ERP.1838.001");
        String user = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.USER.getChave());
        String senha = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.PASS.getChave());
        String templateId = this.helperConfigServicosTerceiros.getValue(ConstantsEnvioMensagens.TEMPLATE_ID.getChave());
        WEBEnvioMensagens.Config conf = new WEBEnvioMensagens.Config();
        conf.setProvider(ConstEnumMessageProvider.get((Object)provider));
        conf.setUser(user);
        conf.setPass(senha);
        conf.setToken(token);
        if (TMethods.isStrWithData((String)templateId)) {
            conf.setTokenIdTemplate(templateId);
        }
        LinkedList<WebEnvMensagem> messages = new LinkedList<WebEnvMensagem>();
        for (EnvioMensagensMsg msg : env.getMensagens()) {
            String[] anexos;
            if (this.isEquals(msg.getEnviadoComSucesso(), (short)1)) continue;
            WebEnvMensagem w = new WebEnvMensagem();
            w.setIdMessage(msg.getIdentificador().toString());
            w.setSenderIdentifier(identificadorEnvio);
            w.setMessage(msg.getTexto());
            w.setTipoMensagem(ConstEnumMessageType.TEXT);
            w.setTipoEnvio(ConstEnumMessage.get((Object)tipoMensagem));
            w.addRecipients(new String[]{msg.getNumeroDestinatario()});
            for (String chaveAnexo : anexos = TString.splitString((String)msg.getChavesArquivosAnexados(), (char[])new char[]{'.'})) {
                ServiceFileDownloadImpl.FileDetails f = this.serviceFileDownloadImpl.getFile(chaveAnexo);
                w.addFile(this.getDTOFileDetails(f));
            }
            messages.add(w);
        }
        this.sender.enviarMensagens(conf, messages);
        for (WebEnvMensagem r : messages) {
            Optional<EnvioMensagensMsg> f = env.getMensagens().stream().filter(j -> this.isEquals(String.valueOf(j.getIdentificador()), r.getIdMessage())).findFirst();
            if (!f.isPresent()) continue;
            if (r.getStatus() != null && r.getStatus().isOk()) {
                f.get().setEnviadoComSucesso(Short.valueOf((short)1));
                f.get().setDescStatusEnvio(ToolString.cut((String)EnumConstStatusObjeto.ATIVO.getDescricao(), (int)500));
                continue;
            }
            f.get().setEnviadoComSucesso(Short.valueOf((short)0));
            f.get().setDescStatusEnvio(ToolString.cut((String)r.getErrorMessage(), (int)500));
        }
        this.afterSend(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarEmails(EnvioMensagens env) throws ExceptionIO, ExceptionInvalidState {
        ServidorEmail servidorEmail = env.getModeloEnvioMensagens().getServidorEmail();
        Email.ServidorEmail serv = new Email.ServidorEmail(servidorEmail.getServidor(), servidorEmail.getServidorImap(), servidorEmail.getServidorPop(), servidorEmail.getEmail(), servidorEmail.getSenha(), servidorEmail.getPortaEmail(), servidorEmail.getNaoAutenticarEmail(), servidorEmail.getLogin(), servidorEmail.getServerProperties(), servidorEmail.getGerarArquivoExtensaoEml(), servidorEmail.getDebugServer());
        for (EnvioMensagensMsg mensagem : env.getMensagens()) {
            Email email = new Email(false);
            if (TMethods.isStrWithData((String)mensagem.getDescricao())) {
                email.setAssunto(mensagem.getDescricao());
            } else {
                email.setAssunto(env.getModeloEnvioMensagens().getDescricao());
            }
            email.setCorpoMensagem(mensagem.getTexto());
            email.addDestinatarios(new String[]{mensagem.getNumeroDestinatario()});
            email.setServidor(serv);
            String[] anexos = TString.splitString((String)mensagem.getChavesArquivosAnexados(), (char[])new char[]{'.'});
            int i = 1;
            LinkedList<ServiceFileDownloadImpl.FileDetails> anexosTemp = new LinkedList<ServiceFileDownloadImpl.FileDetails>();
            for (String chaveAnexo : anexos) {
                ServiceFileDownloadImpl.FileDetails f = this.serviceFileDownloadImpl.getFile(chaveAnexo);
                email.getAnexos().add(new Email.Anexo(f.getFile(), f.getFileName()));
                anexosTemp.add(f);
                ++i;
            }
            try {
                if (TMethods.isWithData((Collection)email.getDestinatarios())) {
                    ToolSendEmail.sendEmailWithException((Email)email);
                    mensagem.setEnviadoComSucesso(Short.valueOf((short)1));
                    continue;
                }
                mensagem.setEnviadoComSucesso(Short.valueOf((short)0));
                mensagem.setDescStatusEnvio(ToolString.cut((String)MessagesBaseMentor.getErrorMsg((String)"E.TSK.000007", (Object[])new Object[]{env}), (int)500));
            }
            catch (Throwable ex) {
                mensagem.setEnviadoComSucesso(Short.valueOf((short)0));
                mensagem.setDescStatusEnvio(ToolString.cut((String)ex.getMessage(), (int)500));
            }
            finally {
                anexosTemp.forEach(j -> {
                    try {
                        this.serviceFileDownloadImpl.removeFile(j.getChaveArquivo());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
        this.afterSend(env);
    }

    private void afterSend(EnvioMensagens env) {
        Collections.sort(env.getMensagens(), (o1, o2) -> o1.getEnviadoComSucesso().compareTo(o2.getEnviadoComSucesso()));
        int i = 0;
        int countMsgErro = 0;
        for (EnvioMensagensMsg msg : env.getMensagens()) {
            msg.setIndice(Integer.valueOf(i));
            ++i;
            if (this.isEquals(msg.getEnviadoComSucesso(), (short)1)) continue;
            ++countMsgErro;
        }
        env.setTodasMsgEnviadas(Short.valueOf((short)1));
        if (countMsgErro > 0) {
            env.setTodasMsgEnviadas(Short.valueOf((short)0));
        }
        this.serviceEnvioMensagens.saveOrUpdate(env);
    }

    private WebEnvMensagem.DTOFileDetails getDTOFileDetails(ServiceFileDownloadImpl.FileDetails f) {
        WebEnvMensagem.DTOFileDetails d = new WebEnvMensagem.DTOFileDetails();
        d.setFile(f.getFile());
        d.setFileName(f.getFileName());
        d.setUrlArquivo(f.getUrlArquivo());
        return d;
    }
}

