/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.equipamento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoEquipamentoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.tipopontocontrole.ServiceTipoPontoControleImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.equipamento.web.DTOEquipamento;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEquipamentoImpl
extends ServiceGenericEntityImpl<Equipamento, Long, DaoEquipamentoImpl> {
    ServiceTipoPontoControleImpl serviceTipoPontoControleImpl;

    @Autowired
    public ServiceEquipamentoImpl(DaoEquipamentoImpl dao, ServiceTipoPontoControleImpl serviceTipoPontoControleImpl) {
        super(dao);
        this.serviceTipoPontoControleImpl = serviceTipoPontoControleImpl;
    }

    @Override
    public Equipamento beforeSave(Equipamento vo) {
        if (!TMethods.isWithData((Collection)vo.getTipoPontoControleAtivo())) {
            vo.setTipoPontoControleAtivo(new LinkedList());
        }
        if (!TMethods.isWithData((Collection)vo.getAtivos())) {
            vo.setAtivos(new LinkedList());
        }
        if (!TMethods.isWithData((Collection)vo.getCombustiveis())) {
            vo.setCombustiveis(new LinkedList());
        }
        if (vo.getAtivos() != null) {
            vo.getAtivos().forEach(e -> e.setEquipamentoPai(vo));
        }
        if (vo.getCombustiveis() != null) {
            vo.getCombustiveis().forEach(e -> e.setEquipamento(vo));
        }
        if (vo.getBem() != null) {
            vo.getBem().setEquipamento(vo);
        }
        vo.getTipoPontoControleAtivo().forEach(i -> i.setEquipamento(vo));
        return vo;
    }

    public Equipamento getByCodigoAndEmpresa(String codigoEquipamento, String cnpj) {
        return ((DaoEquipamentoImpl)this.getDao()).getByCodigoAndEmpresa(codigoEquipamento, cnpj);
    }

    public DTOEquipamento getDTOEquipamento(Long idEquipamento) {
        Equipamento equipamento = (Equipamento)this.get(idEquipamento);
        if (this.isNull(equipamento).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0121.001", new Object[]{idEquipamento}));
        }
        DTOEquipamento dto = this.buildToDTO(equipamento, DTOEquipamento.class);
        return dto;
    }

    public DTOEquipamento.DTOTipoPontoControleAtivo getTipoPontoControleAtivo(Long idPontoControle) {
        TipoPontoControle tipoPontoControle = (TipoPontoControle)this.serviceTipoPontoControleImpl.get(idPontoControle);
        if (this.isNull(tipoPontoControle).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0121.002", new Object[]{idPontoControle}));
        }
        DTOEquipamento.DTOTipoPontoControleAtivo.DTOTipoPontoControle dto = new DTOEquipamento.DTOTipoPontoControleAtivo.DTOTipoPontoControle();
        if (this.isNotNull(tipoPontoControle).booleanValue()) {
            dto.setIdentificador(tipoPontoControle.getIdentificador());
            if (this.isNotNull(tipoPontoControle.getEmpresa()).booleanValue()) {
                dto.setEmpresa(tipoPontoControle.getEmpresa().getIdentificador());
            }
            dto.setDataCadastro(tipoPontoControle.getDataCadastro());
            dto.setDataAtualizacao(tipoPontoControle.getDataAtualizacao());
            dto.setDescricao(tipoPontoControle.getDescricao());
            dto.setAtivo(tipoPontoControle.getAtivo());
        }
        DTOEquipamento.DTOTipoPontoControleAtivo dtoResult = new DTOEquipamento.DTOTipoPontoControleAtivo();
        dtoResult.setDataCadastro(new Date());
        dtoResult.setAtivo(Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        dtoResult.setTipoPontoControle(dto);
        return dtoResult;
    }

    public Boolean isSubComponente(Equipamento equipamento) {
        if (equipamento != null) {
            return ((DaoEquipamentoImpl)this.getDao()).isSubComponente(equipamento);
        }
        return false;
    }

    public Timestamp getDataUltimaManutencao(PlanoManutencaoAtivo planoManutencaoAtivo, Equipamento ativo, Empresa empresa, Short opcaoPesquisa) {
        return ((DaoEquipamentoImpl)this.getDao()).getDataUltimaManutencao(planoManutencaoAtivo, ativo, empresa, opcaoPesquisa);
    }
}

