/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.equipcoletadadosativoiot;

import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoIOT;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoProcIOT;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoSensorIOT;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoEquipColetaDadosAtivoIOTImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.equipamento.ServiceEquipamentoImpl;
import com.touchcomp.basementorservice.service.impl.smartcomponentpref.ServiceSmartComponentPrefImpl;
import com.touchcomp.touchvomodel.vo.equipcoletadadosativoiot.web.DTOEquipColetaDadosAtivoIOT;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEquipColetaDadosAtivoIOTImpl
extends ServiceGenericEntityImpl<EquipColetaDadosAtivoIOT, Long, DaoEquipColetaDadosAtivoIOTImpl> {
    final ServiceEquipamentoImpl serviceEquipamentoImpl;
    final ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl;

    @Autowired
    public ServiceEquipColetaDadosAtivoIOTImpl(DaoEquipColetaDadosAtivoIOTImpl dao, ServiceEquipamentoImpl serviceEquipamentoImpl, ServiceSmartComponentPrefImpl serviceSmartComponentPrefImpl) {
        super(dao);
        this.serviceEquipamentoImpl = serviceEquipamentoImpl;
        this.serviceSmartComponentPrefImpl = serviceSmartComponentPrefImpl;
    }

    @Override
    public EquipColetaDadosAtivoIOT beforeSave(EquipColetaDadosAtivoIOT aux) {
        for (EquipColetaDadosAtivoSensorIOT item : aux.getItensColetaSensores()) {
            item.setEquipColetadoDadosAtivoIOT(aux);
            int i = 0;
            for (EquipColetaDadosAtivoProcIOT proc : item.getItensProcessamento()) {
                proc.setEquipColetadoDadosAtivoSensorIOT(item);
                proc.setIndice(Integer.valueOf(i));
                ++i;
            }
        }
        return aux;
    }

    public List<SmartComponentPref> getSmartComponentsProcessamento() {
        return ((DaoEquipColetaDadosAtivoIOTImpl)this.getDao()).getSmartComponentsProcessamento();
    }

    public DTOEquipColetaDadosAtivoIOT.DTOEquipColetaDadosAtivoProcIOT getsmartCompProc(Long idSmartComponentPref) throws ExceptionObjNotFound {
        SmartComponentPref pref = (SmartComponentPref)this.serviceSmartComponentPrefImpl.getOrThrow(idSmartComponentPref);
        EquipColetaDadosAtivoProcIOT smartComp = new EquipColetaDadosAtivoProcIOT();
        smartComp.setSmartComponente(pref);
        return this.buildToDTOGeneric(smartComp, DTOEquipColetaDadosAtivoIOT.DTOEquipColetaDadosAtivoProcIOT.class);
    }

    public DTOEquipColetaDadosAtivoIOT.DTOEquipColetaDadosAtivoSensorIOT getNovoSensorEquipamento(Long idEquipamento) throws ExceptionObjNotFound {
        Equipamento eq = (Equipamento)this.serviceEquipamentoImpl.getOrThrow(idEquipamento);
        EquipColetaDadosAtivoSensorIOT sensor = new EquipColetaDadosAtivoSensorIOT();
        sensor.setEquipamento(eq);
        return this.buildToDTOGeneric(sensor, DTOEquipColetaDadosAtivoIOT.DTOEquipColetaDadosAtivoSensorIOT.class);
    }

    public EquipColetaDadosAtivoSensorIOT getSensorEquipamento(Long idEquipamento) {
        return ((DaoEquipColetaDadosAtivoIOTImpl)this.getDao()).getSensorEquipamento(idEquipamento);
    }

    public EquipColetaDadosAtivoIOT getOrThrowByEquipamento(Equipamento equipamentoColeta) throws ExceptionObjNotFound {
        EquipColetaDadosAtivoIOT eq = ((DaoEquipColetaDadosAtivoIOTImpl)this.getDao()).getByEquipamento(equipamentoColeta);
        this.throwIfNull(eq, equipamentoColeta.getIdentificador());
        return eq;
    }
}

