/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocambientetrabalho;

import com.touchcomp.basementor.model.vo.EsocAmbienteTrabalho;
import com.touchcomp.basementor.model.vo.EsocAmbienteTrabalhoCC;
import com.touchcomp.basementor.model.vo.EsocAmbienteTrabalhoDepartamentoColaborador;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoEsocAmbienteTrabalhoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.centrocusto.ServiceCentroCustoImpl;
import com.touchcomp.basementorservice.service.impl.departamentocolaborador.ServiceDepartamentoColaboradorImpl;
import com.touchcomp.touchvomodel.vo.esocambientetrabalhocc.web.DTOEsocAmbienteTrabalhoCC;
import com.touchcomp.touchvomodel.vo.esocambientetrabalhodepartamentocolaborador.web.DTOEsocAmbienteTrabalhoDepartamentoColaborador;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocAmbienteTrabalhoImpl
extends ServiceGenericEntityImpl<EsocAmbienteTrabalho, Long, DaoEsocAmbienteTrabalhoImpl> {
    ServiceCentroCustoImpl serviceCentroCustoImpl;
    ServiceDepartamentoColaboradorImpl serviceDepartamentoColaboradorImpl;

    @Autowired
    public ServiceEsocAmbienteTrabalhoImpl(DaoEsocAmbienteTrabalhoImpl dao, ServiceCentroCustoImpl serviceCentroCustoImpl, ServiceDepartamentoColaboradorImpl serviceDepartamentoColaboradorImpl) {
        super(dao);
        this.serviceCentroCustoImpl = serviceCentroCustoImpl;
        this.serviceDepartamentoColaboradorImpl = serviceDepartamentoColaboradorImpl;
    }

    @Override
    public EsocAmbienteTrabalho beforeSaveEntity(EsocAmbienteTrabalho aux) {
        aux.getCentroCustos().forEach(i -> i.setEsocAmbiente(aux));
        aux.getEsocAmbienteTrabalhoDepartamentoColaborador().forEach(i -> i.setEsocAmbienteTrabalho(aux));
        return aux;
    }

    public Pessoa getPessoaAmbienteTrabalho(Long identificador) throws ExceptionValidacaoDados {
        EsocAmbienteTrabalho ambiente = (EsocAmbienteTrabalho)this.get(identificador);
        if (this.isNull(ambiente).booleanValue()) {
            return null;
        }
        if (this.isNull(ambiente.getLotacaoTributaria()).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1743.005", new Object[0]);
        }
        Pessoa pessoa = this.isNotNull(ambiente.getLotacaoTributaria().getPessoa()) != false ? ambiente.getLotacaoTributaria().getPessoa() : ambiente.getLotacaoTributaria().getEmpresa().getPessoa();
        return pessoa;
    }

    public List<DTOEsocAmbienteTrabalhoCC> getCentroCustoAmbienteTrabalho(Long[] ids) {
        List listaCentroCusto = this.serviceCentroCustoImpl.gets(ids);
        List esocAmbirenteTrabalhoCC = listaCentroCusto.stream().map(i -> {
            EsocAmbienteTrabalhoCC item = new EsocAmbienteTrabalhoCC();
            item.setCentroCusto(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(esocAmbirenteTrabalhoCC, DTOEsocAmbienteTrabalhoCC.class);
    }

    public List<DTOEsocAmbienteTrabalhoDepartamentoColaborador> getDepartamentoColaboradorAmbienteTrabalho(Long[] ids) {
        List listaDepartamentoColaborador = this.serviceDepartamentoColaboradorImpl.gets(ids);
        List esocAmbienteTrabalhoDepartamentoColaborador = listaDepartamentoColaborador.stream().map(i -> {
            EsocAmbienteTrabalhoDepartamentoColaborador item = new EsocAmbienteTrabalhoDepartamentoColaborador();
            item.setDepartamentoColaborador(i);
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(esocAmbienteTrabalhoDepartamentoColaborador, DTOEsocAmbienteTrabalhoDepartamentoColaborador.class);
    }
}

