/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esoccadastroestabelcimento;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoEsocCadastroEstabelcimentoImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperAlteracaoEventosEsocial;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperExclusaoEventosEsocial;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.touchvomodel.vo.esoccadastroestabelcimento.web.DTOEsocCadastroEstabelcimento;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocCadastroEstabelcimentoImpl
extends ServiceGenericEntityImpl<EsocCadastroEstabelcimento, Long, DaoEsocCadastroEstabelcimentoImpl> {
    @Autowired
    private HelperEsocPreEvento helperEsocPreEvento;
    @Autowired
    private HelperAlteracaoEventosEsocial helperAlteracaoEvt;
    @Autowired
    private HelperExclusaoEventosEsocial helperExclusaoEvt;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;

    @Autowired
    public ServiceEsocCadastroEstabelcimentoImpl(DaoEsocCadastroEstabelcimentoImpl dao) {
        super(dao);
    }

    public void putStatusESocialRegistro(DTOEsocCadastroEstabelcimento dto) throws ExceptionObjNotFound {
        EsocCadastroEstabelcimento vo = (EsocCadastroEstabelcimento)this.getOrThrow(dto.getIdentificador());
        EsocPreEvento esoc = this.helperEsocPreEvento.getExistePreEvento((InterfaceVOEsocial)vo, vo.getEmpresa());
        if (this.isNotNull(esoc).booleanValue()) {
            if (this.isNull(esoc.getEsocEvento()).booleanValue()) {
                dto.setStatus(MessagesBaseMentor.getMsg((String)"eventoRevisadoNaoEnviado", (Object[])new Object[0]));
            } else {
                Object status = String.valueOf(esoc.getEsocEvento().getStatus());
                if (this.isNotNull(esoc.getEsocEvento().getDescricaoStatus()).booleanValue()) {
                    status = (String)status + " - " + esoc.getEsocEvento().getDescricaoStatus().toUpperCase();
                }
                status = (String)status + " - " + MessagesBaseMentor.getMsg((String)"identificadorLote", (Object[])new Object[0]);
                if (this.isNotNull(esoc.getEsocEvento().getEsocLoteEventos()).booleanValue()) {
                    status = (String)status + ":" + esoc.getEsocEvento().getEsocLoteEventos().getIdentificador();
                }
                dto.setStatus((String)status);
                dto.setNrRecibo(esoc.getEsocEvento().getNrRecibo());
            }
        } else {
            dto.setStatus(MessagesBaseMentor.getMsg((String)"eventoNaoRevisado", (Object[])new Object[0]));
        }
    }

    public void gerarEventoEsocialAlteracao(Date dataInicio, Date dataFim, Long identificador, EnumConstEventoProducao tipoEvento, Usuario usuario, Empresa empresa) throws ExceptionObjNotFound, ExceptionEsocial, ExceptionReflection {
        EsocCadastroEstabelcimento vo = (EsocCadastroEstabelcimento)this.getOrThrow(identificador);
        if (!ServiceEsocCadastroEstabelcimentoImpl.isWithData(vo.getPreEventosEsocial())) {
            throw new ExceptionEsocial(EnumEsocial.ULTIMO_EVENTO_NAO_AUTORIZADO, new Object[0]);
        }
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!this.isEquals(esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa(), empresa.getEmpresaDados().getGrupoEmpresa()) || !this.isNull(esocPreEvento.getEventoPosterior()).booleanValue() || !this.isEquals(esocPreEvento.getEventoProdRestritaProducao(), tipoEvento.getValue())) continue;
            if (this.isNull(esocPreEvento.getEsocEvento()).booleanValue() || !this.isStrWithData(esocPreEvento.getEsocEvento().getNrRecibo())) {
                throw new ExceptionEsocial(EnumEsocial.ULTIMO_EVENTO_NAO_AUTORIZADO, new Object[0]);
            }
            EsocPreEvento newPreEvento = this.helperAlteracaoEvt.gerarEventoAlteracao(vo, esocPreEvento, usuario, tipoEvento, dataInicio, dataFim, empresa);
            this.serviceEsocPreEvento.saveOrUpdate(esocPreEvento);
            return;
        }
    }

    public void gerarEventoEsocialExclusao(Date dataInicio, Date dataFim, Long identificador, EnumConstEventoProducao tipoEvento, Usuario usuario, Empresa empresa) throws ExceptionObjNotFound, ExceptionEsocial, ExceptionReflection {
        EsocCadastroEstabelcimento vo = (EsocCadastroEstabelcimento)this.getOrThrow(identificador);
        if (!ServiceEsocCadastroEstabelcimentoImpl.isWithData(vo.getPreEventosEsocial())) {
            throw new ExceptionEsocial(EnumEsocial.ULTIMO_EVENTO_NAO_AUTORIZADO, new Object[0]);
        }
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!this.isEquals(esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa(), empresa.getEmpresaDados().getGrupoEmpresa()) || !this.isNull(esocPreEvento.getEventoPosterior()).booleanValue() || !this.isEquals(esocPreEvento.getEventoProdRestritaProducao(), tipoEvento.getValue())) continue;
            if (this.isNull(esocPreEvento.getEsocEvento()).booleanValue() || !this.isStrWithData(esocPreEvento.getEsocEvento().getNrRecibo())) {
                throw new ExceptionEsocial(EnumEsocial.ULTIMO_EVENTO_NAO_AUTORIZADO, new Object[0]);
            }
            EsocPreEvento newPreEvento = this.helperExclusaoEvt.gerarEventoExclusao(vo, esocPreEvento, tipoEvento, dataInicio, dataFim, usuario, empresa);
            this.serviceEsocPreEvento.saveOrUpdate(newPreEvento);
            return;
        }
    }

    public void deleteEstabelecimento(Long identificador) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        EsocCadastroEstabelcimento vo = (EsocCadastroEstabelcimento)this.getOrThrow(identificador);
        if (this.isNotNull(vo).booleanValue()) {
            if (ServiceEsocCadastroEstabelcimentoImpl.isWithData(vo.getPreEventosEsocial())) {
                for (EsocPreEvento e : vo.getPreEventosEsocial()) {
                    if (!this.isNotNull(e.getEsocEvento()).booleanValue() || !this.isEquals(EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), e.getEventoProdRestritaProducao()) || !this.isEquals(EnumConstESocialStatus.STATUS_SUCESSO.getValue(), e.getEsocEvento().getStatus())) continue;
                    throw new ExceptionValidacaoDados("E.ERP.1661.001", new Object[0]);
                }
            }
            if (!ServiceEsocCadastroEstabelcimentoImpl.isWithData(vo.getPreEventosEsocial())) {
                this.delete(vo);
            } else {
                List eventos = vo.getPreEventosEsocial();
                vo.setPreEventosEsocial(new ArrayList());
                for (EsocPreEvento e : eventos) {
                    e.setEstabelecimento(null);
                    this.serviceEsocPreEvento.delete(e);
                }
                this.delete(vo);
            }
        }
    }

    public List<EsocCadastroEstabelcimento> getEsocCadastroEstabelecimentoEmpresa(Long idEmpresa) {
        return ((DaoEsocCadastroEstabelcimentoImpl)this.getGenericDao()).getEsocCadastroEstabelecimentoEmpresa(idEmpresa);
    }

    public void buildEsocEventos(EsocCadastroEstabelcimento vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        this.reload(vo);
        if (!ServiceEsocCadastroEstabelcimentoImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
        }
    }

    public EsocCadastroEstabelcimento getByTipoInscricao(String nrInsc, String tpInsc) throws ExceptionObjNotFound {
        EsocCadastroEstabelcimento found = ((DaoEsocCadastroEstabelcimentoImpl)this.getDao()).getPorCnpj(nrInsc);
        if (found != null) {
            return found;
        }
        found = ((DaoEsocCadastroEstabelcimentoImpl)this.getDao()).getPorCei(nrInsc);
        if (found != null) {
            return found;
        }
        this.throwIfNull(found, (Serializable)((Object)nrInsc));
        return null;
    }
}

