/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esoccadastrolotacaotributaria;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocTipoLotacao;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoEsocCadastroLotacaoTributariaImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.helpers.impl.lotacaotributaria.HelperTipoLotacaoTributaria;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.esoctipolotacao.ServiceEsocTipoLotacaoImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocCadastroLotacaoTributariaImpl
extends ServiceGenericEntityImpl<EsocCadastroLotacaoTributaria, Long, DaoEsocCadastroLotacaoTributariaImpl> {
    @Autowired
    private HelperTipoLotacaoTributaria helperTipoLotacaoTributaria;
    @Autowired
    private ServiceEsocTipoLotacaoImpl serviceEsocTipoLotacao;
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private HelperEsocPreEvento helperEsocPreEvento;

    @Autowired
    public ServiceEsocCadastroLotacaoTributariaImpl(DaoEsocCadastroLotacaoTributariaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public EsocCadastroLotacaoTributaria beforeSave(EsocCadastroLotacaoTributaria vo) {
        if (this.informarNrInsc(vo.getTipoLotacao()).booleanValue() && this.isNull(vo.getPessoa()).booleanValue()) {
            throw new ExceptionRuntimeBase(MessagesBaseMentor.getValidationMsg((String)"V.ERP.1663.005", (Object[])new Object[0]));
        }
        if (ServiceEsocCadastroLotacaoTributariaImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.getPreEventosEsocial().forEach(i -> i.setLotacaoTrbutaria(vo));
        }
        return vo;
    }

    public Boolean informarNrInsc(Long idTipoLotacao) {
        EsocTipoLotacao tipoLotacao = (EsocTipoLotacao)this.serviceEsocTipoLotacao.get(idTipoLotacao);
        return this.helperTipoLotacaoTributaria.informarPessoa(tipoLotacao);
    }

    public Boolean informarNrInsc(EsocTipoLotacao tipoLotacao) {
        return this.helperTipoLotacaoTributaria.informarPessoa(tipoLotacao);
    }

    public void buildEsocEventos(EsocCadastroLotacaoTributaria vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (!ServiceEsocCadastroLotacaoTributariaImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
        }
    }

    public void deleteLotacaoTributaria(Long identificador) throws ExceptionObjNotFound, ExceptionValidacaoDados {
        EsocCadastroLotacaoTributaria vo = (EsocCadastroLotacaoTributaria)this.getOrThrow(identificador);
        if (this.isNotNull(vo).booleanValue()) {
            if (ServiceEsocCadastroLotacaoTributariaImpl.isWithData(vo.getPreEventosEsocial())) {
                for (EsocPreEvento e : vo.getPreEventosEsocial()) {
                    if (!this.isNotNull(e.getEsocEvento()).booleanValue() || !this.isEquals(EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), e.getEventoProdRestritaProducao()) || !this.isEquals(EnumConstESocialStatus.STATUS_SUCESSO.getValue(), e.getEsocEvento().getStatus())) continue;
                    throw new ExceptionValidacaoDados("E.ERP.1663.001", new Object[0]);
                }
            }
            if (!ServiceEsocCadastroLotacaoTributariaImpl.isWithData(vo.getPreEventosEsocial())) {
                this.delete(vo);
            } else {
                List eventos = vo.getPreEventosEsocial();
                vo.setPreEventosEsocial(new ArrayList());
                for (EsocPreEvento e : eventos) {
                    e.setLotacaoTrbutaria(null);
                    this.serviceEsocPreEvento.delete(e);
                }
                this.delete(vo);
            }
        }
    }
}

