/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esoccomunicadoacidtrab;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocComunicadoAcidTrab;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoEsocComunicadoAcidTrabImpl;
import com.touchcomp.basementorservice.helpers.impl.esocial.esoccomunicadoacidentetrab.HelperEsocComunicadoAcidTrab;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocComunicadoAcidTrabImpl
extends ServiceGenericEntityImpl<EsocComunicadoAcidTrab, Long, DaoEsocComunicadoAcidTrabImpl> {
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;

    @Autowired
    public ServiceEsocComunicadoAcidTrabImpl(DaoEsocComunicadoAcidTrabImpl dao, ServiceEsocPreEventoImpl serviceEsocPreEvento) {
        super(dao);
        this.serviceEsocPreEvento = serviceEsocPreEvento;
    }

    @Override
    public EsocComunicadoAcidTrab beforeSave(EsocComunicadoAcidTrab vo) {
        if (vo.getAgentesCausadores() != null) {
            vo.getAgentesCausadores().forEach(i -> i.setEsocComunicadoAcidTrab(vo));
        }
        if (vo.getPartesAtingidas() != null) {
            vo.getPartesAtingidas().forEach(i -> i.setEsocComunicadoAcidTrab(vo));
        }
        return vo;
    }

    public List<EsocPreEvento> getEventos(Long identificador, Empresa empresa) throws ExceptionEsocial, ExceptionObjNotFound {
        EsocComunicadoAcidTrab vo = (EsocComunicadoAcidTrab)this.getOrThrow(identificador);
        return new HelperEsocComunicadoAcidTrab().build(vo).verificarEventos((InterfaceVOEsocial)vo, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE);
    }

    public void gerarEventoCat(Long identificador, Empresa empresa, Usuario usuario) throws ExceptionEsocial {
        EsocComunicadoAcidTrab vo = (EsocComunicadoAcidTrab)this.get(identificador);
        if (vo == null) {
            return;
        }
        this.serviceEsocPreEvento.geracaoEventoS2210(vo, usuario, empresa);
    }

    public void apagarEvento(Long identificador) throws ExceptionEsocial {
        this.serviceEsocPreEvento.apagarEvento(identificador);
    }
}

