/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocfechamentofolha;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.service.impl.esocfechamentofolha.ServiceEsocFechamentoFolhaImpl;
import com.touchcomp.touchvomodel.vo.esocfechamentofolha.web.DTOEsocFechamentoFolha;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

class AuxBuilderDTOItensEsoc
extends BaseMethods {
    private final ServiceEsocFechamentoFolhaImpl service;

    public List<DTOEsocFechamentoFolha.DTOESocS1020> buildResEsocS1020(List<ESocS1020> esocs) {
        ArrayList<DTOEsocFechamentoFolha.DTOESocS1020> ret = new ArrayList<DTOEsocFechamentoFolha.DTOESocS1020>();
        if (AuxBuilderDTOItensEsoc.isWithData(esocs)) {
            for (ESocS1020 esoc : esocs) {
                DTOEsocFechamentoFolha.DTOESocS1020 dto = this.service.buildToDTOGeneric(esoc, DTOEsocFechamentoFolha.DTOESocS1020.class);
                dto.setColaborador(esoc.getColaborador().getPessoa().getNome().toUpperCase());
                if (this.isNull(dto.getItensS1020()).booleanValue()) {
                    dto.setItensS1020(new ArrayList());
                } else {
                    dto.getItensS1020().clear();
                }
                if (AuxBuilderDTOItensEsoc.isWithData(esoc.getItensS1020())) {
                    for (EsocItemS1020 item : esoc.getItensS1020()) {
                        DTOEsocFechamentoFolha.DTOEsocItemS1020 dtoItem = this.service.buildToDTOGeneric(item, DTOEsocFechamentoFolha.DTOEsocItemS1020.class);
                        this.putData(item, dtoItem);
                        dto.getItensS1020().add(dtoItem);
                    }
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    public List<DTOEsocFechamentoFolha.DTOEsocS1010> buildResEsocS1010(List<EsocS1010> esocs, EmpresaRh empresaRh) {
        ArrayList<DTOEsocFechamentoFolha.DTOEsocS1010> ret = new ArrayList<DTOEsocFechamentoFolha.DTOEsocS1010>();
        if (AuxBuilderDTOItensEsoc.isWithData(esocs)) {
            for (EsocS1010 esoc : esocs) {
                DTOEsocFechamentoFolha.DTOEsocS1010 dto = this.service.buildToDTOGeneric(esoc, DTOEsocFechamentoFolha.DTOEsocS1010.class);
                dto.setColaborador(esoc.getColaborador().getPessoa().getNome().toUpperCase());
                if (this.isNull(dto.getItensS1010()).booleanValue()) {
                    dto.setItensS1010(new ArrayList());
                } else {
                    dto.getItensS1010().clear();
                }
                if (AuxBuilderDTOItensEsoc.isWithData(esoc.getItensS1010())) {
                    for (EsocItemS1010 item : esoc.getItensS1010()) {
                        DTOEsocFechamentoFolha.DTOEsocItemS1010 dtoItem = this.service.buildToDTOGeneric(item, DTOEsocFechamentoFolha.DTOEsocItemS1010.class);
                        if (this.isNotNull(item.getMovimentoFolha()).booleanValue()) {
                            dtoItem.setValorInss(this.getValorInss(item));
                            dtoItem.setBcCalcInss(this.getBcCalculoInss(item));
                            dtoItem.setBcESocialInss(this.getBaseInssEsocial(item.getMovimentoFolha(), empresaRh));
                            if (this.isNotNull(item.getMovimentoFolha().getAberturaPeriodo()).booleanValue()) {
                                dtoItem.setTipoFolha(item.getMovimentoFolha().getAberturaPeriodo().getTipoCalculo().getDescricao().toUpperCase());
                                dtoItem.setPeriodo(item.getMovimentoFolha().getAberturaPeriodo().getDataFinal());
                            }
                        } else if (this.isNotNull(item.getFerias()).booleanValue()) {
                            dtoItem.setTipoFolha(MessagesBaseMentor.getMsg((String)"ferias", (Object[])new Object[0]));
                            dtoItem.setPeriodo(item.getFerias().getDataPagamento());
                            dtoItem.setValorInss(item.getFerias().getVrInssFerias());
                            dtoItem.setBcCalcInss(item.getFerias().getBcInssFerias());
                            dtoItem.setBcESocialInss(item.getFerias().getBcInssFerias());
                        }
                        if (this.isNotNull(item.getS1010()).booleanValue()) {
                            dtoItem.setObservacao(item.getS1010().getObservacao());
                        }
                        dto.getItensS1010().add(dtoItem);
                    }
                }
                ret.add(dto);
            }
        }
        return ret;
    }

    private void putData(EsocItemS1020 vo, DTOEsocFechamentoFolha.DTOEsocItemS1020 dto) {
        if (this.isNotNull(vo.getFeriasColaborador()).booleanValue()) {
            dto.setDataPagamento(vo.getFeriasColaborador().getDataPagamento());
            dto.setTipoMovimento(MessagesBaseMentor.getMsg((String)"ferias", (Object[])new Object[0]));
            dto.setValorIrrf(vo.getFeriasColaborador().getVrIrrfFerias());
            dto.setValorPensao(Double.valueOf(0.0));
            if (AuxBuilderDTOItensEsoc.isWithData(vo.getFeriasColaborador().getRubricasFerias())) {
                for (RubricasFerias r : vo.getFeriasColaborador().getRubricasFerias()) {
                    TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
                    this.service.reload(tipoCalculo);
                    if (!this.isEquals(tipoCalculo.getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                    dto.setValorPensao(r.getValorRubrica());
                    break;
                }
            }
        } else if (this.isNotNull(vo.getMovimentoFolha()).booleanValue()) {
            dto.setDataPagamento(vo.getMovimentoFolha().getAberturaPeriodo().getDataPagamento());
            dto.setTipoMovimento(vo.getMovimentoFolha().getAberturaPeriodo().getTipoCalculo().getDescricao().toUpperCase());
            dto.setValorPensao(Double.valueOf(0.0));
            if (AuxBuilderDTOItensEsoc.isWithData(vo.getMovimentoFolha().getRubricas1210())) {
                for (Rubricas1210 r : vo.getMovimentoFolha().getRubricas1210()) {
                    if (!this.isEquals(r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                    dto.setValorPensao(r.getValorRubrica());
                    break;
                }
            }
            dto.setValorIrrf(vo.getMovimentoFolha().getVrIrrfSalario());
        } else if (this.isNotNull(vo.getRescisao()).booleanValue()) {
            dto.setDataPagamento(vo.getRescisao().getDataPagamento());
            dto.setTipoMovimento(MessagesBaseMentor.getMsg((String)"rescisao", (Object[])new Object[0]));
            dto.setValorIrrf(vo.getRescisao().getVrlIrrf());
            dto.setValorPensao(Double.valueOf(0.0));
            if (AuxBuilderDTOItensEsoc.isWithData(vo.getRescisao().getRubricas())) {
                for (Rubricas2299 r : vo.getRescisao().getRubricas()) {
                    if (!this.isEquals(r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo(), ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                    dto.setValorPensao(r.getValorRubrica());
                    break;
                }
            }
        } else if (vo.getRescisaoComplementar() != null) {
            dto.setDataPagamento(vo.getRescisaoComplementar().getDataPagamento());
            dto.setTipoMovimento(MessagesBaseMentor.getMsg((String)"rescisaoComplementar", (Object[])new Object[0]));
            dto.setValorIrrf(Double.valueOf(0.0));
            dto.setValorPensao(Double.valueOf(0.0));
        } else if (vo.getTerminoTrabSemVinculo() != null) {
            dto.setDataPagamento(vo.getTerminoTrabSemVinculo().getDataPagamento());
            dto.setTipoMovimento(MessagesBaseMentor.getMsg((String)"terminoTsv", (Object[])new Object[0]));
            dto.setValorIrrf(Double.valueOf(0.0));
            dto.setValorPensao(Double.valueOf(0.0));
        } else {
            dto.setTipoMovimento(MessagesBaseMentor.getMsg((String)"entidadeNaoMapeada", (Object[])new Object[0]));
            dto.setValorIrrf(Double.valueOf(0.0));
            dto.setValorPensao(Double.valueOf(0.0));
        }
        if (this.isNotNull(vo.getEsocS1020()).booleanValue()) {
            dto.setObservacao(vo.getEsocS1020().getObservacao());
        }
    }

    private Double getBcCalculoInss(EsocItemS1010 item) {
        return item.getMovimentoFolha().getBcInssSalario() + item.getMovimentoFolha().getBcInssFerias();
    }

    private Double getValorInss(EsocItemS1010 item) {
        return item.getMovimentoFolha().getVrInssSalario() + item.getMovimentoFolha().getVrInssFerias();
    }

    private Double getBaseInssEsocial(MovimentoFolha movimentoFolha, EmpresaRh empresaRh) {
        Double valorBase = 0.0;
        for (Rubricas1200 r : movimentoFolha.getRubricas1200()) {
            if (!(!this.isEquals(movimentoFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha(), EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()) ? this.isEquals(r.getTipoCalculo(), empresaRh.getEventoBaseInss()) : this.isEquals(r.getTipoCalculo(), empresaRh.getEventoBaseInssDec()))) continue;
            return r.getValorRubrica();
        }
        return valorBase;
    }

    @Generated
    public AuxBuilderDTOItensEsoc(ServiceEsocFechamentoFolhaImpl service) {
        this.service = service;
    }
}

