/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocfechamentofolha;

import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.CompCarregarEventosEsocFecFolha;
import com.touchcomp.basementorservice.components.esocfechamentofolha.eventos.CompEventosEsocFecFolha;
import com.touchcomp.basementorservice.dao.impl.DaoEsocFechamentoFolhaImpl;
import com.touchcomp.basementorservice.dao.impl.DaoFeriasColaboradorImpl;
import com.touchcomp.basementorservice.dao.impl.DaoMovimentoFolhaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocfechamentofolha.AuxBuilderDTOItensEsoc;
import com.touchcomp.basementorservice.service.impl.feriascolaborador.ServiceFeriasColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.movimentofolha.ServiceMovimentoFolhaImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.esocfechamentofolha.web.DTOEventosEsocFechamentoFolha;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocFechamentoFolhaImpl
extends ServiceGenericEntityImpl<EsocFechamentoFolha, Long, DaoEsocFechamentoFolhaImpl> {
    @Autowired
    private ServiceMovimentoFolhaImpl serviceMovimentoFolha;
    @Autowired
    private ServiceFeriasColaboradorImpl serviceFeriasColaborador;
    @Autowired
    private CompEventosEsocFecFolha compEventosFolha;
    @Autowired
    private CompCarregarEventosEsocFecFolha compLoadEventos;

    @Autowired
    public ServiceEsocFechamentoFolhaImpl(DaoEsocFechamentoFolhaImpl dao) {
        super(dao);
    }

    @Override
    public EsocFechamentoFolha beforeSave(EsocFechamentoFolha vo) {
        if (this.isNotNull(vo.getEsocS1010()).booleanValue()) {
            for (EsocS1010 evt : vo.getEsocS1010()) {
                evt.setEsocFechamentoFolha(vo);
                if (!this.isNotNull(evt.getItensS1010()).booleanValue()) continue;
                evt.getItensS1010().forEach(i -> i.setS1010(evt));
            }
        }
        if (this.isNotNull(vo.getEsocS1020()).booleanValue()) {
            for (EsocS1010 evt : vo.getEsocS1020()) {
                evt.setEsocFechamento(vo);
                if (!this.isNotNull(evt.getItensS1020()).booleanValue()) continue;
                evt.getItensS1020().forEach(arg_0 -> ServiceEsocFechamentoFolhaImpl.lambda$beforeSave$1((ESocS1020)evt, arg_0));
            }
        }
        if (this.isNotNull(vo.getPreEventosEsocial()).booleanValue()) {
            vo.getPreEventosEsocial().forEach(i -> i.setEsocFechamentoFolha(vo));
        }
        return vo;
    }

    public DTOEventosEsocFechamentoFolha carregarEventosFolha(Long periodoRef, Short tipoFolha, GrupoEmpresa grupoEmpresa, EmpresaRh empresaRh) throws ExceptionReflection, ExceptionValidacaoDados, ExceptionEsocial, ExceptionInvalidData {
        if (this.isNull(grupoEmpresa).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1710.002", new Object[0]);
        }
        if (this.isNull(periodoRef).booleanValue()) {
            throw new ExceptionValidacaoDados("E.ERP.1710.003", new Object[0]);
        }
        this.reload(grupoEmpresa);
        this.reload(empresaRh);
        Date dataInicial = ToolDate.getFirtDateOnMonth((Date)new Date(periodoRef));
        Date dataFinal = ToolDate.getLastDateOnMonth((Date)new Date(periodoRef));
        DTOEventosEsocFechamentoFolha ret = new DTOEventosEsocFechamentoFolha();
        List<EsocS1010> esocs1010 = this.compLoadEventos.preencherDadosEsocialS1010(dataInicial, dataFinal, grupoEmpresa, tipoFolha, empresaRh);
        AuxBuilderDTOItensEsoc builder = new AuxBuilderDTOItensEsoc(this);
        ret.setEsocS1010(builder.buildResEsocS1010(esocs1010, empresaRh));
        List<EsocS1010> esocs1010Adv = this.compLoadEventos.carregarAdvertenciasDadosEsocialS1010(esocs1010);
        ret.setAdvertencias(builder.buildResEsocS1010(esocs1010Adv, empresaRh));
        ((DaoMovimentoFolhaImpl)this.serviceMovimentoFolha.getDao()).getSession().clear();
        ((DaoFeriasColaboradorImpl)this.serviceFeriasColaborador.getDao()).getSession().clear();
        List<ESocS1020> esocs1020 = this.compLoadEventos.preencherDadosEsocialS1020(dataInicial, dataFinal, grupoEmpresa, tipoFolha, empresaRh);
        ret.setEsocS1020(builder.buildResEsocS1020(esocs1020));
        if (!TMethods.isWithData((Collection)ret.getEsocS1010()) && !TMethods.isWithData((Collection)ret.getEsocS1020())) {
            throw new ExceptionInvalidData("E.ERP.1710.004", new Object[0]);
        }
        return ret;
    }

    public EsocFechamentoFolha salvarFechamentoFolha(EsocFechamentoFolha vo, EmpresaRh empresaRh) throws ExceptionValidacaoDados, ExceptionEsocial, ExceptionReflection {
        this.reload(empresaRh);
        Date dataInicial = ToolDate.getFirtDateOnMonth((Date)vo.getPeriodoApuracao());
        Date dataFinal = ToolDate.getLastDateOnMonth((Date)vo.getPeriodoApuracao());
        vo.setEsocS1010(this.compLoadEventos.preencherDadosEsocialS1010(dataInicial, dataFinal, vo.getGrupoEmpresa(), vo.getTipoFolha(), empresaRh));
        ((DaoMovimentoFolhaImpl)this.serviceMovimentoFolha.getDao()).getSession().clear();
        ((DaoFeriasColaboradorImpl)this.serviceFeriasColaborador.getDao()).getSession().clear();
        vo.setEsocS1020(this.compLoadEventos.preencherDadosEsocialS1020(dataInicial, dataFinal, vo.getGrupoEmpresa(), vo.getTipoFolha(), empresaRh));
        this.beforeSave(vo);
        vo = this.saveOrUpdate(vo);
        this.afterSaveEntity(vo);
        return vo;
    }

    public void gerarEventosFechamentoESocial(Long idFechamentoFolha, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionObjNotFound {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)this.getOrThrow(idFechamentoFolha);
        if (this.isNotNull(vo).booleanValue()) {
            this.reload(empresa);
            this.reload(usuario);
            this.compEventosFolha.gerarEventosFechamentoESocial(vo, usuario, empresa);
        }
    }

    public void retificarEvento1200(Long idFechamentoFolha, Usuario usuario, Empresa empresa, EmpresaRh empresaRh, Short tipoEvento) throws ExceptionEsocial, ExceptionObjNotFound, ExceptionInvalidData {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)this.getOrThrow(idFechamentoFolha);
        if (this.isNotNull(vo).booleanValue()) {
            this.reload(empresa);
            this.reload(usuario);
            this.reload(empresaRh);
            this.compEventosFolha.retificarEvento1200(vo, usuario, empresa, empresaRh, tipoEvento);
        }
    }

    public void retificarEvento1210(Long idFechamentoFolha, Usuario usuario, Empresa empresa, EmpresaRh empresaRh, Short tipoEvento) throws ExceptionEsocial, ExceptionObjNotFound, ExceptionInvalidData {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)this.getOrThrow(idFechamentoFolha);
        if (this.isNotNull(vo).booleanValue()) {
            this.reload(empresa);
            this.reload(usuario);
            this.reload(empresaRh);
            this.compEventosFolha.retificarEvento1210(vo, usuario, empresa, empresaRh, tipoEvento);
        }
    }

    public void retificarEvento1280(Long idFechamentoFolha, Usuario usuario, Empresa empresa, Short tipoEvento) throws ExceptionEsocial, ExceptionObjNotFound {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)this.getOrThrow(idFechamentoFolha);
        if (this.isNotNull(vo).booleanValue()) {
            this.reload(empresa);
            this.reload(usuario);
            this.compEventosFolha.retificarEvento1280(vo, usuario, empresa, tipoEvento);
        }
    }

    public void gerarExclusaoEvento1200(Long idFechamentoFolha) throws ExceptionEsocial, ExceptionObjNotFound {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)this.getOrThrow(idFechamentoFolha);
        if (this.isNotNull(vo).booleanValue()) {
            this.compEventosFolha.gerarExclusaoEvento1200(vo);
        }
    }

    public void gerarExclusaoEvento1210(Long idFechamentoFolha) throws ExceptionEsocial, ExceptionObjNotFound {
        EsocFechamentoFolha vo = (EsocFechamentoFolha)this.getOrThrow(idFechamentoFolha);
        if (this.isNotNull(vo).booleanValue()) {
            this.compEventosFolha.gerarExclusaoEvento1210(vo);
        }
    }

    private static /* synthetic */ void lambda$beforeSave$1(ESocS1020 evt, EsocItemS1020 i) {
        i.setEsocS1020(evt);
    }
}

