/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocial;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocLoteEventos;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.components.DocEsocialBase;
import com.touchcomp.basementorexceptions.exceptions.impl.assinaturaxml.ExceptionAssinaturaXML;
import com.touchcomp.basementorexceptions.exceptions.impl.axis.ExceptionAxis;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionInvalidXML;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.esocial.UtilServiceEsocialPreEventos;
import com.touchcomp.basementorservice.service.impl.esocloteeventos.ServiceEsocLoteEventosImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEsocial;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocialImpl
extends ServiceGenericImpl
implements ServiceEsocial {
    @Override
    public void avaliarGerarEventoEsocial(InterfaceVOEsocial vo, Empresa emp, Usuario usuario, OpcoesESocial opcoes) throws ExceptionEsocial, ExceptionJaxb, ExceptionReflection {
        new UtilServiceEsocialPreEventos().avaliarGerarEventoEsocial(vo, emp, usuario, opcoes);
    }

    @Override
    public void avaliarGerarEventoEsocialDelecao(InterfaceVOEsocial vo, Empresa emp, Usuario usuario) throws ExceptionEsocial, ExceptionJaxb, ExceptionReflection {
        new UtilServiceEsocialPreEventos().avaliarGerarEventoEsocialDelecao(vo, emp, usuario);
    }

    @Override
    public EsocLoteEventos sendLoteEventosEsocial(EsocLoteEventos loteEventos, OpcoesESocial opcoes, ConfiguracaoCertificado conf) throws ExceptionEsocial, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        DocEsocialBase docEsocial = (DocEsocialBase)ConfApplicationContext.getBean(DocEsocialBase.class);
        ServiceEsocLoteEventosImpl serviceEsocLoteEventos = (ServiceEsocLoteEventosImpl)ConfApplicationContext.getBean(ServiceEsocLoteEventosImpl.class);
        docEsocial.enviarLoteEventos(loteEventos, opcoes, conf);
        return serviceEsocLoteEventos.saveOrUpdate(loteEventos);
    }

    @Override
    public EsocLoteEventos consultaLoteEventosEsocial(EsocLoteEventos loteEventos, OpcoesESocial opcoes, ConfiguracaoCertificado conf) throws ExceptionEsocial, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        DocEsocialBase docEsocial = (DocEsocialBase)ConfApplicationContext.getBean(DocEsocialBase.class);
        ServiceEsocLoteEventosImpl serviceEsocLoteEventos = (ServiceEsocLoteEventosImpl)ConfApplicationContext.getBean(ServiceEsocLoteEventosImpl.class);
        docEsocial.consultaLoteEventosEsocial(loteEventos, opcoes, conf);
        this.desvincularEsocPreEvento(loteEventos);
        return serviceEsocLoteEventos.saveOrUpdate(loteEventos);
    }

    @Override
    public void validarXMLLoteEventos(EsocLoteEventos loteEventos, OpcoesESocial opcoesESocial) throws ExceptionInvalidXML, ExceptionEsocial, ExceptionJaxb, ExceptionIO, ExceptionJDom {
        DocEsocialBase docEsocial = (DocEsocialBase)ConfApplicationContext.getBean(DocEsocialBase.class);
        docEsocial.validarXMLLoteEventos(loteEventos, opcoesESocial);
    }

    @Override
    public String salvarXml(EsocEvento e, OpcoesESocial opcoesESocial) throws ExceptionInvalidXML, ExceptionEsocial, ExceptionJaxb, ExceptionIO, ExceptionJDom {
        DocEsocialBase docEsocial = (DocEsocialBase)ConfApplicationContext.getBean(DocEsocialBase.class);
        return docEsocial.salvarXml(e, opcoesESocial);
    }

    private void desvincularEsocPreEvento(EsocLoteEventos loteEventos) {
        ServiceEsocPreEventoImpl serviceEsocPreEventoImpl = (ServiceEsocPreEventoImpl)ConfApplicationContext.getBean(ServiceEsocPreEventoImpl.class);
        boolean statusSucesso = loteEventos.getEventos().stream().allMatch(i -> this.isEquals(i.getStatus(), (long)EnumConstESocialStatus.STATUS_SUCESSO.getEnumId()) || this.isEquals(i.getStatus(), (long)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getEnumId()));
        if (statusSucesso && this.isEquals(loteEventos.getTipoEvento().getIdentificador(), EnumConstTipoEventoESocial.EXCLUSAO_EVENTOS.getEnumId().longValue())) {
            for (EsocEvento e : loteEventos.getEventos()) {
                if (!this.isNotNull(e.getPreEvento().getExclusaoEventos()).booleanValue() || e.getPreEvento().getExclusaoEventos().getIdentificador() <= 0L) continue;
                EsocPreEvento preEvento = e.getPreEvento().getExclusaoEventos().getEsocEventoAExcluir().getPreEvento();
                this.limparEsocEvento(preEvento, serviceEsocPreEventoImpl);
            }
        }
    }

    private void limparEsocEvento(EsocPreEvento preEvento, ServiceEsocPreEventoImpl serviceEsocPreEventoImpl) {
        if (this.isNotNull(preEvento).booleanValue()) {
            preEvento.setEsocEvento(null);
            serviceEsocPreEventoImpl.saveOrUpdate(preEvento);
            this.limparEsocEvento(preEvento.getEventoAnterior(), serviceEsocPreEventoImpl);
        }
    }
}

