/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocial;

import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.components.DocEsocialBase;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.service.interfaces.ServiceEsocPreEvento;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Date;

public class UtilServiceEsocialPreEventos {
    private final DocEsocialBase docEsocialBase = (DocEsocialBase)ConfApplicationContext.getBean(DocEsocialBase.class);
    private final ServiceEsocPreEvento serviceEsocPreEvento = (ServiceEsocPreEvento)ConfApplicationContext.getBean(ServiceEsocPreEvento.class);

    void avaliarGerarEventoEsocialDelecao(InterfaceVOEsocial vo, Empresa emp, Usuario usuario) throws ExceptionEsocial, ExceptionJaxb, ExceptionReflection {
        EsocPreEvento preEvento = this.createNewPreEvento(emp, usuario, vo);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value));
        vo.getPreEventosEsocial().add(preEvento);
        for (EsocPreEvento item : vo.getPreEventosEsocial()) {
            item.setEmpresaRH(null);
            this.serviceEsocPreEvento.saveOrUpdate(item);
        }
    }

    void avaliarGerarEventoEsocial(InterfaceVOEsocial vo, Empresa emp, Usuario usuario, OpcoesESocial opcoes) throws ExceptionEsocial, ExceptionJaxb, ExceptionReflection {
        EsocPreEvento lastPreEvento = this.getLastEvento(vo);
        if (vo.getPreEventosEsocial().isEmpty()) {
            EsocPreEvento preEvento = this.createNewPreEvento(emp, usuario, vo);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
            preEvento = this.serviceEsocPreEvento.saveOrUpdate(preEvento);
            vo.getPreEventosEsocial().add(preEvento);
        } else if (vo.getPreEventosEsocial().size() > 0) {
            EsocPreEvento preEvento = this.createNewPreEvento(emp, usuario, vo);
            if (this.gerarEvtAlteracao(preEvento, lastPreEvento, opcoes)) {
                preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
                preEvento.setEventoAnterior(lastPreEvento);
                preEvento = this.serviceEsocPreEvento.saveOrUpdate(preEvento);
                lastPreEvento.setEventoPosterior(preEvento);
                lastPreEvento = this.serviceEsocPreEvento.saveOrUpdate(preEvento);
                vo.getPreEventosEsocial().add(preEvento);
            }
        } else {
            throw new ExceptionEsocial(EnumEsocial.ERRO_AVALIAR_GERAR_PRE_EVENTO_ESOC, new Object[]{vo, emp, usuario});
        }
    }

    private EsocPreEvento createNewPreEvento(Empresa emp, Usuario usuario, InterfaceVOEsocial vo) throws ExceptionEsocial, ExceptionReflection {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(new Date());
        pre.setDataFimVal(null);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(emp);
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade(vo.toString());
        pre.setIdentificacaoEntidade(this.getIdEntidade(vo));
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        this.setOrigem(pre, vo);
        return pre;
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (!(vo instanceof EmpresaRh)) {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
        preEvento.setEmpresaRH((EmpresaRh)vo);
    }

    private boolean gerarEvtAlteracao(EsocPreEvento temp, EsocPreEvento lastEvt, OpcoesESocial opcoes) throws ExceptionEsocial, ExceptionJaxb, ExceptionReflection {
        if (lastEvt.getCodigoHashPreEvento() == null) {
            return false;
        }
        if (lastEvt.getEsocEvento() == null) {
            return false;
        }
        if (this.statusInvalidoAlteracao(lastEvt)) {
            throw new ExceptionEsocial(EnumEsocial.LINK_EVENTOS_INCORRETO, new Object[]{lastEvt});
        }
        String hash = this.docEsocialBase.gerarHashXMLEvento(temp, opcoes);
        return !lastEvt.getCodigoHashPreEvento().equals(hash);
    }

    private EsocPreEvento getLastEvento(InterfaceVOEsocial vo) throws ExceptionEsocial {
        EsocPreEvento temp = null;
        for (EsocPreEvento item : vo.getPreEventosEsocial()) {
            if (item.getEventoPosterior() != null) continue;
            if (temp != null) {
                throw new ExceptionEsocial(EnumEsocial.LINK_EVENTOS_INCORRETO, new Object[]{item});
            }
            temp = item;
        }
        if (temp == null) {
            throw new ExceptionEsocial(EnumEsocial.LINK_EVENTOS_ALTERACAO_INCORRETO_NULL, new Object[]{vo});
        }
        return temp;
    }

    private String getIdEntidade(InterfaceVOEsocial vo) throws ExceptionReflection {
        return String.valueOf(ToolReflections.getIdValueFromVOModel((Object)vo));
    }

    private boolean statusInvalidoAlteracao(EsocPreEvento lastEvt) {
        Long status = lastEvt.getEsocEvento().getStatus();
        return status != null && status > 0L;
    }
}

