/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocinfotributosdecorrentesprocessotrab;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocInfoTributosDecorrentesProcessoTrab;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.IdentificacaoTrabalhador;
import com.touchcomp.basementor.model.vo.InformacaoCodigoReceitaCrontribuicao;
import com.touchcomp.basementor.model.vo.InformacaoCodigoReceitaIRRF;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresCalculoTributario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoEsocInfoTributosDecorrentesProcessoTrabImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.codigoreceita.ServiceCodigoReceitaImpl;
import com.touchcomp.basementorservice.service.impl.codigoreceitaimpostorendaretidonafonte.ServiceCodigoReceitaImpostoRendaRetidoNaFonteImpl;
import com.touchcomp.basementorservice.service.impl.processotrabalhista.ServiceProcessoTrabalhistaImpl;
import com.touchcomp.touchvomodel.vo.identificacaotrabalhador.web.DTOIdentificacaoTrabalhador;
import com.touchcomp.touchvomodel.vo.informacaocodigoreceitacrontribuicao.web.DTOInformacaoCodigoReceitaCrontribuicao;
import com.touchcomp.touchvomodel.vo.informacaocodigoreceitairrf.web.DTOInformacaoCodigoReceitaIRRF;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocInfoTributosDecorrentesProcessoTrabImpl
extends ServiceGenericEntityImpl<EsocInfoTributosDecorrentesProcessoTrab, Long, DaoEsocInfoTributosDecorrentesProcessoTrabImpl> {
    @Autowired
    HelperEsocPreEvento helper;
    ServiceProcessoTrabalhistaImpl serviceProcessoTrabalhistaImpl;
    ServiceCodigoReceitaImpl serviceCodigoReceitaImpl;
    ServiceCodigoReceitaImpostoRendaRetidoNaFonteImpl serviceCodigoReceitaImpostoRendaRetidoNaFonteImpl;

    @Autowired
    public ServiceEsocInfoTributosDecorrentesProcessoTrabImpl(DaoEsocInfoTributosDecorrentesProcessoTrabImpl dao, ServiceProcessoTrabalhistaImpl serviceProcessoTrabalhistaImpl, ServiceCodigoReceitaImpl serviceCodigoReceitaImpl, ServiceCodigoReceitaImpostoRendaRetidoNaFonteImpl serviceCodigoReceitaImpostoRendaRetidoNaFonteImpl) {
        super(dao);
        this.serviceProcessoTrabalhistaImpl = serviceProcessoTrabalhistaImpl;
        this.serviceCodigoReceitaImpl = serviceCodigoReceitaImpl;
        this.serviceCodigoReceitaImpostoRendaRetidoNaFonteImpl = serviceCodigoReceitaImpostoRendaRetidoNaFonteImpl;
    }

    @Override
    public EsocInfoTributosDecorrentesProcessoTrab beforeSaveEntity(EsocInfoTributosDecorrentesProcessoTrab aux) {
        aux.getPreEventosEsocial().forEach(i -> i.setInfoTributosDecorrentesProcessoTrab(aux));
        aux.getIdeTrab().forEach(i -> {
            i.setEsocInfoTributosDecorrentesProcessoTrab(aux);
            i.getValorCalcTrib().forEach(valorCalcTrib -> {
                valorCalcTrib.setIdeTrab(i);
                valorCalcTrib.getInfCodReceita().forEach(receita -> receita.setVlrCalcTrib(valorCalcTrib));
            });
            i.getInfoCRIRRF().forEach(crIRRF -> {
                crIRRF.setIdeTrab(i);
                crIRRF.getDedDepen().forEach(dedDepen -> dedDepen.setInfoCRIRRF(crIRRF));
                crIRRF.getPenAlim().forEach(penAlim -> penAlim.setInfoCRIRRF(crIRRF));
                crIRRF.getInfoProcRet().forEach(procRet -> {
                    procRet.setInfoCRIRRF(crIRRF);
                    procRet.getDedSusp().forEach(dedSusp -> {
                        dedSusp.setInfoProcRet(procRet);
                        dedSusp.getBenefPen().forEach(benefPensao -> benefPensao.setDedSusp(dedSusp));
                    });
                });
            });
        });
        return aux;
    }

    public void buildEsocEventos(EsocInfoTributosDecorrentesProcessoTrab vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (vo.getPreEventosEsocial() == null || vo.getPreEventosEsocial().isEmpty()) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
        }
    }

    public List<DTOIdentificacaoTrabalhador> buscarColaborador(String nrProcTrab) throws ExceptionObjNotFound {
        List<EsocProcessoTrabalhista> listEsocProcessoTrabalhista = this.serviceProcessoTrabalhistaImpl.getEsocProcessoTrabalhistaByNrProcTrab(nrProcTrab);
        List listIdentificacaoTrabalhador = listEsocProcessoTrabalhista.stream().map(i -> {
            IdentificacaoTrabalhador identificacaoTrabalhador = new IdentificacaoTrabalhador();
            identificacaoTrabalhador.setProcesso(i);
            identificacaoTrabalhador.setValorCalcTrib(i.getBaseCalculoContribPrevidenciarias().stream().map(b -> {
                ValoresCalculoTributario valoresCalculoTributario = new ValoresCalculoTributario();
                valoresCalculoTributario.setIdeTrab(identificacaoTrabalhador);
                valoresCalculoTributario.setPerRef(b.getPerRef());
                valoresCalculoTributario.setVrBcCpMensal(b.getVrBcCpMensal());
                valoresCalculoTributario.setVrBcCp13(b.getVrBcCp13());
                return valoresCalculoTributario;
            }).collect(Collectors.toList()));
            return identificacaoTrabalhador;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(listIdentificacaoTrabalhador, DTOIdentificacaoTrabalhador.class);
    }

    public List<DTOInformacaoCodigoReceitaCrontribuicao> getInformacaoCodigoReceitaContribuicao(Long[] ids) {
        List codigoReceita = this.serviceCodigoReceitaImpl.gets(ids);
        List informacaoCodigoReceitaCrontribuicao = codigoReceita.stream().map(i -> {
            InformacaoCodigoReceitaCrontribuicao item = new InformacaoCodigoReceitaCrontribuicao();
            item.setTpCR(i.getCodigo());
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(informacaoCodigoReceitaCrontribuicao, DTOInformacaoCodigoReceitaCrontribuicao.class);
    }

    public List<DTOInformacaoCodigoReceitaIRRF> getInformacaoCodigoReceitaIRRF(Long[] ids) {
        List codigoReceitaIRRNF = this.serviceCodigoReceitaImpostoRendaRetidoNaFonteImpl.gets(ids);
        List informacaoCodigoReceitaIRRF = codigoReceitaIRRNF.stream().map(i -> {
            InformacaoCodigoReceitaIRRF item = new InformacaoCodigoReceitaIRRF();
            item.setTpCR(i.getCodigo());
            return item;
        }).collect(Collectors.toList());
        return this.buildToDTOGeneric(informacaoCodigoReceitaIRRF, DTOInformacaoCodigoReceitaIRRF.class);
    }
}

