/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocloteeventos;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocLoteEventos;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.IdentificacaoAmbienteEsocial;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.assinaturaxml.ExceptionAssinaturaXML;
import com.touchcomp.basementorexceptions.exceptions.impl.axis.ExceptionAxis;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionInvalidXML;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.dao.impl.DaoEsocLoteEventosImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.empresarh.ServiceEmpresaRhImpl;
import com.touchcomp.basementorservice.service.impl.esocevento.ServiceEsocEventoImpl;
import com.touchcomp.basementorservice.service.impl.esocial.ServiceEsocialImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementorservice.service.impl.identificacaoambienteesocial.ServiceIdentificacaoAmbienteEsocialImpl;
import com.touchcomp.basementorservice.service.impl.opcoesesocial.ServiceOpcoesESocialImpl;
import com.touchcomp.basementorservice.service.impl.tipoeventoesocial.ServiceTipoEventoEsocialImpl;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.touchvomodel.res.DTOEntidadeCodigoRes;
import com.touchcomp.touchvomodel.vo.esocevento.web.DTOEsocEvento;
import com.touchcomp.touchvomodel.vo.esocloteeventos.web.DTOEsocLoteEventos;
import com.touchcomp.touchvomodel.vo.esocloteeventos.web.DTOInformacoesEventosLote;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.LinkedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocLoteEventosImpl
extends ServiceGenericEntityImpl<EsocLoteEventos, Long, DaoEsocLoteEventosImpl> {
    ServiceEsocPreEventoImpl serviceEsocPreEventoImpl;
    ServiceIdentificacaoAmbienteEsocialImpl serviceIdentificacaoAmbienteEsocialImpl;
    ServiceTipoEventoEsocialImpl serviceTipoEventoEsocialImpl;
    ServiceEsocEventoImpl serviceEsocEventoImpl;
    ServiceEsocialImpl serviceEsocialImpl;
    ServiceEmpresaImpl serviceEmpresaImpl;
    ServiceEmpresaRhImpl serviceEmpresaRhImpl;
    ServiceOpcoesESocialImpl serviceOpcoesESocialImpl;

    @Autowired
    public ServiceEsocLoteEventosImpl(DaoEsocLoteEventosImpl genericDao, ServiceEsocPreEventoImpl serviceEsocPreEventoImpl, ServiceIdentificacaoAmbienteEsocialImpl serviceIdentificacaoAmbienteEsocialImpl, ServiceTipoEventoEsocialImpl serviceTipoEventoEsocialImpl, ServiceEsocEventoImpl serviceEsocEventoImpl, ServiceEsocialImpl serviceEsocialImpl, ServiceEmpresaImpl serviceEmpresaImpl, ServiceEmpresaRhImpl serviceEmpresaRhImpl, ServiceOpcoesESocialImpl serviceOpcoesESocialImpl) {
        super(genericDao);
        this.serviceEsocPreEventoImpl = serviceEsocPreEventoImpl;
        this.serviceIdentificacaoAmbienteEsocialImpl = serviceIdentificacaoAmbienteEsocialImpl;
        this.serviceTipoEventoEsocialImpl = serviceTipoEventoEsocialImpl;
        this.serviceEsocEventoImpl = serviceEsocEventoImpl;
        this.serviceEsocialImpl = serviceEsocialImpl;
        this.serviceEmpresaImpl = serviceEmpresaImpl;
        this.serviceEmpresaRhImpl = serviceEmpresaRhImpl;
        this.serviceOpcoesESocialImpl = serviceOpcoesESocialImpl;
    }

    @Override
    public EsocLoteEventos beforeSaveEntity(EsocLoteEventos vo) {
        vo.getEventos().forEach(i -> i.setEsocLoteEventos(vo));
        return vo;
    }

    public List<TipoEventoEsocial> pesquisarTiposEventosEsocialSetorUsuario(SetorUsuario setorUsuario, String codigo) {
        List<Object> list = new ArrayList();
        list = this.isEquals(codigo, "1") ? ((DaoEsocLoteEventosImpl)this.genericDao).pesquisarTiposEventosEsocialSetorUsuarioProd(setorUsuario) : ((DaoEsocLoteEventosImpl)this.genericDao).pesquisarTiposEventosEsocialSetorUsuarioProdRes(setorUsuario);
        return list;
    }

    public List<DTOEsocEvento> buscarEventosNaoEnviados(CapsEmpresa capsEmpresa, Long idAmbiente, Long idTipoEvento, Short chkPesquisarPrimeiros) throws ExceptionObjNotFound {
        IdentificacaoAmbienteEsocial identificacaoAmbienteEsocial = (IdentificacaoAmbienteEsocial)this.serviceIdentificacaoAmbienteEsocialImpl.getOrThrow(idAmbiente);
        TipoEventoEsocial tipoEventoEsocial = (TipoEventoEsocial)this.serviceTipoEventoEsocialImpl.getOrThrow(idTipoEvento);
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.get(capsEmpresa.get());
        EmpresaRh empresaRh = this.serviceEmpresaRhImpl.getByIdEmpresa(capsEmpresa.get());
        OpcoesESocial opcoesESocial = this.serviceOpcoesESocialImpl.get(empresa);
        List<EsocPreEvento> preEventos = this.serviceEsocPreEventoImpl.findPreEventosNaoVinculados(empresa, tipoEventoEsocial, identificacaoAmbienteEsocial);
        List<EsocEvento> eventosAux = this.serviceEsocEventoImpl.findEventosGeradosNaoEnviados(empresa, tipoEventoEsocial, identificacaoAmbienteEsocial);
        if (!ServiceEsocLoteEventosImpl.isWithData(preEventos) && !ServiceEsocLoteEventosImpl.isWithData(eventosAux)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0588.008"));
        }
        AtomicInteger contador = new AtomicInteger(1);
        List eventos = preEventos.stream().map(i -> {
            EsocEvento evt = new EsocEvento();
            evt.setDataGeracao(new Date());
            evt.setDescricaoStatus(MessagesBaseMentor.getMsg((String)"M.ERP.0588.001", (Object[])new Object[0]));
            evt.setPreEvento(i);
            evt.setNrSeqEvtLote(Integer.valueOf(contador.getAndIncrement()));
            evt.setIdTagEventoEsocial(ToolEsocial.getIdEvento((OpcoesESocial)opcoesESocial, (Date)evt.getDataGeracao(), (Integer)evt.getNrSeqEvtLote()));
            return evt;
        }).collect(Collectors.toList());
        eventosAux.forEach(evento -> {
            if (this.isNotNull(evento.getEsocLoteEventos()).booleanValue() && this.isNotNull(evento.getEsocLoteEventos().getNumeroProtEnvio()).booleanValue() && this.isStrWithData(evento.getEsocLoteEventos().getNumeroProtEnvio()) && this.isEquals(evento.getStatus(), 0)) {
                throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0588.003", new Object[]{evento.getEsocLoteEventos().getIdentificador()}));
            }
            evento.setDataGeracao(new Date());
            evento.setNrSeqEvtLote(Integer.valueOf(contador.getAndIncrement()));
            evento.setIdTagEventoEsocial(ToolEsocial.getIdEvento((OpcoesESocial)opcoesESocial, (Date)evento.getDataGeracao(), (Integer)evento.getNrSeqEvtLote()));
            eventos.add(evento);
        });
        if (this.isNull(empresaRh).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0588.009"));
        }
        if (this.isEquals(chkPesquisarPrimeiros, EnumConstantsMentorSimNao.SIM.getEnumId()) && contador.get() > 49) {
            return this.buildToDTOGeneric(eventos.subList(0, 50), DTOEsocEvento.class);
        }
        return this.buildToDTOGeneric(eventos, DTOEsocEvento.class);
    }

    public List<DTOEntidadeCodigoRes> tipoEvento(Long idAmbiente, Usuario usuario) {
        IdentificacaoAmbienteEsocial identificacaoAmbienteEsocial = (IdentificacaoAmbienteEsocial)this.serviceIdentificacaoAmbienteEsocialImpl.get(idAmbiente);
        ArrayList<DTOEntidadeCodigoRes> dto = new ArrayList<DTOEntidadeCodigoRes>();
        if (this.isNull(identificacaoAmbienteEsocial).booleanValue()) {
            return dto;
        }
        List<TipoEventoEsocial> listaTipoEventoEsocial = this.pesquisarTiposEventosEsocialSetorUsuario(usuario.getSetorUsuario(), identificacaoAmbienteEsocial.getCodigo());
        if (!ServiceEsocLoteEventosImpl.isWithData(listaTipoEventoEsocial)) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0588.012"));
        }
        this.ordernarCodigo(listaTipoEventoEsocial);
        return this.buildToDTOGeneric(listaTipoEventoEsocial, DTOEntidadeCodigoRes.class);
    }

    private void ordernarCodigo(List<TipoEventoEsocial> eventos) {
        eventos.sort(new Comparator<TipoEventoEsocial>(this){

            @Override
            public int compare(TipoEventoEsocial o1, TipoEventoEsocial o2) {
                return o1.getCodigo().compareTo(o2.getCodigo());
            }
        });
    }

    public CompletableFuture<File> gerarXml(OpcoesESocial opcoesESocial, Long idLote) throws ExceptionObjNotFound, ExceptionInvalidXML, ExceptionEsocial, ExceptionJaxb, ExceptionIO, ExceptionJDom, ExceptionInvalidData {
        EsocLoteEventos esocLoteEventos = (EsocLoteEventos)this.getOrThrow(idLote);
        ArrayList<Map> maps = new ArrayList<Map>();
        for (EsocEvento esoc : esocLoteEventos.getEventos()) {
            LinkedMap m = new LinkedMap();
            m.put("XML", this.serviceEsocialImpl.salvarXml(esoc, opcoesESocial));
            m.put("ID_ESOC", esoc.getIdentificador());
            maps.add((Map)m);
        }
        File result = this.getXMLsZipFile(maps);
        return CompletableFuture.completedFuture(result);
    }

    private File getXMLsZipFile(List<Map> map) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File zip = new File(tmpDir.getAbsolutePath() + File.separator + "arquivo_xml_documentos.zip");
        ToolZipUtils.compress((File)zip, this.getXMLsFile(map));
        return zip;
    }

    public List<File> getXMLsFile(List<Map> map) throws ExceptionIO, ExceptionInvalidData {
        LinkedList<File> files = new LinkedList<File>();
        LinkedList<String> aux = new LinkedList<String>();
        for (Map m : map) {
            if (aux.contains(m.get("XML"))) continue;
            files.add(this.getXMLFile((String)m.get("XML"), (Long)m.get("ID_ESOC")));
            aux.add((String)m.get("XML"));
        }
        return files;
    }

    public File getXMLFile(String xml, Long idEsoc) throws ExceptionIO, ExceptionInvalidData {
        return this.getXMLFile(xml, idEsoc, false);
    }

    public File getXMLFile(String xml, Long idEsoc, boolean removeInvalidUTF) throws ExceptionIO, ExceptionInvalidData {
        File tmpDir = ToolFile.getFileTMPDir();
        File temp = new File(tmpDir.getAbsolutePath() + File.separator + idEsoc + ".xml");
        if (removeInvalidUTF) {
            xml = ToolString.removeIllegalXMLChar((String)xml);
        }
        if (xml != null && !((String)xml).startsWith("<?xml version=")) {
            xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + (String)xml;
        }
        ToolFile.writeStringInFile((File)temp, (String)xml);
        return temp;
    }

    public WebDTOResult<DTOEsocLoteEventos> consultarLoteEsocial(Long idLote, OpcoesESocial opcoesESocial, ConfiguracaoCertificado configuracaoCertificado) throws ExceptionObjNotFound, ExceptionEsocial, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        WebDTOResult w = new WebDTOResult();
        if (this.isNull(opcoesESocial).booleanValue()) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0588.005"));
        }
        EsocLoteEventos esocLoteEventos = this.serviceEsocialImpl.consultaLoteEventosEsocial((EsocLoteEventos)this.getOrThrow(idLote), opcoesESocial, configuracaoCertificado);
        boolean existDescricaoStatusDetalhada = false;
        for (EsocEvento esocEvento : esocLoteEventos.getEventos()) {
            if (!this.isStrWithData(esocEvento.getDescricaoStatusDetalhada())) continue;
            existDescricaoStatusDetalhada = true;
        }
        if (existDescricaoStatusDetalhada) {
            w.setMessage(MessagesBaseMentor.getMsg((String)"E.ERP.0588.006", (Object[])new Object[]{ToolString.substituiCaractereEspecial((String)esocLoteEventos.getDescricaoEnvio().replace('\n', ' '))}));
        } else {
            w.setMessage(MessagesBaseMentor.getMsg((String)"E.ERP.0588.007", (Object[])new Object[]{ToolString.substituiCaractereEspecial((String)esocLoteEventos.getDescricaoEnvio().replace('\n', ' '))}));
        }
        return w.setResult((Object)this.buildToDTOGeneric(esocLoteEventos, DTOEsocLoteEventos.class));
    }

    public DTOInformacoesEventosLote atualizarInformacoesEventos(Long idLote) throws ExceptionObjNotFound {
        EsocLoteEventos esocLoteEventos = (EsocLoteEventos)this.getOrThrow(idLote);
        Integer enviados = (int)esocLoteEventos.getEventos().stream().filter(i -> this.isNotNull(i.getStatus()) != false && this.isEquals(i.getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getValue())).count();
        Integer enviadosAdvertencia = (int)esocLoteEventos.getEventos().stream().filter(i -> this.isNotNull(i.getStatus()) != false && this.isEquals(i.getStatus(), EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())).count();
        Integer rejeitados = (int)esocLoteEventos.getEventos().stream().filter(i -> this.isNotNull(i.getStatus()) != false && !this.isEquals(i.getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !this.isEquals(i.getStatus(), EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())).count();
        DTOInformacoesEventosLote dto = new DTOInformacoesEventosLote();
        dto.setTotalEventos(Integer.valueOf(esocLoteEventos.getEventos().size()));
        dto.setEnviados(enviados);
        dto.setEnviadosAdvertencia(enviadosAdvertencia);
        dto.setRejeitados(rejeitados);
        return dto;
    }

    public CompletableFuture<File> gerarXmlBeforeSave(CapsEmpresa capsEmpresa, DTOEsocLoteEventos input) throws ExceptionObjNotFound, ExceptionInvalidXML, ExceptionEsocial, ExceptionJaxb, ExceptionIO, ExceptionJDom, ExceptionInvalidData {
        Empresa empresa = (Empresa)this.serviceEmpresaImpl.get(capsEmpresa.get());
        OpcoesESocial opcoesESocial = this.serviceOpcoesESocialImpl.get(empresa);
        EsocLoteEventos esocLoteEventos = (EsocLoteEventos)this.buildToEntity(input);
        esocLoteEventos.getEventos().forEach(i -> {
            i.setEsocLoteEventos(esocLoteEventos);
            i.getPreEvento().setEsocEvento(i);
        });
        ArrayList<Map> maps = new ArrayList<Map>();
        for (EsocEvento esoc : esocLoteEventos.getEventos()) {
            LinkedMap m = new LinkedMap();
            m.put("XML", this.serviceEsocialImpl.salvarXml(esoc, opcoesESocial));
            m.put("ID_ESOC", esoc.getIdentificador());
            maps.add((Map)m);
        }
        File result = this.getXMLsZipFile(maps);
        return CompletableFuture.completedFuture(result);
    }
}

