/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocmonitoramentosaude;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocMonitoramentoSaude;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.dao.impl.DaoEsocMonitoramentoSaudeImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocMonitoramentoSaudeImpl
extends ServiceGenericEntityImpl<EsocMonitoramentoSaude, Long, DaoEsocMonitoramentoSaudeImpl> {
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private HelperEsocPreEvento helper;

    @Autowired
    public ServiceEsocMonitoramentoSaudeImpl(DaoEsocMonitoramentoSaudeImpl dao) {
        super(dao);
    }

    @Override
    public EsocMonitoramentoSaude beforeSave(EsocMonitoramentoSaude vo) {
        if (!TMethods.isNull((Object)vo.getEsocMonSaudeDadosExame()).booleanValue()) {
            vo.getEsocMonSaudeDadosExame().forEach(i -> i.setEsocMonitoramentoSaude(vo));
        }
        if (!TMethods.isNull((Object)vo.getPreEventosEsocial()).booleanValue()) {
            vo.getPreEventosEsocial().forEach(i -> i.setMonitoramento(vo));
        }
        if (!this.isNull(vo.getIdentificador()).booleanValue()) {
            vo.setPreEventosEsocial(this.serviceEsocPreEvento.getEventosMonitoramentoSaude(vo));
        }
        return vo;
    }

    public void buildEsocEventos(EsocMonitoramentoSaude vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (!ServiceEsocMonitoramentoSaudeImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            if (ServiceEsocMonitoramentoSaudeImpl.isWithData(vo.getPreEventosEsocial())) {
                this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
            }
        }
    }
}

