/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocpreevento;

import com.touchcomp.basementor.capsules.impl.CapsEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsGrEmpresa;
import com.touchcomp.basementor.capsules.impl.CapsUsuario;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.centraleventos.EnumConstTipoBuscaInss;
import com.touchcomp.basementor.constants.enums.esocial.centraleventos.EnumConstTipoBuscaIrrf;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocComunicadoAcidTrab;
import com.touchcomp.basementor.model.vo.EsocCondicoesAmbientaisTrabalho;
import com.touchcomp.basementor.model.vo.EsocExameToxicologico;
import com.touchcomp.basementor.model.vo.EsocMonitoramentoSaude;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.EsocReaberturaEventos;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.EsocValoresInssColaborador;
import com.touchcomp.basementor.model.vo.EsocValoresIrrfColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IdentificacaoAmbienteEsocial;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorservice.dao.impl.DaoEsocPreEventoImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.esocevento.ServiceEsocEventoImpl;
import com.touchcomp.basementorservice.service.impl.esocvalores5011.ServiceEsocValores5011Impl;
import com.touchcomp.basementorservice.service.impl.esocvaloresinsscolaborador.ServiceEsocValoresInssColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.esocvaloresirrfcolaborador.ServiceEsocValoresIrrfColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.recisao.ServiceRecisaoImpl;
import com.touchcomp.basementorservice.service.impl.tipoeventoesocial.ServiceTipoEventoEsocialImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceEsocPreEvento;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.esocpreevento.web.DTOEsocPreEvento;
import com.touchcomp.touchvomodel.vo.esocpreevento.web.DTOEsocPreEventoEnviado;
import com.touchcomp.touchvomodel.vo.esocpreevento.web.DTOEsocPreEventoNaoEnviado;
import com.touchcomp.touchvomodel.vo.esocvalores5011.DTOTotalizadorInss;
import com.touchcomp.touchvomodel.vo.esocvaloresinsscolaborador.DTOValoresInss;
import com.touchcomp.touchvomodel.vo.esocvaloresirrfcolaborador.DTOValoresIrrf;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocPreEventoImpl
extends ServiceGenericEntityImpl<EsocPreEvento, Long, DaoEsocPreEventoImpl>
implements ServiceEsocPreEvento {
    HelperEsocPreEvento helperEsocPreEvento;
    ServiceTipoEventoEsocialImpl serviceTipoEventoESocial;
    ServiceColaboradorImpl serviceColaborador;
    ServiceRecisaoImpl serviceRecisao;
    ServiceEsocValoresInssColaboradorImpl serviceEsocValoresInssColaborador;
    ServiceEsocValoresIrrfColaboradorImpl serviceEsocValoresIrrfColaborador;
    ServiceEsocValores5011Impl serviceEsocValores5011;
    ServiceEsocEventoImpl serviceEsocEvento;
    ServiceGrupoEmpresaImpl serviceGrupoEmpresa;
    ServiceUsuarioImpl serviceUsuario;
    ServiceEmpresaImpl serviceEmpresa;

    @Autowired
    public ServiceEsocPreEventoImpl(DaoEsocPreEventoImpl genericDao, HelperEsocPreEvento helperEsocPreEvento, ServiceTipoEventoEsocialImpl serviceTipoEventoESocial, ServiceColaboradorImpl serviceColaborador, ServiceRecisaoImpl serviceRecisao, ServiceEsocValoresInssColaboradorImpl serviceEsocValoresInssColaborador, ServiceEsocValoresIrrfColaboradorImpl serviceEsocValoresIrrfColaborador, ServiceEsocValores5011Impl serviceEsocValores5011, ServiceEsocEventoImpl serviceEsocEvento, ServiceGrupoEmpresaImpl serviceGrupoEmpresa, ServiceUsuarioImpl serviceUsuario, ServiceEmpresaImpl serviceEmpresa) {
        super(genericDao);
        this.helperEsocPreEvento = helperEsocPreEvento;
        this.serviceTipoEventoESocial = serviceTipoEventoESocial;
        this.serviceColaborador = serviceColaborador;
        this.serviceRecisao = serviceRecisao;
        this.serviceEsocValoresInssColaborador = serviceEsocValoresInssColaborador;
        this.serviceEsocValoresIrrfColaborador = serviceEsocValoresIrrfColaborador;
        this.serviceEsocValores5011 = serviceEsocValores5011;
        this.serviceEsocEvento = serviceEsocEvento;
        this.serviceGrupoEmpresa = serviceGrupoEmpresa;
        this.serviceUsuario = serviceUsuario;
        this.serviceEmpresa = serviceEmpresa;
    }

    @Override
    public List<EsocPreEvento> findPreEventosNaoVinculados(Empresa empresa, TipoEventoEsocial tp, IdentificacaoAmbienteEsocial ambiente) {
        List<EsocPreEvento> preEventos = ((DaoEsocPreEventoImpl)this.getGenericDao()).findEventosNaoGerados(empresa, tp, ambiente);
        return preEventos;
    }

    @Override
    public void geracaoEventoS2210(EsocComunicadoAcidTrab vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        this.saveOrUpdate(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
        this.saveOrUpdate(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
    }

    @Override
    public void geracaoEventoS2500(EsocProcessoTrabalhista vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        this.saveOrUpdate(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
        this.saveOrUpdate(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
    }

    @Override
    public void apagarEvento(EsocPreEvento evento) throws ExceptionEsocial {
        if (evento.getEsocEvento() != null && (TMethods.isEquals((Object)evento.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getValue()) || TMethods.isEquals((Object)evento.getEsocEvento().getStatus(), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue()))) {
            throw new ExceptionEsocial("E.ERP.1743.002");
        }
        if (evento.getEventoPosterior() != null) {
            throw new ExceptionEsocial("E.ERP.1743.003");
        }
        ((DaoEsocPreEventoImpl)this.getGenericDao()).atualizarEventoPosterior(evento);
        this.delete(evento);
    }

    public void apagarEvento(Long evento) throws ExceptionEsocial {
        EsocPreEvento vo = (EsocPreEvento)this.get(evento);
        if (vo == null) {
            throw new ExceptionEsocial("E.ERP.1743.004");
        }
        this.apagarEvento(vo);
    }

    public List<EsocPreEvento> getEventosProcessoTrabalhista(EsocProcessoTrabalhista proc) {
        if (proc != null) {
            return ((DaoEsocPreEventoImpl)this.getGenericDao()).getEventosProcessoTrabalhista(proc);
        }
        return new ArrayList<EsocPreEvento>();
    }

    public List<EsocPreEvento> getEventosCondicoesAmbTrabalho(EsocCondicoesAmbientaisTrabalho vo) {
        if (vo != null) {
            return ((DaoEsocPreEventoImpl)this.getGenericDao()).getEventosCondicoesAmbTrabalho(vo);
        }
        return new ArrayList<EsocPreEvento>();
    }

    public List<EsocPreEvento> getEventosMonitoramentoSaude(EsocMonitoramentoSaude vo) {
        if (vo != null && vo.getIdentificador() != null) {
            return ((DaoEsocPreEventoImpl)this.getGenericDao()).getEventosMonitoramentoSaude(vo);
        }
        return new ArrayList<EsocPreEvento>();
    }

    public List<EsocPreEvento> getEventosReaberturaEvt(EsocReaberturaEventos vo) {
        if (vo != null && vo.getIdentificador() != null) {
            return ((DaoEsocPreEventoImpl)this.getGenericDao()).getEventosReaberturaEvt(vo);
        }
        return new ArrayList<EsocPreEvento>();
    }

    public List<EsocPreEvento> getEventosTabelaProcessos(TabelaProcessosEsoc vo) {
        if (vo != null) {
            return ((DaoEsocPreEventoImpl)this.getGenericDao()).getEventosTabelaProcessos(vo);
        }
        return new ArrayList<EsocPreEvento>();
    }

    public List<EsocPreEvento> getEventosExameToxicologico(EsocExameToxicologico vo) {
        if (this.isNotNull(vo).booleanValue()) {
            return ((DaoEsocPreEventoImpl)this.getGenericDao()).getEventosExameToxicologico(vo);
        }
        return new ArrayList<EsocPreEvento>();
    }

    public List<EsocPreEvento> findEventosNaoEnviados(GrupoEmpresa grupo, TipoEventoEsocial tipoEventoEsocial) {
        return ((DaoEsocPreEventoImpl)this.getDao()).findEventosNaoEnviados(grupo, tipoEventoEsocial);
    }

    public List<DTOEsocPreEventoNaoEnviado> findEventosNaoEnviados(OpcoesESocial opcoes, CapsGrEmpresa capsGrupo, CapsUsuario capsUsuario, Long tipoEventoEsocial) throws ExceptionObjNotFound {
        GrupoEmpresa grupo = (GrupoEmpresa)this.serviceGrupoEmpresa.getOrThrow(capsGrupo.get());
        Usuario usuario = (Usuario)this.serviceUsuario.getOrThrow(capsUsuario.get());
        List<EsocPreEvento> eventosNaoEnviados = ((DaoEsocPreEventoImpl)this.getDao()).findEventosNaoEnviados(grupo, (TipoEventoEsocial)this.serviceTipoEventoESocial.get(tipoEventoEsocial));
        List<Colaborador> colaboradoresSemEvts = this.serviceColaborador.findColaboradoresSemEventosESocial(opcoes, grupo);
        List<Recisao> recisoesSemEvts = this.serviceRecisao.findRecisoesSemEventosESocial(opcoes, grupo);
        LinkedList<DTOEsocPreEventoNaoEnviado> ret = new LinkedList<DTOEsocPreEventoNaoEnviado>();
        ret.addAll(this.helperEsocPreEvento.buildToDTOEsocPreEventoNaoEnviado(eventosNaoEnviados));
        ret.addAll(this.helperEsocPreEvento.buildToDTOColaboradorSemEventos(colaboradoresSemEvts, usuario));
        ret.addAll(this.helperEsocPreEvento.buildToDTORecisoesSemEventos(recisoesSemEvts, usuario));
        return ret;
    }

    public List<DTOEsocPreEventoEnviado> findEventosEnviados(CapsEmpresa capsEmpresa, Date periodo) throws ExceptionObjNotFound {
        Empresa empresa = (Empresa)this.serviceEmpresa.getOrThrow(capsEmpresa.get());
        List<Object[]> eventosEnviados = this.serviceEsocEvento.findEventosEnviados(empresa, periodo);
        return this.helperEsocPreEvento.buildToDTOEventosEnviados(eventosEnviados);
    }

    public List<DTOValoresInss> findValoresS5001(CapsGrEmpresa capsGrupo, Date periodo, EnumConstTipoBuscaInss tipo) throws ExceptionObjNotFound {
        GrupoEmpresa grupo = (GrupoEmpresa)this.serviceGrupoEmpresa.getOrThrow(capsGrupo.get());
        List<EsocValoresInssColaborador> valoresInss = this.serviceEsocValoresInssColaborador.findValores(grupo, periodo);
        return this.helperEsocPreEvento.buildToDTOValoresInss(valoresInss, tipo);
    }

    public List<DTOValoresIrrf> findValoresS5002(CapsGrEmpresa capsGrupo, Date periodo, EnumConstTipoBuscaIrrf tipo) throws ExceptionObjNotFound {
        GrupoEmpresa grupo = (GrupoEmpresa)this.serviceGrupoEmpresa.getOrThrow(capsGrupo.get());
        List<EsocValoresIrrfColaborador> valoresIrrf = this.serviceEsocValoresIrrfColaborador.findValores(grupo, periodo, tipo);
        return this.helperEsocPreEvento.buildToDTOValoresIrrf(valoresIrrf);
    }

    public List<DTOTotalizadorInss> findValoresS5011(CapsGrEmpresa capsGrupo, Date periodo) throws ExceptionObjNotFound {
        GrupoEmpresa grupo = (GrupoEmpresa)this.serviceGrupoEmpresa.getOrThrow(capsGrupo.get());
        List<EsocValores5011> valores = this.serviceEsocValores5011.findValores(grupo, periodo);
        return this.helperEsocPreEvento.buildToDTOTotalizadorInss(valores);
    }

    public List<DTOEsocPreEvento> carregarMovimentacoesByColaborador(Long idColaborador) throws ExceptionObjNotFound {
        List<EsocPreEvento> listEsocPreEvento = ((DaoEsocPreEventoImpl)this.getDao()).getMovimentacaoTrabalhista(idColaborador);
        return this.buildToDTOGeneric(listEsocPreEvento, DTOEsocPreEvento.class);
    }
}

