/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.esocreaberturaeventos;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocReaberturaEventos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorservice.dao.impl.DaoEsocReaberturaEventosImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEsocReaberturaEventosImpl
extends ServiceGenericEntityImpl<EsocReaberturaEventos, Long, DaoEsocReaberturaEventosImpl> {
    @Autowired
    private ServiceEsocPreEventoImpl serviceEsocPreEvento;
    @Autowired
    private HelperEsocPreEvento helper;

    @Autowired
    public ServiceEsocReaberturaEventosImpl(DaoEsocReaberturaEventosImpl dao) {
        super(dao);
    }

    @Override
    public EsocReaberturaEventos beforeSave(EsocReaberturaEventos vo) {
        if (!this.isNull(vo.getIdentificador()).booleanValue()) {
            vo.setPreEventosEsocial(this.serviceEsocPreEvento.getEventosReaberturaEvt(vo));
        }
        return vo;
    }

    public void buildEsocEventos(EsocReaberturaEventos vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (!ServiceEsocReaberturaEventosImpl.isWithData(vo.getPreEventosEsocial())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helper.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            if (ServiceEsocReaberturaEventosImpl.isWithData(vo.getPreEventosEsocial())) {
                this.serviceEsocPreEvento.saveOrUpdate(vo.getPreEventosEsocial());
            }
        }
    }
}

