/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.estatisticasfinanccomercpessoa;

import com.touchcomp.basementor.constants.enums.cliente.EnumConstTipoAnaliseCreditoCliente;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstAnaliseFinPessoa;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.model.impl.DadosEstatisticosFaturamento;
import com.touchcomp.basementor.model.impl.EstatisticasPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.components.analisecredito.CompAnaliseCreditoCliente;
import com.touchcomp.basementorservice.components.analisecredito.CompAnaliseCreditoGrupoPessoas;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapResumoInfoPessoa;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.tomadorprestadorrps.ServiceTomadorPrestadorRpsImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceChequeTerceiros;
import com.touchcomp.basementorservice.service.interfaces.ServiceCliente;
import com.touchcomp.basementorservice.service.interfaces.ServiceEstatisticiasFinancComercPessoa;
import com.touchcomp.basementorservice.service.interfaces.ServicePessoa;
import com.touchcomp.basementorservice.service.interfaces.ServiceRps;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoTitulos;
import com.touchcomp.basementorservice.service.interfaces.ServiceTitulo;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.estatisticascliente.mobile.DTOMobileEstatisticasPessoa;
import com.touchcomp.touchvomodel.vo.estatisticascliente.nfce.DTONFCeEstatisticasPessoa;
import com.touchcomp.touchvomodel.web.WebDTOResult;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEstatisticasFinancComercPessoaImpl
extends ServiceGenericImpl
implements ServiceEstatisticiasFinancComercPessoa {
    @Autowired
    private ServicePessoa servicePessoa;
    @Autowired
    private ServiceTitulo serviceTitulo;
    @Autowired
    private ServiceSaldoTitulos serviceSaldoTitulo;
    @Autowired
    private ServiceChequeTerceiros serviceChequeTerceiros;
    @Autowired
    private ServiceCliente serviceCliente;
    @Autowired
    private ServiceTomadorPrestadorRpsImpl serviceTomadorPrestadorRps;
    @Autowired
    private ServiceRps serviceRps;
    @Autowired
    private ServicePedidoImpl servicePedido;

    @Override
    public EstatisticasPessoa findEstatisticasPessoa(Long idPessoa, OpcoesFinanceiras op) {
        return this.findEstatisticasPessoaInternal(idPessoa, new Date(), op);
    }

    @Override
    public EstatisticasPessoa findEstatisticasPessoa(Long idPessoa, Date dataConsulta, OpcoesFinanceiras op) {
        return this.findEstatisticasPessoaInternal(idPessoa, dataConsulta, op);
    }

    @Override
    public EstatisticasPessoa findEstatisticasPessoa(Pessoa pessoa, OpcoesFinanceiras op) {
        return this.findEstatisticasPessoaInternal(pessoa.getIdentificador(), new Date(), op);
    }

    @Override
    public EstatisticasPessoa findEstatisticasPessoa(Pessoa pessoa, Date dataConsulta, OpcoesFinanceiras op) {
        return this.findEstatisticasPessoaInternal(pessoa.getIdentificador(), dataConsulta, op);
    }

    public DTOMobileEstatisticasPessoa findEstatisticasPessoaMobile(Long idPessoa, Date dataConsulta, OpcoesFinanceiras op) {
        GenericMapValues<GenMapResumoInfoPessoa> pes = this.servicePessoa.getEstatisticasFinanceiras(idPessoa);
        int diasTolerancia = this.getDiasTolerancia(op, pes);
        DTOMobileEstatisticasPessoa e = new DTOMobileEstatisticasPessoa();
        e.setSaldoTitulosVencidosAbertos(this.findSaldoTitulosVencidosEmAberto(idPessoa, dataConsulta, 0));
        e.setSaldoTitulosVencidosAbertosCarencia(this.findSaldoTitulosVencidosEmAberto(idPessoa, dataConsulta, diasTolerancia));
        e.setSaldoTitulosAbertos(this.findSaldoTitulosAbertos(idPessoa, dataConsulta));
        e.setNumTitulosProtestados(this.serviceTitulo.findNumTitulosProtestados(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setNumTitulosCartorio(this.serviceTitulo.findNumTitulosCartorio(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setValorChequesNaoCompensados(this.serviceChequeTerceiros.valorChequesNaoCompensados(idPessoa));
        e.setValorChequesDevolvidos(this.serviceChequeTerceiros.valorChequesDevolvidos(idPessoa));
        e.setSaldoDevedor(e.getSaldoTitulosAbertos());
        if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirChequeAnCred())) {
            e.setSaldoDevedor(Double.valueOf(e.getSaldoDevedor() + e.getValorChequesDevolvidos() + e.getValorChequesNaoCompensados()));
        }
        if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirPedAbertoAnCred())) {
            e.setValorPedidosAbertos(Double.valueOf(this.servicePedido.getValorPedidosAberto(idPessoa)));
            e.setSaldoDevedor(Double.valueOf(e.getSaldoDevedor() + e.getValorPedidosAbertos()));
        }
        if (pes != null) {
            e.setValorLimiteCreditoFinanceiro(pes.getDouble(GenMapResumoInfoPessoa.LIMITE_CREDITO_FINANCEIRO));
            e.setValorLimiteCredito(pes.getDouble(GenMapResumoInfoPessoa.LIMITE_CREDITO_PEDIDO));
        }
        e.setValorLimiteDisponivelFinanceiro(Double.valueOf(e.getValorLimiteCreditoFinanceiro() - e.getSaldoDevedor()));
        e.setValorLimiteDisponivel(Double.valueOf(e.getValorLimiteCredito() - e.getSaldoDevedor()));
        List<DTOMobileEstatisticasPessoa.ItemRestricao> restricoes = this.avaliaRest(pes, e);
        e.setRestricoes(restricoes);
        return e;
    }

    public DTONFCeEstatisticasPessoa findEstatisticasPessoaNFCe(Long idPessoa, Date dataConsulta, OpcoesFinanceiras op) {
        GenericMapValues<GenMapResumoInfoPessoa> pes = this.servicePessoa.getEstatisticasFinanceiras(idPessoa);
        int diasTolerancia = this.getDiasTolerancia(op, pes);
        DTONFCeEstatisticasPessoa e = new DTONFCeEstatisticasPessoa();
        e.setSaldoTitulosVencidosAbertos(this.findSaldoTitulosVencidosEmAberto(idPessoa, dataConsulta, 0));
        e.setSaldoTitulosVencidosAbertosCarencia(this.findSaldoTitulosVencidosEmAberto(idPessoa, dataConsulta, diasTolerancia));
        e.setSaldoTitulosAbertos(this.findSaldoTitulosAbertos(idPessoa, dataConsulta));
        e.setNumTitulosProtestados(this.serviceTitulo.findNumTitulosProtestados(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setNumTitulosCartorio(this.serviceTitulo.findNumTitulosCartorio(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setValorChequesNaoCompensados(this.serviceChequeTerceiros.valorChequesNaoCompensados(idPessoa));
        e.setValorChequesDevolvidos(this.serviceChequeTerceiros.valorChequesDevolvidos(idPessoa));
        e.setSaldoDevedor(e.getSaldoTitulosAbertos());
        if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirChequeAnCred())) {
            e.setSaldoDevedor(Double.valueOf(e.getSaldoDevedor() + e.getValorChequesDevolvidos() + e.getValorChequesNaoCompensados()));
        }
        if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirPedAbertoAnCred())) {
            e.setValorPedidosAbertos(Double.valueOf(this.servicePedido.getValorPedidosAberto(idPessoa)));
            e.setSaldoDevedor(Double.valueOf(e.getSaldoDevedor() + e.getValorPedidosAbertos()));
        }
        return e;
    }

    private EstatisticasPessoa findEstatisticasPessoaInternal(Long idPessoa, Date dataConsulta, OpcoesFinanceiras op) {
        EstatisticasPessoa e = new EstatisticasPessoa((Pessoa)this.servicePessoa.get(idPessoa));
        GenericMapValues<GenMapResumoInfoPessoa> pes = this.servicePessoa.getEstatisticasFinanceiras(idPessoa);
        int diasTolerancia = this.getDiasTolerancia(op, pes);
        e.setSaldoTitulosVencidosAbertos(this.findSaldoTitulosVencidosEmAberto(e.getPessoa().getIdentificador(), dataConsulta, 0));
        e.setSaldoTitulosVencidosAbertosCarencia(this.findSaldoTitulosVencidosEmAberto(e.getPessoa().getIdentificador(), dataConsulta, diasTolerancia));
        e.setSaldoTitulosAVencer(this.findSaldoTitulosAVencer(e.getPessoa(), dataConsulta));
        e.setSaldoTitulosAbertos(this.findSaldoTitulosAbertos(e.getPessoa(), dataConsulta));
        e.setValorTotalTitulos(this.serviceTitulo.findValorTotalTitulos(e.getPessoa(), EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setNumTitulosProtestados(this.serviceTitulo.findNumTitulosProtestados(e.getPessoa(), EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setNumTitulosCartorio(this.serviceTitulo.findNumTitulosCartorio(e.getPessoa(), EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setMaiorAtraso(this.serviceTitulo.findMaiorAtrasoTitulo(e.getPessoa(), EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setAtrasoMedio(this.serviceTitulo.findAtrasoMedioTitulos(e.getPessoa(), EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setPorcentagem(this.serviceTitulo.findPercentualAtrasoTitulos(e.getPessoa(), EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setValorChequesNaoCompensados(this.serviceChequeTerceiros.valorChequesNaoCompensados(idPessoa));
        e.setValorChequesDevolvidos(this.serviceChequeTerceiros.valorChequesDevolvidos(idPessoa));
        e.setSaldoAntecipadoPagar(this.serviceTitulo.findSaldoTitulosAntecipado(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_PAG));
        e.setSaldoAntecipadoReceber(this.serviceTitulo.findSaldoTitulosAntecipado(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setValorTotalTitulosAntecPag(this.serviceTitulo.findValorTotalTitulosAntecipados(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setValorTotalTitulosAntecRec(this.serviceTitulo.findValorTotalTitulosAntecipados(idPessoa, EnumConstTituloPagRec.TIPO_TITULO_REC));
        e.setSaldoDevedor(this.getSaldoDevedor(e, op));
        this.setOnMapCliente(e);
        this.setOnMapTomador(e);
        return e;
    }

    private int getDiasTolerancia(OpcoesFinanceiras op, GenericMapValues<GenMapResumoInfoPessoa> pes) {
        int diasTolerancia = 0;
        if (pes != null && pes.getInteger(GenMapResumoInfoPessoa.DIAS_TOLERANCIA_SALDO_VENC) != null) {
            diasTolerancia = pes.getInteger(GenMapResumoInfoPessoa.DIAS_TOLERANCIA_SALDO_VENC);
        } else if (op != null) {
            diasTolerancia = op.getDiasToleranciaAnaliseCredito();
        }
        return diasTolerancia;
    }

    private void setOnMapCliente(EstatisticasPessoa e) {
        Cliente cliente = this.serviceCliente.findClienteByPessoa(e.getPessoa());
        if (cliente == null) {
            return;
        }
        e.setCliente(cliente);
        e.setDataLiberacao(e.getCliente().getFinanceiro().getDataLiberacaoCredito());
        e.setDiasVigorLimite(e.getCliente().getFinanceiro().getDiasVigorLimiteCred());
        e.setValorLimiteCredito(e.getCliente().getFinanceiro().getLimiteCredito());
        e.setValorLimiteCreditoFinanceiro(e.getCliente().getFinanceiro().getLimiteCreditoFinanceiro());
        if (e.getDataLiberacao() != null && e.getDiasVigorLimite() != null) {
            e.setDataValidadeLimite(ToolDate.nextDays((Date)e.getDataLiberacao(), (int)e.getDiasVigorLimite()));
        }
        DadosEstatisticosFaturamento ultimaFatura = this.serviceCliente.getUltimoFaturamentoNf(cliente);
        DadosEstatisticosFaturamento maiorFatura = this.serviceCliente.getMaiorFaturamentoNf(cliente);
        DadosEstatisticosFaturamento primeiraFatura = this.serviceCliente.getPrimeiroFaturamentoNf(cliente);
        e.setUltimaFatura(ultimaFatura);
        e.setMaiorFatura(maiorFatura);
        e.setPrimeiraFatura(primeiraFatura);
        e.setValorMedioPedido(this.servicePedido.getValorMedioPedidos(cliente));
        e.setValorPedidosAbertos(this.servicePedido.getValorPedidoAberto(cliente));
        Double limiteDisponiveL = e.getValorLimiteCredito() - e.getValorPedidosAbertos() - e.getValorChequesNaoCompensados() - e.getSaldoDevedor() - e.getValorChequesDevolvidos();
        e.setValorLimiteDisponivel(limiteDisponiveL);
        Double limiteDisponivelFinanceiro = e.getSaldoTitulosVencidosAbertos() + e.getSaldoTitulosAVencer() - e.getValorLimiteCreditoFinanceiro();
        e.setValorLimiteDisponivelFinanceiro(limiteDisponivelFinanceiro);
    }

    private void setOnMapTomador(EstatisticasPessoa e) {
        TomadorPrestadorRps toma = this.serviceTomadorPrestadorRps.findClienteByPessoa(e.getPessoa());
        if (toma == null) {
            return;
        }
        e.setTomadorPrestadorRPS(toma);
        DadosEstatisticosFaturamento ultimaFatura = this.serviceRps.getMaiorFaturamentoRps(toma);
        DadosEstatisticosFaturamento maiorFatura = this.serviceRps.getUltimoFaturamentoRps(toma);
        DadosEstatisticosFaturamento primeiraFatura = this.serviceRps.getPrimeiroFaturamentoRps(toma);
        e.setMaiorFatura(maiorFatura);
        e.setUltimaFatura(ultimaFatura);
        e.setPrimeiraFatura(primeiraFatura);
    }

    private Double findSaldoTitulosVencidosEmAberto(Long idPessoa, Date dataConsulta, int diasTolerancia) {
        return this.serviceSaldoTitulo.getSaldoVencidoPessoa(idPessoa, diasTolerancia, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA, dataConsulta);
    }

    private Double findSaldoTitulosAVencer(Pessoa pessoa, Date dataConsulta) {
        return this.serviceSaldoTitulo.getSaldoTitulosAVencer(pessoa.getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA, dataConsulta);
    }

    private Double findSaldoTitulosAVencer(Long idPessoa, Date dataConsulta) {
        return this.serviceSaldoTitulo.getSaldoTitulosAVencer(idPessoa, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA, dataConsulta);
    }

    private Double findSaldoTitulosAbertos(Pessoa pessoa, Date dataConsulta) {
        return this.findSaldoTitulosAbertos(pessoa.getIdentificador(), dataConsulta);
    }

    private Double findSaldoTitulosAbertos(Long idPessoa, Date dataConsulta) {
        return this.serviceSaldoTitulo.getSaldoDevedorPessoa(idPessoa, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA, dataConsulta);
    }

    private Double getSaldoDevedor(EstatisticasPessoa e, OpcoesFinanceiras op) {
        Double valor = e.getSaldoDevedor();
        if (op != null && ToolMethods.isAffirmative((Number)op.getIncluirChequeAnCred())) {
            valor = valor + (e.getValorChequesDevolvidos() + e.getValorChequesNaoCompensados());
        }
        return valor;
    }

    private List<DTOMobileEstatisticasPessoa.ItemRestricao> avaliaRest(GenericMapValues<GenMapResumoInfoPessoa> dadosPes, DTOMobileEstatisticasPessoa det) {
        Date next;
        LinkedList<DTOMobileEstatisticasPessoa.ItemRestricao> res = new LinkedList<DTOMobileEstatisticasPessoa.ItemRestricao>();
        if (dadosPes == null) {
            return res;
        }
        Date dataLiberacaoLimite = dadosPes.getDate(GenMapResumoInfoPessoa.DATA_LIBERACAO_LIMITE);
        Integer diasLiberacaoLimite = dadosPes.getInteger(GenMapResumoInfoPessoa.DIAS_LIBERACAO_LIMITE);
        Double limiteCreditoPedido = dadosPes.getDouble(GenMapResumoInfoPessoa.LIMITE_CREDITO_PEDIDO);
        Double limiteCreditoFinanceiro = dadosPes.getDouble(GenMapResumoInfoPessoa.LIMITE_CREDITO_FINANCEIRO);
        Integer habilitarCompras = dadosPes.getInteger(GenMapResumoInfoPessoa.HABILITAR_COMPRAS);
        Short naoAvaliarFinanceiro = dadosPes.getShort(GenMapResumoInfoPessoa.NAO_AVALIAR_FINANCEIRO);
        if (ToolMethods.isEquals((Object)naoAvaliarFinanceiro, (Object)1)) {
            return res;
        }
        if (ToolMethods.isEquals((Object)habilitarCompras, (Object)0)) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.CLIENTE_INABILITADO_PARA_COMPRA));
        }
        if (dataLiberacaoLimite == null) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.DATA_LIBERACAO_EXPIRADA));
        }
        if (dataLiberacaoLimite != null && diasLiberacaoLimite != null && (next = ToolDate.nextDays((Date)dataLiberacaoLimite, (int)diasLiberacaoLimite)).before(ToolDate.dataSemHora((Date)new Date()))) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.DATA_LIBERACAO_EXPIRADA));
        }
        if (diasLiberacaoLimite == null) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.DATA_LIBERACAO_EXPIRADA));
        }
        if (det.getSaldoTitulosVencidosAbertosCarencia() != null && det.getSaldoTitulosVencidosAbertosCarencia() > 0.0) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.CLIENTE_POSSUI_TITULOS_VENCIDOS));
        }
        if (det.getNumTitulosCartorio() != null && det.getNumTitulosCartorio() > 0L) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.CLIENTE_POSSUI_TITULOS_VENCIDOS));
        }
        if (det.getNumTitulosProtestados() != null && det.getNumTitulosProtestados() > 0L) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.CLIENTE_POSSUI_TITULOS_VENCIDOS));
        }
        if (det.getValorChequesDevolvidos() != null && det.getValorChequesDevolvidos() > 0.0) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.CLIENTE_POSSUI_CHEQUES_DEVOLVIDOS));
        }
        if (limiteCreditoPedido == null || limiteCreditoPedido <= 0.0) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.LIMITE_CREDITO_INFERIOR));
        }
        if (limiteCreditoFinanceiro == null || limiteCreditoFinanceiro <= 0.0) {
            res.add(new DTOMobileEstatisticasPessoa.ItemRestricao(EnumConstAnaliseFinPessoa.LIMITE_CREDITO_FINANCEIRO_INFERIOR));
        }
        return res;
    }

    public WebDTOResult validarPesquisarFinanceiroCliente(UnidadeFatCliente cliente, Double valorAdicional, OpcoesFinanceiras opFin) {
        if (opFin != null) {
            if (ToolMethods.isEquals((Object)opFin.getTipoAnaliseCreditoCliente(), (Object)EnumConstTipoAnaliseCreditoCliente.TIPO_ANALISE_CRED_CLIENTE_PESSOA.getValue()) || cliente.getCliente().getPessoa().getGrupoPessoas() == null) {
                CompAnaliseCreditoCliente compAnaliseCreditoCliente = this.getBean(CompAnaliseCreditoCliente.class);
                return compAnaliseCreditoCliente.validarClienteFinanceiro(cliente, valorAdicional, opFin);
            }
            CompAnaliseCreditoGrupoPessoas compAnaliseCreditoGrupoPessoas = this.getBean(CompAnaliseCreditoGrupoPessoas.class);
            return compAnaliseCreditoGrupoPessoas.validarClienteFinanceiro(cliente.getCliente().getPessoa().getGrupoPessoas(), valorAdicional, opFin);
        }
        return new WebDTOResult();
    }
}

