/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.estatisticasfinanccomercpessoa;

import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.model.impl.EstatisticasGrupoPessoas;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.interfaces.ServiceChequeTerceiros;
import com.touchcomp.basementorservice.service.interfaces.ServiceSaldoTitulos;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEstatisticasFinancGrupoPessoasImpl
extends ServiceGenericImpl {
    @Autowired
    private ServiceSaldoTitulos serviceSaldoTitulo;
    @Autowired
    private ServiceChequeTerceiros serviceChequeTerceiros;

    public EstatisticasGrupoPessoas findEstatisticasGrupoPessoas(GrupoPessoas grupoPessoa, Boolean incluirCheques) {
        EstatisticasGrupoPessoas e = new EstatisticasGrupoPessoas(grupoPessoa);
        e.setLimiteCredito(grupoPessoa.getLimiteCredito());
        e.setLimiteCreditoFinanceiro(grupoPessoa.getLimiteCreditoFinanceiro());
        e.setDataLiberacao(grupoPessoa.getDataLiberacaoCredito());
        e.setDiasValidade(grupoPessoa.getDiasVigorLimiteCred());
        e.setSaldoAberto(this.serviceSaldoTitulo.getSaldoDevedorGrupoPessoa(grupoPessoa.getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA, new Date()));
        e.setChequesDevolvidos(this.serviceChequeTerceiros.valorChequesDevolvidosGrupoPessoas(grupoPessoa.getIdentificador()));
        e.setChequesNaoCompensados(this.serviceChequeTerceiros.valorChequesNaoCompensadosGrupoPessoa(grupoPessoa.getIdentificador()));
        e.setSaldoVencido(this.serviceSaldoTitulo.getSaldoVencidoGrupoPessoa(grupoPessoa.getIdentificador(), EnumConstSaldoTitPagRec.TIPO_TITULO_REC, EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA, new Date()));
        Double limiteDispGrPess = e.getLimiteCredito() - e.getSaldoAberto();
        if (incluirCheques.booleanValue()) {
            limiteDispGrPess = limiteDispGrPess - (e.getChequesDevolvidos() - e.getChequesNaoCompensados());
        }
        e.setLimiteDisponivel(limiteDispGrPess);
        Integer diasLimiteGr = e.getDiasValidade();
        if (e.getDataLiberacao() != null) {
            Date dataVal = ToolDate.nextDays((Date)e.getDataLiberacao(), (int)diasLimiteGr);
            e.setDataLimite(dataVal);
        }
        return e;
    }
}

