/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.estruturaorcamentaria;

import com.touchcomp.basementor.constants.enums.filtroanaliseorcamentaria.EnumConstFiltroAnaliseOrcamentaria;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencialTipoData;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.impl.IndiceGerencialCalculado;
import com.touchcomp.basementor.model.impl.IndiceGerencialParams;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentaria;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPer;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPerLinha;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.indicegerencial.ExceptionIndiceGerencial;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoEstruturaOrcamentariaImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.grupoempresas.ServiceGrupoEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.ServiceBuildIndiceGerencialImpl;
import com.touchcomp.basementorservice.service.impl.indicegerencial.ServiceIndiceGerencialImpl;
import com.touchcomp.basementorservice.service.impl.intervalocontroleger.ServiceIntervaloControleGerImpl;
import com.touchcomp.basementorservice.service.impl.planejamentoorcamentario.ServicePlanejamentoOrcamentarioImpl;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import com.touchcomp.touchvomodel.vo.estruturaorcamentaria.DTOEstruturaOrcamentaria;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceEstruturaOrcamentariaImpl
extends ServiceGenericEntityImpl<EstruturaOrcamentaria, Long, DaoEstruturaOrcamentariaImpl> {
    ServiceIndiceGerencialImpl serviceIndiceGerencialImpl;
    ServiceIntervaloControleGerImpl serviceIntervaloControleGerImpl;
    ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl;
    ServiceBuildIndiceGerencialImpl serviceBuildGerencial;
    ServiceGrupoEmpresaImpl serviceGrupoEmpresa;

    public ServiceEstruturaOrcamentariaImpl(ServiceIndiceGerencialImpl serviceIndiceGerencialImpl, ServiceIntervaloControleGerImpl serviceIntervaloControleGerImpl, ServicePlanejamentoOrcamentarioImpl servicePlanejamentoOrcamentarioImpl, ServiceBuildIndiceGerencialImpl serviceBuildGerencial, DaoEstruturaOrcamentariaImpl genericDao) {
        super(genericDao);
        this.serviceIndiceGerencialImpl = serviceIndiceGerencialImpl;
        this.serviceIntervaloControleGerImpl = serviceIntervaloControleGerImpl;
        this.servicePlanejamentoOrcamentarioImpl = servicePlanejamentoOrcamentarioImpl;
        this.serviceBuildGerencial = serviceBuildGerencial;
    }

    public List<DTOEstruturaOrcamentaria.DTOEstruturaOrcamentariaPer> buildEstruturaOrcada(Long idIndiceGerencial, Long idIntervaloControleGer, Empresa empresa) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionReflection, ExceptionIndiceGerencial {
        IndiceGerencial indice = (IndiceGerencial)this.serviceIndiceGerencialImpl.get(idIndiceGerencial);
        IntervaloControleGer intervalo = (IntervaloControleGer)this.serviceIntervaloControleGerImpl.get(idIntervaloControleGer);
        if (indice == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0165.001", new Object[]{idIndiceGerencial}));
        }
        if (intervalo == null) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1311.001", new Object[]{idIntervaloControleGer}));
        }
        LinkedList<EstruturaOrcamentariaPer> ret = new LinkedList<EstruturaOrcamentariaPer>();
        for (IntervaloControleGerPer inter : intervalo.getIntervalos()) {
            EstruturaOrcamentariaPer est = new EstruturaOrcamentariaPer();
            est.setIntervaloControleGerPer(inter);
            est.setEstruturaOrcamentariaPeriodos(this.getValores(est, indice, empresa));
            ret.add(est);
        }
        ToolDTOBuilder b = new ToolDTOBuilder(EstruturaOrcamentariaPer.class, DTOEstruturaOrcamentaria.DTOEstruturaOrcamentariaPer.class);
        return b.toDTO(ret);
    }

    private List<EstruturaOrcamentariaPerLinha> getValores(EstruturaOrcamentariaPer est, IndiceGerencial indice, Empresa empresa) throws ExceptionJEPParser, ExceptionInvalidData, ExceptionIndiceGerencial {
        IndiceGerencialParams params = new IndiceGerencialParams(indice, est.getIntervaloControleGerPer(), empresa.getIdentificador(), empresa.getIdentificador(), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), Short.valueOf(EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()), EnumTipoLancamentoCTBGerencial.COMPETENCIA_LIQUIDACAO, Short.valueOf(EnumLancamentoCTBGerencialTipoData.TIPO_DATA_CADASTRO_COMP.getValue()));
        params.setCalcularMeta(false);
        params.setCalcularProvisionado(false);
        params.setCalcularRealizado(false);
        IndiceGerencialCalculado calc = this.serviceBuildGerencial.calcularIndiceGerencial(params);
        LinkedList<EstruturaOrcamentariaPerLinha> ret = new LinkedList<EstruturaOrcamentariaPerLinha>();
        for (IndiceGerencialCalculado.LinhaIndice linha : calc.getLinhas()) {
            EstruturaOrcamentariaPerLinha lin = new EstruturaOrcamentariaPerLinha();
            lin.setDataAtualizacaoLinhaInd(linha.getLinhaIndiceGerencial().getDataAtualizacao());
            lin.setLinhaIndiceGerencial(linha.getLinhaIndiceGerencial());
            lin.setEstruturaOrcamentariaPer(est);
            lin.setValorCalculado(linha.getValorOrcado());
            ret.add(lin);
        }
        Collections.sort(ret, (o1, o2) -> {
            Integer index1 = 0;
            Integer index2 = 0;
            if (o1.getLinhaIndiceGerencial() != null && o1.getLinhaIndiceGerencial().getIndice() != null) {
                index1 = o1.getLinhaIndiceGerencial().getIndice();
            }
            if (o2.getLinhaIndiceGerencial() != null && o2.getLinhaIndiceGerencial().getIndice() != null) {
                index2 = o2.getLinhaIndiceGerencial().getIndice();
            }
            return index1.compareTo(index2);
        });
        return ret;
    }

    public List<DTOEntidadeRes> getEstruturasTravadas(EnumConstFiltroAnaliseOrcamentaria filtros, Empresa loggedEmpresa) {
        List<EstruturaOrcamentaria> pacotes = ((DaoEstruturaOrcamentariaImpl)this.getDao()).getEstruturasTravadas(filtros, loggedEmpresa);
        LinkedList<DTOEntidadeRes> ret = new LinkedList<DTOEntidadeRes>();
        for (EstruturaOrcamentaria est : pacotes) {
            ret.add(new DTOEntidadeRes(est.getIdentificador(), est.getDescricao()));
        }
        return ret;
    }

    @Override
    public EstruturaOrcamentaria beforeSave(EstruturaOrcamentaria aux) {
        for (EstruturaOrcamentariaPer estPer : aux.getEstruturaOrcamentariaPeriodos()) {
            estPer.setEstruturaOrcamentaria(aux);
            for (EstruturaOrcamentariaPerLinha per : estPer.getEstruturaOrcamentariaPeriodos()) {
                per.setEstruturaOrcamentariaPer(estPer);
            }
        }
        return aux;
    }

    public List<DTOEntidadeRes> getPlanejamentosVincEstrutura(Long idEstrutura) {
        return ((DaoEstruturaOrcamentariaImpl)this.getDao()).getPlanejamentosVincEstrutura(idEstrutura);
    }

    public List<DTOEntidadeRes> getPlanejamentosVincEstrutura(Long idEstrutura, Usuario usuario) {
        return ((DaoEstruturaOrcamentariaImpl)this.getDao()).getPlanejamentosVincEstrutura(idEstrutura, usuario.getIdentificador());
    }
}

