/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega;

import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoDetEvtComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoEvtComprovanteEntrega;
import com.touchcomp.basementor.constants.enums.comprovanteentrega.EnumConstStatusRetornoEvento;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.evtctedesacordo.EnumTipoEventoCTeDesacordo;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.EventoComprovanteEntrega;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.comprovanteentrega.UtilCancelamentoComprovanteEntregaNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.comprovanteentrega.NFeCancelamentoComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicacao.comprovanteentrega.EnumExceptionComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicacao.comprovanteentrega.ExceptionComprovanteEntrega;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega.ServiceEventoComprovanteEntregaImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import java.util.Date;

class AuxCancelarComprovanteEntrega {
    private final ServiceVersaoVersoesImpl serviceVersao;
    private final HelperConfiguracaoCertificado helperConfigCertificado;
    private final ServiceConfiguracaoCertificadoImpl serviceConfCertificado;
    private final ServiceEventoComprovanteEntregaImpl serviceEvtComprovanteEntrega;

    public AuxCancelarComprovanteEntrega(ServiceVersaoVersoesImpl serviceVersao, HelperConfiguracaoCertificado helperConfigCertificado, ServiceConfiguracaoCertificadoImpl serviceConfCertificado, ServiceEventoComprovanteEntregaImpl serviceEvtComprovanteEntrega) {
        this.serviceVersao = serviceVersao;
        this.helperConfigCertificado = helperConfigCertificado;
        this.serviceConfCertificado = serviceConfCertificado;
        this.serviceEvtComprovanteEntrega = serviceEvtComprovanteEntrega;
    }

    private NFeCancelamentoComprovanteEntrega buildToSend(EventoComprovanteEntrega vo) {
        NFeCancelamentoComprovanteEntrega toSinc = new NFeCancelamentoComprovanteEntrega();
        toSinc.setDataEvento(vo.getDataEvento());
        toSinc.setNumSeqEvento(vo.getNumSeqEvento());
        toSinc.setChaveNFe(vo.getChaveNotaPropria());
        toSinc.setCodigoUf(vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        toSinc.setCpfCnpj(vo.getEmpresa().getPessoa().getComplemento().getCnpj());
        toSinc.setNumeroProtocoloEvt(vo.getNrProtocolo());
        DTOInfoVersao info = this.serviceVersao.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        if (TMethods.isNotNull((Object)info).booleanValue() && TMethods.isNotNull((Object)info.getCodigo()).booleanValue()) {
            toSinc.setVersaoAplicacao(String.valueOf(info.getCodigo()));
        }
        return toSinc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventoComprovanteEntrega cancelarComprovante(EventoComprovanteEntrega vo) throws Exception {
        NFeCancelamentoComprovanteEntrega toSinc = this.buildToSend(vo);
        ConfiguracaoCertificado config = this.serviceConfCertificado.getByEmpresa(vo.getEmpresa());
        ParamsCertificado params = this.helperConfigCertificado.build(config).getParamsCertificado(ConstAmbiente.HOMOLOGACAO);
        NFRetornoEvtComprovanteEntrega ret = new UtilCancelamentoComprovanteEntregaNFe().enviarComprovanteEntrega(params, EnumConstNFeVersao.VERSAO_4_00, toSinc);
        if (TMethods.isNotNull((Object)ret) == false) return vo;
        if (!TMethods.isEquals((Object)ret.getStatus(), (Object)EnumConstStatusRetornoEvento.LOTE_PROCESSADO.getValueAsString())) throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.FALHA_ENVIO_COMPROVANTE, new Object[]{ret.getMotivo()});
        if (!BaseMethods.isWithData(ret.getEventos())) return vo;
        NFRetornoDetEvtComprovanteEntrega evt = (NFRetornoDetEvtComprovanteEntrega)ret.getEventos().getFirst();
        if (TMethods.isEquals((Object)evt.getEvento().getStatus(), (Object)EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_VINC_NFE.getValueAsString())) {
            return this.process(vo, evt, EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_VINC_NFE);
        }
        if (!TMethods.isEquals((Object)evt.getEvento().getStatus(), (Object)EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_NAO_VINC_NFE.getValueAsString())) throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.REJEICAO_ENVIO_COMPROVANTE, new Object[]{evt.getEvento().getMotivo()});
        return this.process(vo, evt, EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_VINC_NFE);
    }

    private EventoComprovanteEntrega process(EventoComprovanteEntrega vo, NFRetornoDetEvtComprovanteEntrega ret, EnumConstStatusRetornoEvento status) {
        if (TMethods.isNotNull((Object)vo.getEventoCancelado()).booleanValue()) {
            this.serviceEvtComprovanteEntrega.delete(vo.getEventoCancelado());
        }
        EventoComprovanteEntrega eventoCancelamento = new EventoComprovanteEntrega();
        eventoCancelamento.setChaveNotaPropria(vo.getChaveNotaPropria());
        eventoCancelamento.setDataCadastro(new Date());
        eventoCancelamento.setDataEvento(ToolDate.strToDate((String)ret.getEvento().getDataRegistroEvento(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX"));
        eventoCancelamento.setEmpresa(vo.getEmpresa());
        eventoCancelamento.setNrProtocolo(ret.getEvento().getNumeroProtocolo());
        eventoCancelamento.setNumSeqEvento(Integer.valueOf(ret.getEvento().getSequencia()));
        eventoCancelamento.setNumeroNota(vo.getNumeroNota());
        eventoCancelamento.setSerieNota(vo.getSerieNota());
        eventoCancelamento.setStatus(status.getValue());
        eventoCancelamento.setTipoEvento(EnumTipoEventoCTeDesacordo.EVENTO_CANCELAMENTO.getValue());
        eventoCancelamento = this.serviceEvtComprovanteEntrega.saveOrUpdate(eventoCancelamento);
        vo.setProtocoloEventoCancelado(eventoCancelamento.getNrProtocolo());
        vo.setEventoCancelado(eventoCancelamento);
        return vo;
    }
}

