/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega;

import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoDetEvtComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoEvtComprovanteEntrega;
import com.touchcomp.basementor.constants.enums.comprovanteentrega.EnumConstStatusRetornoEvento;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.EventoComprovanteEntrega;
import com.touchcomp.basementorbinary.model.ArqEvtComprovanteEntrega;
import com.touchcomp.basementorbinary.service.impl.arqeventocomprovanteentrega.ServiceBinaryArqEvtComprovanteEntrega;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.impl.comprovanteentrega.UtilEnvioComprovanteEntregaNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.comprovanteentrega.NFeComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicacao.comprovanteentrega.EnumExceptionComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicacao.comprovanteentrega.ExceptionComprovanteEntrega;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega.ServiceEventoComprovanteEntregaImpl;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorversao.model.temp.DTOInfoVersao;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import javax.xml.bind.DatatypeConverter;

class AuxEnviarComprovanteEntrega {
    private final ServiceBinaryArqEvtComprovanteEntrega serviceArqDocumento;
    private final HelperConfiguracaoCertificado helperConfigCertificado;
    private final ServiceConfiguracaoCertificadoImpl serviceConfCertificado;
    private final ServiceVersaoVersoesImpl serviceVersao;
    private final ServiceEventoComprovanteEntregaImpl serviceEvtComprovanteEntrega;

    public AuxEnviarComprovanteEntrega(ServiceBinaryArqEvtComprovanteEntrega serviceArqDocumento, HelperConfiguracaoCertificado helperConfigCertificado, ServiceConfiguracaoCertificadoImpl serviceConfCertificado, ServiceVersaoVersoesImpl serviceVersao, ServiceEventoComprovanteEntregaImpl serviceEvtComprovanteEntrega) {
        this.serviceArqDocumento = serviceArqDocumento;
        this.helperConfigCertificado = helperConfigCertificado;
        this.serviceConfCertificado = serviceConfCertificado;
        this.serviceVersao = serviceVersao;
        this.serviceEvtComprovanteEntrega = serviceEvtComprovanteEntrega;
    }

    private NFeComprovanteEntrega buildToSend(EventoComprovanteEntrega vo) {
        NFeComprovanteEntrega toSinc = new NFeComprovanteEntrega();
        toSinc.setDataEntrega(vo.getDataEntrega());
        toSinc.setDataEvento(vo.getDataEvento());
        toSinc.setDocumentoRecebedor(vo.getDocumentoRecebedor());
        toSinc.setNomeRecebedor(vo.getNomeRecebedor());
        toSinc.setNumSeqEvento(Integer.valueOf(vo.getNumSeqEvento() + 1));
        toSinc.setNumeroNota(vo.getNumeroNota());
        toSinc.setSerieNota(vo.getSerieNota());
        toSinc.setChaveAcesso(vo.getChaveNotaPropria());
        toSinc.setCodigoUf(vo.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        toSinc.setCpfCnpj(vo.getEmpresa().getPessoa().getComplemento().getCnpj());
        ArqEvtComprovanteEntrega arq = this.serviceArqDocumento.findDocumentoByComprovante(vo.getIdentificador());
        Object comprovante = "";
        if (TMethods.isStrWithData((String)toSinc.getChaveAcesso())) {
            comprovante = (String)comprovante + toSinc.getChaveAcesso();
        }
        if (TMethods.isNotNull((Object)arq).booleanValue() && TMethods.isStrWithData((String)arq.getDocumento())) {
            comprovante = (String)comprovante + this.hexParaBase64(arq.getDocumento());
        }
        toSinc.setComprovante(ToolBase64.encodeBase64((String)comprovante));
        DTOInfoVersao info = this.serviceVersao.getVersaoSistema(EnumConstTipoSistemasTouch.MENTOR_BD);
        if (TMethods.isNotNull((Object)info).booleanValue() && TMethods.isNotNull((Object)info.getCodigo()).booleanValue()) {
            toSinc.setVersaoAplicacao(String.valueOf(info.getCodigo()));
        }
        return toSinc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventoComprovanteEntrega enviarComprovante(EventoComprovanteEntrega vo) throws Exception {
        NFeComprovanteEntrega toSinc = this.buildToSend(vo);
        ConfiguracaoCertificado config = this.serviceConfCertificado.getByEmpresa(vo.getEmpresa());
        ParamsCertificado params = this.helperConfigCertificado.build(config).getParamsCertificado(ConstAmbiente.HOMOLOGACAO);
        NFRetornoEvtComprovanteEntrega ret = new UtilEnvioComprovanteEntregaNFe().enviarComprovanteEntrega(params, EnumConstNFeVersao.VERSAO_4_00, toSinc);
        if (!TMethods.isNotNull((Object)ret).booleanValue()) return vo;
        if (!TMethods.isEquals((Object)ret.getStatus(), (Object)EnumConstStatusRetornoEvento.LOTE_PROCESSADO.getValueAsString())) throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.FALHA_ENVIO_COMPROVANTE, new Object[]{ret.getMotivo()});
        if (!BaseMethods.isWithData(ret.getEventos())) return vo;
        NFRetornoDetEvtComprovanteEntrega evt = (NFRetornoDetEvtComprovanteEntrega)ret.getEventos().getFirst();
        if (TMethods.isEquals((Object)evt.getEvento().getStatus(), (Object)EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_VINC_NFE.getValueAsString())) {
            this.process(vo, evt, EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_VINC_NFE);
            return vo;
        } else if (TMethods.isEquals((Object)evt.getEvento().getStatus(), (Object)EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_NAO_VINC_NFE.getValueAsString())) {
            this.process(vo, evt, EnumConstStatusRetornoEvento.EVENTO_REGISTRADO_VINC_NFE);
            return vo;
        } else {
            this.processError(vo, evt);
            throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.REJEICAO_ENVIO_COMPROVANTE, new Object[]{evt.getEvento().getMotivo()});
        }
    }

    private void processError(EventoComprovanteEntrega vo, NFRetornoDetEvtComprovanteEntrega evt) {
        if (TMethods.isNull((Object)vo.getNrProtocolo()).booleanValue()) {
            vo.setStatus(Short.valueOf(evt.getEvento().getStatus()));
            vo.setMotivo(evt.getEvento().getMotivo());
            this.serviceEvtComprovanteEntrega.saveOrUpdateOnly(vo);
        }
    }

    private void process(EventoComprovanteEntrega vo, NFRetornoDetEvtComprovanteEntrega evt, EnumConstStatusRetornoEvento status) {
        vo.setNumSeqEvento(Integer.valueOf(vo.getNumSeqEvento() + 1));
        vo.setNrProtocolo(evt.getEvento().getNumeroProtocolo());
        vo.setDataEvento(ToolDate.strToDate((String)evt.getEvento().getDataRegistroEvento(), (String)"yyyy-MM-dd'T'HH:mm:ssXXX"));
        vo.setStatus(status.getValue());
        vo.setProtocoloEventoCancelado(null);
        vo.setEventoCancelado(null);
        this.serviceEvtComprovanteEntrega.saveOrUpdateOnly(vo);
    }

    private String hexParaBase64(String stringHexadecimal) {
        if (!TMethods.isStrWithData((String)stringHexadecimal)) {
            return "";
        }
        try {
            byte[] bytesDaImagem = DatatypeConverter.parseHexBinary((String)stringHexadecimal);
            String stringBase64 = ToolBase64.encodeBase64((byte[])bytesDaImagem);
            return stringBase64;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

