/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega;

import com.touchcomp.basementor.constants.enums.evtctedesacordo.EnumTipoEventoCTeDesacordo;
import com.touchcomp.basementor.model.vo.EventoComprovanteEntrega;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementorbinary.service.impl.arqeventocomprovanteentrega.ServiceBinaryArqEvtComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicacao.comprovanteentrega.EnumExceptionComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.impl.comunicacao.comprovanteentrega.ExceptionComprovanteEntrega;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.dao.impl.DaoEventoComprovanteEntregaImpl;
import com.touchcomp.basementorservice.helpers.impl.configuracaocertificado.HelperConfiguracaoCertificado;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega.AuxCancelarComprovanteEntrega;
import com.touchcomp.basementorservice.service.impl.eventocomprovanteentrega.AuxEnviarComprovanteEntrega;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorversao.service.impl.versoes.ServiceVersaoVersoesImpl;
import com.touchcomp.touchvomodel.vo.eventocomprovanteentrega.mobile.DTOFiltroEventoComprovanteEnt;
import com.touchcomp.touchvomodel.vo.eventocomprovanteentrega.web.DTOEventoComprovanteEntrega;
import java.math.BigInteger;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEventoComprovanteEntregaImpl
extends ServiceGenericEntityImpl<EventoComprovanteEntrega, Long, DaoEventoComprovanteEntregaImpl> {
    @Autowired
    private ServiceNotaFiscalPropriaImpl serviceNotaPropria;
    @Autowired
    private ServiceBinaryArqEvtComprovanteEntrega serviceArqDocumento;
    @Autowired
    private HelperConfiguracaoCertificado helperConfigCertificado;
    @Autowired
    private ServiceConfiguracaoCertificadoImpl serviceConfCertificado;
    @Autowired
    private ServiceVersaoVersoesImpl serviceVersao;

    @Autowired
    public ServiceEventoComprovanteEntregaImpl(DaoEventoComprovanteEntregaImpl genericDao) {
        super(genericDao);
    }

    @Override
    public EventoComprovanteEntrega beforeSaveEntity(EventoComprovanteEntrega vo) {
        NotaFiscalPropria nota;
        if (this.isNotNull(vo.getNumeroNota()).booleanValue() && this.isNotNull(vo.getSerieNota()).booleanValue() && this.isNotNull(vo.getEmpresa()).booleanValue() && TMethods.isNotNull((Object)(nota = this.serviceNotaPropria.getPorNumeroSerieEmpresa(vo.getNumeroNota(), vo.getSerieNota(), vo.getEmpresa()))).booleanValue()) {
            vo.setChaveNotaPropria(nota.getChaveNFE());
        }
        if (!this.isStrWithData(vo.getChaveNotaPropria())) {
            throw new ExceptionRuntimeBase("E.ERP.2017.004");
        }
        return vo;
    }

    public EventoComprovanteEntrega findByIdMobile(BigInteger idMobile) {
        return ((DaoEventoComprovanteEntregaImpl)this.getGenericDao()).findByIdMobile(idMobile);
    }

    public List<DTOEventoComprovanteEntrega> filtrarComprovantes(DTOFiltroEventoComprovanteEnt filtro) throws ExceptionInvalidData {
        if (this.isNull(filtro).booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.2017.001", new Object[0]);
        }
        return this.buildToDTO(((DaoEventoComprovanteEntregaImpl)this.getGenericDao()).pesquisarComprovantes(filtro.getIdEmpresa(), filtro.getIdEntregador(), filtro.getDataInicial(), filtro.getDataFinal(), filtro.getNrNota(), filtro.getSerieNota(), filtro.getNomeRecebedor(), filtro.getDocRecebedor()), DTOEventoComprovanteEntrega.class);
    }

    public void enviarComprovante(Long identificador) throws Exception {
        EventoComprovanteEntrega vo = (EventoComprovanteEntrega)this.getOrThrow(identificador);
        if (this.isEquals(vo.getTipoEvento(), EnumTipoEventoCTeDesacordo.EVENTO_CANCELAMENTO.getValue())) {
            throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.OPERACAO_ENVIO_NAO_PERMITIDA_COMPROVANTE_CANCELAMENTO, new Object[0]);
        }
        if (this.isStrWithData(vo.getNrProtocolo()) && this.isNull(vo.getEventoCancelado()).booleanValue()) {
            throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.COMPROVANTE_JA_ENVIADO, new Object[0]);
        }
        new AuxEnviarComprovanteEntrega(this.serviceArqDocumento, this.helperConfigCertificado, this.serviceConfCertificado, this.serviceVersao, this).enviarComprovante(vo);
    }

    public void cancelarComprovante(Long identificador) throws Exception {
        EventoComprovanteEntrega vo = (EventoComprovanteEntrega)this.getOrThrow(identificador);
        if (!this.isStrWithData(vo.getNrProtocolo())) {
            throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.COMPROVANTE_NAO_ENVIADO_NAO_PASSIVEL_CANCELAMENTO, new Object[0]);
        }
        if (this.isNotNull(vo.getEventoCancelado()).booleanValue()) {
            throw new ExceptionComprovanteEntrega(EnumExceptionComprovanteEntrega.COMPROVANTE_JA_CANCELADO, new Object[0]);
        }
        new AuxCancelarComprovanteEntrega(this.serviceVersao, this.helperConfigCertificado, this.serviceConfCertificado, this).cancelarComprovante(vo);
    }
}

