/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventoosprodsobenc;

import com.touchcomp.basementor.constants.enums.celulaprodutiva.EnumConstCelulaProdTipoCusto;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.DiaHorarioTrabalho;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.HoraExtraHorTrab;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.ItemCompCustoEvtEnc;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

class AuxCustoEventoOsSobEnc {
    final ServiceFeriadoImpl serviceFeriado;
    final ServiceSaldoEstoqueImpl serviceSaldo;
    final ServiceColaboradorImpl serviceColaborador;
    final ServiceCelulaProdutivaImpl serviceCelula;
    final OpcoesPCP opcoesPCP;
    final HelperOpcoesPCP helperOpcoesPCP;

    public AuxCustoEventoOsSobEnc(ServiceFeriadoImpl serviceFeriado, ServiceSaldoEstoqueImpl serviceSaldo, ServiceColaboradorImpl serviceColaborador, ServiceCelulaProdutivaImpl serviceCelula, OpcoesPCP opcoesPCP, HelperOpcoesPCP helperOpcoesPCP) {
        this.serviceFeriado = serviceFeriado;
        this.serviceSaldo = serviceSaldo;
        this.serviceColaborador = serviceColaborador;
        this.opcoesPCP = opcoesPCP;
        this.serviceCelula = serviceCelula;
        this.helperOpcoesPCP = helperOpcoesPCP;
    }

    public void avaliarValorCustoSobEncomenda(EventoOsProdSobEnc evt, boolean avaliarFinal, EnumConstCelulaProdTipoCusto tipoCusto) throws ExceptionInvalidData {
        List result = this.getItemCompCusto(evt, avaliarFinal, tipoCusto);
        result = this.filtrarItensCompCusto(result, evt);
        evt.setItemCompCustoEvtEnc(result);
    }

    private List<ItemCompCustoEvtEnc> getItemCompCusto(EventoOsProdSobEnc evt, boolean avaliarFinal, EnumConstCelulaProdTipoCusto tipoCusto) throws ExceptionInvalidData {
        List aux = evt.getItemCompCustoEvtEnc();
        for (ItemCompCustoEvtEnc item : aux) {
            if (!ToolMethods.isEquals((Object)item.getInformadoManual(), (Object)(item.getInformadoManual() == 0 ? 1 : 0))) continue;
            if (!avaliarFinal) {
                item.setValorInicial(Double.valueOf(0.0));
            } else {
                item.setValorReal(Double.valueOf(0.0));
            }
            item.setQuantidadeRef(Double.valueOf(0.0));
        }
        this.getItemComposicaoCustoFaseProd(aux, evt, evt.getDataAbertura(), avaliarFinal, tipoCusto);
        for (ItemEventoOsProdSobEnc itemEventoOsProdSobEnc : evt.getItemEventoOsProdSobEnc()) {
            if (itemEventoOsProdSobEnc.getRequisicao() == null) continue;
            this.getItemCompCustoRequisicao(aux, itemEventoOsProdSobEnc.getRequisicao(), avaliarFinal);
        }
        this.getItemComposicaoCustoColaborador(aux, evt, avaliarFinal);
        return aux;
    }

    private void getItemCompCustoRequisicao(List<ItemCompCustoEvtEnc> base, Requisicao requisicao, boolean avaliarFinal) {
        if (requisicao == null) {
            return;
        }
        for (ItemRequisicao ir : requisicao.getItensRequisicao()) {
            this.getItemCompCustoRequisicao(base, ir, requisicao, avaliarFinal);
        }
    }

    private void getItemCompCustoRequisicao(List<ItemCompCustoEvtEnc> base, ItemRequisicao ir, Requisicao requisicao, boolean avaliarFinal) {
        if (!ToolMethods.isEquals((Object)ir.getCentroEstoque().getTipoEstProprioTerceiros(), (Object)EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue())) {
            return;
        }
        for (GradeItemRequisicao g : ir.getGradeItemRequisicao()) {
            ItemCompCustoEvtEnc io = null;
            for (ItemCompCustoEvtEnc oc : base) {
                ItemCompCustoEvtEnc aux = oc;
                if (aux.getGradeCor() == null || !aux.getGradeCor().equals((Object)g.getGradeCor()) || !this.getDataHoraZerada(aux.getDataReferencia()).equals(this.getDataHoraZerada(requisicao.getDataRequisicao()))) continue;
                io = aux;
                break;
            }
            if (io == null) {
                io = new ItemCompCustoEvtEnc();
                io.setGradeCor(g.getGradeCor());
                io.setCentroEstoque(g.getCentroEstoque());
                io.setDataReferencia(requisicao.getDataRequisicao());
                base.add(io);
            }
            io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + g.getQuantidade()));
            Double valor = this.serviceSaldo.findPrecoMedioProduto(g.getGradeCor().getProdutoGrade().getProduto(), requisicao.getEmpresa(), requisicao.getDataRequisicao(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO, null);
            if (!avaliarFinal) {
                io.setValorInicial(Double.valueOf(io.getValorInicial() + valor * g.getQuantidade()));
                continue;
            }
            io.setValorReal(Double.valueOf(io.getValorReal() + valor * g.getQuantidade()));
        }
    }

    private Object getItemComposicaoCustoFaseProd(List<ItemCompCustoEvtEnc> base, EventoOsProdSobEnc evt, Date dataReferencia, boolean avaliarFinal, EnumConstCelulaProdTipoCusto tipoCusto) {
        ItemCompCustoEvtEnc io = null;
        for (ItemCompCustoEvtEnc aux : base) {
            if (aux.getFaseProdutiva() == null || !aux.getFaseProdutiva().equals((Object)evt.getFaseProdutiva()) || !this.isDiaIgual(aux.getDataReferencia(), dataReferencia)) continue;
            io = aux;
            break;
        }
        if (io == null) {
            io = new ItemCompCustoEvtEnc();
            io.setFaseProdutiva(evt.getFaseProdutiva());
            io.setDataReferencia(this.getFirstDayOfMont(dataReferencia));
            base.add(io);
        }
        io.setQuantidadeRef(evt.getHoraEvento());
        Double valorCusto = this.serviceCelula.getCustoCelulaProdutiva(tipoCusto, dataReferencia, evt.getFaseProdutiva().getCelulaProdutiva()) * evt.getHoraEvento();
        if (!avaliarFinal) {
            io.setValorInicial(Double.valueOf(io.getValorInicial() + valorCusto));
        } else {
            io.setValorReal(Double.valueOf(io.getValorReal() + valorCusto));
        }
        return io;
    }

    private boolean isDiaIgual(Date d1, Date d2) {
        GregorianCalendar g1 = new GregorianCalendar();
        g1.setTime(d1);
        GregorianCalendar g2 = new GregorianCalendar();
        g2.setTime(d2);
        return g1.get(5) == g2.get(5) && g1.get(2) == g2.get(2) && g1.get(1) == g2.get(1);
    }

    private Date getFirstDayOfMont(Date aux) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(aux);
        g.set(5, 1);
        return this.getDataHoraZerada(aux);
    }

    private Date getDataHoraZerada(Date aux) {
        return ToolDate.dataSemHora((Date)aux);
    }

    protected List filtrarItensCompCusto(List result, EventoOsProdSobEnc evt) {
        ArrayList<ItemCompCustoEvtEnc> res = new ArrayList<ItemCompCustoEvtEnc>();
        for (Object o : result) {
            ItemCompCustoEvtEnc itc = (ItemCompCustoEvtEnc)o;
            if (itc.getQuantidadeRef() <= 0.0 && (itc.getInformadoManual() == null || itc.getInformadoManual() == 0)) {
                itc.setEvtOsSobEncomenda(evt);
                res.add(itc);
                continue;
            }
            itc.setEvtOsSobEncomenda(evt);
        }
        result.removeAll(res);
        return result;
    }

    private void getItemComposicaoCustoColaborador(List<ItemCompCustoEvtEnc> base, EventoOsProdSobEnc e, boolean avaliarFinal) throws ExceptionInvalidData {
        for (ColaboradorEvtOsProdSobEnc colaborador : e.getColaboradoresEvtProd()) {
            ItemCompCustoEvtEnc io = null;
            for (ItemCompCustoEvtEnc ob : base) {
                ItemCompCustoEvtEnc aux = ob;
                if (aux.getColaborador() == null || !aux.getColaborador().equals((Object)colaborador.getColaborador()) || !this.isDiaIgual(aux.getDataReferencia(), this.getDataHoraZerada(e.getDataAbertura()))) continue;
                io = aux;
                break;
            }
            if (io == null) {
                io = new ItemCompCustoEvtEnc();
                io.setColaborador(colaborador.getColaborador());
                io.setDataReferencia(this.getDataHoraZerada(e.getDataAbertura()));
                io.setValorInicial(Double.valueOf(0.0));
                io.setValorReal(Double.valueOf(0.0));
                base.add(io);
            }
            io.setQuantidadeRef(Double.valueOf(io.getQuantidadeRef() + e.getHoraEvento()));
            if (colaborador.getColaborador().getValorPorHora() == null) continue;
            if (!avaliarFinal) {
                io.setValorInicial(Double.valueOf(io.getValorInicial() + this.calcularValoresHoras(colaborador.getColaborador(), e)));
                continue;
            }
            io.setValorReal(Double.valueOf(io.getValorReal() + this.calcularValoresHoras(colaborador.getColaborador(), e)));
        }
    }

    private Double calcularValoresHoras(Colaborador colaborador, EventoOsProdSobEnc e) throws ExceptionInvalidData {
        HorarioTrabalho horarioTrabalho = colaborador.getHorarioTrabalho();
        if (horarioTrabalho != null) {
            Date dtAbert = this.getDataHoraZerada(e.getDataAbertura());
            DiaHorarioTrabalho found = null;
            for (DiaHorarioTrabalho d : horarioTrabalho.getDiaHorarioTrabalho()) {
                if (!dtAbert.equals(d.getDataHorTrab())) continue;
                found = d;
                break;
            }
            double horasTrabColab = 0.0;
            if (e.getDataFechamento() != null) {
                horasTrabColab = this.getHorasTrabColab(colaborador, e.getDataFechamento());
            }
            return this.calcularValoresHoras(colaborador, horasTrabColab, found, e);
        }
        return this.calculaValorHora(colaborador, e.getHoraEvento(), 1.0);
    }

    private double getHorasTrabColab(Colaborador colaborador, Date dataFechamento) {
        return this.serviceColaborador.getHorasTrabDiaEvt(colaborador, dataFechamento);
    }

    private Double calcularValoresHoras(Colaborador colaborador, double horasTrabColab, DiaHorarioTrabalho found, EventoOsProdSobEnc evt) throws ExceptionInvalidData {
        double horaNormal = 0.0;
        double horaExtra = 0.0;
        double totalHorasDia = 0.0;
        if (found != null) {
            totalHorasDia = found.getTotalHorasDia();
        }
        if (horasTrabColab < totalHorasDia) {
            double difHoras = totalHorasDia - horasTrabColab;
            if (difHoras - evt.getHoraEvento() < 0.0) {
                horaNormal = difHoras;
                horaExtra = evt.getHoraEvento() - difHoras;
            } else {
                horaNormal = evt.getHoraEvento();
                horaExtra = 0.0;
            }
        } else {
            horaExtra = evt.getHoraEvento();
        }
        if (found == null) {
            return this.calculaValorHora(colaborador, horaExtra, 0.0);
        }
        double soma = 0.0;
        if (horaNormal > 0.0) {
            soma += this.calculaValorHora(colaborador, horaNormal, 0.0).doubleValue();
        }
        if (horaExtra > 0.0) {
            soma += this.calcularHoraExtraHor(colaborador, horaExtra, evt.getDataFechamento()).doubleValue();
        }
        return soma;
    }

    Double calculaValorHora(Colaborador colaborador, double horas, double perc) {
        return (colaborador.getValorPorHora() * (perc / 100.0 + 1.0) + colaborador.getValorTributosPorHora()) * horas;
    }

    private Double calcularHoraExtraHor(Colaborador colaborador, double horaExtra, Date data) throws ExceptionInvalidData {
        Short permitirApontamentoSemHor;
        double total = 0.0;
        double acumulado = 0.0;
        List horas = this.getFilterDayHoras(colaborador.getHorarioTrabalho().getHorasExtras(), data, colaborador.getEmpresa());
        if (horas.isEmpty() && ToolMethods.isAffirmative((Number)(permitirApontamentoSemHor = (Short)CompOpcoes.getOption(this.helperOpcoesPCP.build(this.opcoesPCP).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.INFORMAR_CLASSIFICACAO_EVENTO, Short.class)))) {
            throw new ExceptionInvalidData("E.ERP.0516.003", new Object[]{colaborador});
        }
        for (HoraExtraHorTrab h : horas) {
            if (horaExtra + acumulado - h.getNumeroHoras() < 0.0) {
                total += this.calculaValorHora(colaborador, horaExtra - acumulado, h.getPercentualHoraExtra()).doubleValue();
                acumulado = 0.0;
                break;
            }
            total += this.calculaValorHora(colaborador, h.getNumeroHoras(), h.getPercentualHoraExtra()).doubleValue();
            acumulado += h.getNumeroHoras().doubleValue();
        }
        if (ToolMethods.isWithData((Number)acumulado)) {
            throw new ExceptionInvalidData("E.ERP.0516.013", new Object[]{acumulado});
        }
        return total;
    }

    private List getFilterDayHoras(List<HoraExtraHorTrab> horasExtras, Date data, Empresa emp) {
        ArrayList<HoraExtraHorTrab> result = new ArrayList<HoraExtraHorTrab>();
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        int day = g.get(7);
        for (HoraExtraHorTrab h : horasExtras) {
            if (this.isFeriado(data, emp) && h.getFeriado() != null && h.getFeriado() == 1) {
                result.add(h);
                continue;
            }
            if (day == 1 && h.getDomingo() != null && h.getDomingo() == 1) {
                result.add(h);
                continue;
            }
            if (day == 2 && h.getSegunda() != null && h.getSegunda() == 1) {
                result.add(h);
                continue;
            }
            if (day == 3 && h.getTerca() != null && h.getTerca() == 1) {
                result.add(h);
                continue;
            }
            if (day == 4 && h.getQuarta() != null && h.getQuarta() == 1) {
                result.add(h);
                continue;
            }
            if (day == 5 && h.getQuinta() != null && h.getQuinta() == 1) {
                result.add(h);
                continue;
            }
            if (day == 6 && h.getSexta() != null && h.getSexta() == 1) {
                result.add(h);
                continue;
            }
            if (day != 7 || h.getSabado() == null || h.getSabado() != 1) continue;
            result.add(h);
        }
        return result;
    }

    private boolean isFeriado(Date data, Empresa emp) {
        return this.serviceFeriado.isFeriado(data, emp);
    }
}

