/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventoosprodsobenc;

import com.touchcomp.basementor.constants.enums.celulaprodutiva.EnumConstCelulaProdTipoCusto;
import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.EvtOSSobEncomendaEquip;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FaseProdutivaEquip;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoEventoOsProdSobEncImpl;
import com.touchcomp.basementorservice.helpers.impl.eventoossobencomenda.HelperEventoOSSobEncomenda;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.helpers.impl.ossobencomenda.HelperOrdemServicoProdSobEnc;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.celulaprodutiva.ServiceCelulaProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.eventoosprodsobenc.AuxCustoEventoOsSobEnc;
import com.touchcomp.basementorservice.service.impl.feriado.ServiceFeriadoImpl;
import com.touchcomp.basementorservice.service.impl.itemcomunicadoproducao.ServiceItemComunicadoProducaoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodsobenc.ServiceOrdemServicoProdSobEncImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodsobenc.ServiceSubdivisaoOSProdSobEncImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceFaseProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.saldoestoque.ServiceSaldoEstoqueImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.eventoosprodsobenc.web.DTOEventoOsProdSobEnc;
import com.touchcomp.touchvomodel.vo.eventoossobencomenda.DTOEventoOSSobEncomendaSimples;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceEventoOsProdSobEncImpl
extends ServiceGenericEntityImpl<EventoOsProdSobEnc, Long, DaoEventoOsProdSobEncImpl> {
    final ServiceOrdemServicoProdSobEncImpl serviceOrdemServicoProdSobEnc;
    final ServiceCelulaProdutivaImpl serviceCelula;
    final ServiceSaldoEstoqueImpl serviceSaldoEstoque;
    final ServiceColaboradorImpl serviceColaborador;
    final ServiceFeriadoImpl serviceFeriado;
    final HelperEventoOSSobEncomenda eventoOSSobEnc;
    final ServiceSubdivisaoOSProdSobEncImpl serviceSubdivisaoOSProdSobEnc;
    final ServiceFaseProdutivaImpl serviceFaseProdutiva;
    final ServiceItemComunicadoProducaoImpl serviceItemComunicadoProducaoImpl;
    final HelperOpcoesPCP helperOpcoesPCP;

    public ServiceEventoOsProdSobEncImpl(ServiceOrdemServicoProdSobEncImpl serviceOrdemServicoProdSobEnc, ServiceCelulaProdutivaImpl serviceCelula, ServiceSaldoEstoqueImpl serviceSaldoEstoque, ServiceColaboradorImpl serviceColaborador, ServiceFeriadoImpl serviceFeriado, HelperEventoOSSobEncomenda eventoOSSobEnc, ServiceSubdivisaoOSProdSobEncImpl serviceSubdivisaoOSProdSobEnc, ServiceFaseProdutivaImpl serviceFaseProdutiva, ServiceItemComunicadoProducaoImpl serviceItemComunicadoProducaoImpl, HelperOpcoesPCP helperOpcoesPCP, DaoEventoOsProdSobEncImpl genericDao) {
        super(genericDao);
        this.serviceOrdemServicoProdSobEnc = serviceOrdemServicoProdSobEnc;
        this.serviceCelula = serviceCelula;
        this.serviceSaldoEstoque = serviceSaldoEstoque;
        this.serviceColaborador = serviceColaborador;
        this.serviceFeriado = serviceFeriado;
        this.eventoOSSobEnc = eventoOSSobEnc;
        this.serviceSubdivisaoOSProdSobEnc = serviceSubdivisaoOSProdSobEnc;
        this.serviceFaseProdutiva = serviceFaseProdutiva;
        this.serviceItemComunicadoProducaoImpl = serviceItemComunicadoProducaoImpl;
        this.helperOpcoesPCP = helperOpcoesPCP;
    }

    public List<EventoOsProdSobEnc> findEventosOSSOBEnc(Date dataInicial, Date dataFinal, Empresa empresa) {
        return ((DaoEventoOsProdSobEncImpl)this.getGenericDao()).findEventosOSSOBEnc(dataInicial, dataFinal, empresa);
    }

    public void processarOSSobEncomenda(Date dataInicial, Date dataFinal, Empresa empresa) throws ExceptionInvalidData {
        List<EventoOsProdSobEnc> itemComProducao = this.findEventosOSSOBEnc(dataInicial, dataFinal, empresa);
        for (EventoOsProdSobEnc o : itemComProducao) {
            this.avaliarValorCustoFinalSobEncomenda(o);
            this.saveOrUpdateOnly(o);
        }
        List<OrdemServicoProdSobEnc> os = this.serviceOrdemServicoProdSobEnc.findOSSOBEnc(dataInicial, dataFinal);
        for (OrdemServicoProdSobEnc o : os) {
            this.serviceOrdemServicoProdSobEnc.saveOrUpdate(o);
        }
    }

    @Override
    public EventoOsProdSobEnc beforeSaveEntity(EventoOsProdSobEnc aux) {
        try {
            this.eventoOSSobEnc.build(aux).calculaHoras(aux, this.getSharedData().getOpcoesPCP(aux.getEmpresa()));
            aux.getColaboradoresEvtProd().forEach(i -> i.setEventoOsProdSobEnc(aux));
            aux.getEquipamentos().forEach(i -> i.setEventoOSProd(aux));
            aux.getFichasTecnicas().forEach(i -> i.setEventoOsSobEncomenda(aux));
            aux.getItemCompCustoEvtEnc().forEach(i -> i.setEvtOsSobEncomenda(aux));
            aux.getItemEventoOsProdSobEnc().forEach(i -> i.setEventoOSProdSobEnc(aux));
            if (this.isEquals(aux.getFecharSubOS(), (short)1)) {
                this.serviceOrdemServicoProdSobEnc.avaliarFecharSubOS(aux.getSubdivisaoOSProdSobEnc(), aux.getDataFechamento());
            }
            this.avaliarValorCustoSobEncomenda(aux);
            return aux;
        }
        catch (ExceptionInvalidData ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase(ex.getFormattedMessage());
        }
    }

    @Override
    public boolean deleteOnly(EventoOsProdSobEnc entity) {
        LinkedList<ItemComunicadoProducao> itens = new LinkedList<ItemComunicadoProducao>();
        OrdemServicoProdSobEnc os = entity.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc();
        for (Object item : entity.getItemEventoOsProdSobEnc()) {
            if (itens.contains(item.getItemComunicadoProducao())) continue;
            itens.add(item.getItemComunicadoProducao());
        }
        boolean ret = super.deleteOnly(entity);
        ((DaoEventoOsProdSobEncImpl)this.getDao()).flushData();
        try {
            for (ItemComunicadoProducao item : itens) {
                item = (ItemComunicadoProducao)this.serviceItemComunicadoProducaoImpl.get(item.getIdentificador());
                this.serviceItemComunicadoProducaoImpl.reprocessaCustoRemEvt(item, os);
            }
            return ret;
        }
        catch (ExceptionObjNotFound ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
    }

    @Override
    public EventoOsProdSobEnc afterSaveEntity(EventoOsProdSobEnc entity) {
        try {
            ((DaoEventoOsProdSobEncImpl)this.getDao()).flushData();
            for (ItemEventoOsProdSobEnc item : entity.getItemEventoOsProdSobEnc()) {
                item.setItemComunicadoProducao(this.serviceItemComunicadoProducaoImpl.reprocessaCustoRemEvt(item.getItemComunicadoProducao(), entity.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc()));
            }
            return entity;
        }
        catch (ExceptionObjNotFound ex) {
            this.logError(ex);
            throw new ExceptionRuntimeBase((ExceptionBase)((Object)ex));
        }
    }

    public EventoOsProdSobEnc getEventoAberto(String numeroRegistro, Empresa empresa, EnumConstOrigemEventoOSProd origemEvento) {
        if (numeroRegistro == null || empresa == null) {
            return null;
        }
        return ((DaoEventoOsProdSobEncImpl)this.getDao()).getEventoAberto(numeroRegistro, empresa.getIdentificador(), origemEvento);
    }

    public EventoOsProdSobEnc getEventoAberto(Empresa empresa, EnumConstOrigemEventoOSProd origemEvento) {
        if (empresa == null) {
            return null;
        }
        return ((DaoEventoOsProdSobEncImpl)this.getDao()).getEventoAberto(empresa.getIdentificador(), origemEvento);
    }

    public DTOEventoOSSobEncomendaSimples getEventoSimplesAberto(String numeroRegistro, Empresa empresa) {
        EventoOsProdSobEnc ev = ((DaoEventoOsProdSobEncImpl)this.getDao()).getEventoAberto(numeroRegistro, empresa.getIdentificador(), EnumConstOrigemEventoOSProd.SIMPLIFICADO);
        if (ev == null) {
            return null;
        }
        DTOEventoOSSobEncomendaSimples d = new DTOEventoOSSobEncomendaSimples();
        d.setCelulaProdutiva(ev.getFaseProdutiva().getCelulaProdutiva().getDescricao());
        d.setIdentificadorFaseProdutiva(ev.getFaseProdutiva().getIdentificador());
        d.setDescricaoAuxiliarFaseProdutiva(ev.getFaseProdutiva().getDescricaoAuxiliar());
        d.setCodigoOS(ev.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getCodigo());
        d.setSubcodigoOS(ev.getSubdivisaoOSProdSobEnc().getNrOrdem());
        d.setIdentificadorSubOs(ev.getSubdivisaoOSProdSobEnc().getIdentificador());
        d.setDataEvento(ev.getDataAbertura());
        if (ev.getClassificacaoEvento() != null) {
            d.setIdentificadorClassificacaoEvento(ev.getClassificacaoEvento().getIdentificador());
            d.setDescricaoClassificacaoEvento(ev.getClassificacaoEvento().getDescricao());
        }
        if (ev.getTipoEvento() != null) {
            d.setIdentificadorTipoEvento(ev.getTipoEvento().getIdentificador());
            d.setDescricaoTipoEvento(ev.getTipoEvento().getDescricao());
        }
        if (ev.getTurnoDeTrabalho() != null) {
            d.setIdentificadorTurnoTrabalho(ev.getTurnoDeTrabalho().getIdentificador());
            d.setDescricaoTurnoTrabalho(ev.getTurnoDeTrabalho().getDescricao());
        }
        if (ev.getEquipamentos().size() >= 1) {
            EvtOSSobEncomendaEquip equip = (EvtOSSobEncomendaEquip)ev.getEquipamentos().get(0);
            d.setCodigoEquipamento(equip.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getCodigo());
            d.setEquipamento(equip.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getNome());
            d.setIdentificadorFaseProdEquip(equip.getFaseProdutivaEquip().getIdentificador());
            if (equip.getConfiguracaoAtivo() != null) {
                d.setDescricaoConfiguracaoEquipamento(equip.getConfiguracaoAtivo().getDescricao());
                d.setIdentificadorConfiguracaoEquipamento(equip.getConfiguracaoAtivo().getIdentificador());
            }
        }
        if (ev.getColaboradoresEvtProd().size() >= 1) {
            ColaboradorEvtOsProdSobEnc colab = (ColaboradorEvtOsProdSobEnc)ev.getColaboradoresEvtProd().get(0);
            d.setNomeColaborador(colab.getColaborador().getPessoa().getNome());
            d.setIdentificadorColaborador(colab.getColaborador().getIdentificador());
            d.setNumeroRegistroColaborador(colab.getColaborador().getNumeroRegistro());
        }
        if (ev.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getGradeCor() != null) {
            GradeCor gc = ev.getSubdivisaoOSProdSobEnc().getOrdemServicoProdSobEnc().getGradeCor();
            d.setIdentificadorProduto(gc.getProdutoGrade().getProduto().getIdentificador());
            d.setCodigoAuxiliarProduto(gc.getProdutoGrade().getProduto().getCodigoAuxiliar());
            d.setNomeProduto(gc.getProdutoGrade().getProduto().getNome());
            d.setUnidadeMedidaProduto(gc.getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
        }
        return d;
    }

    public void avaliarValorCustoSobEncomenda(EventoOsProdSobEnc evt) throws ExceptionInvalidData {
        OpcoesPCP opcoesPCP = this.getSharedData().getOpcoesPCP(evt.getEmpresa());
        EnumConstCelulaProdTipoCusto tipoCusto = EnumConstCelulaProdTipoCusto.get((Short)opcoesPCP.getTipoPesqCustoHoraCel());
        new AuxCustoEventoOsSobEnc(this.serviceFeriado, this.serviceSaldoEstoque, this.serviceColaborador, this.serviceCelula, this.getSharedData().getOpcoesPCP(evt.getEmpresa()), this.helperOpcoesPCP).avaliarValorCustoSobEncomenda(evt, false, tipoCusto);
    }

    public void avaliarValorCustoFinalSobEncomenda(EventoOsProdSobEnc evt) throws ExceptionInvalidData {
        OpcoesPCP opcoesPCP = this.getSharedData().getOpcoesPCP(evt.getEmpresa());
        EnumConstCelulaProdTipoCusto tipoCusto = EnumConstCelulaProdTipoCusto.get((Short)opcoesPCP.getTipoPesqCustoHoraCel());
        new AuxCustoEventoOsSobEnc(this.serviceFeriado, this.serviceSaldoEstoque, this.serviceColaborador, this.serviceCelula, this.getSharedData().getOpcoesPCP(evt.getEmpresa()), this.helperOpcoesPCP).avaliarValorCustoSobEncomenda(evt, true, tipoCusto);
    }

    public List<ColaboradorEvtOsProdSobEnc> getColaboradoresEvento(Long[] identificadores, Empresa empresa, OpcoesPCP opcoesPCP) {
        List colaboradores = this.serviceColaborador.gets(identificadores);
        ArrayList<ColaboradorEvtOsProdSobEnc> result = new ArrayList<ColaboradorEvtOsProdSobEnc>();
        for (Colaborador c : colaboradores) {
            if ((opcoesPCP.getUtlizarColaboradorEmpresasDiferentes() == null || !TMethods.isAffirmative((Number)opcoesPCP.getUtlizarColaboradorEmpresasDiferentes())) && !TMethods.isEquals((Object)empresa, (Object)c.getEmpresa()) || !TMethods.isAffirmative((Number)c.getPessoa().getAtivo()) || !TMethods.isAffirmative((Number)c.getAtivo()) || c.getDataDemissao() != null) continue;
            ColaboradorEvtOsProdSobEnc vo = new ColaboradorEvtOsProdSobEnc();
            vo.setColaborador(c);
            result.add(vo);
        }
        return result;
    }

    public List<FaseProdutiva> getFaseProdutivaOs(Long subdivisaoOSProdSobEnc) throws ExceptionValidacaoDados {
        ArrayList<FaseProdutiva> fases = new ArrayList<FaseProdutiva>();
        SubdivisaoOSProdSobEnc vo = (SubdivisaoOSProdSobEnc)this.serviceSubdivisaoOSProdSobEnc.get(subdivisaoOSProdSobEnc);
        if (vo != null) {
            HelperOrdemServicoProdSobEnc helper = (HelperOrdemServicoProdSobEnc)ConfApplicationContext.getBean(HelperOrdemServicoProdSobEnc.class);
            if (!helper.build(vo.getOrdemServicoProdSobEnc()).osFechada().booleanValue()) {
                fases.add(vo.getFaseProdutiva());
                return fases;
            }
            throw new ExceptionValidacaoDados("E.ERP.0458.001", new Object[0]);
        }
        return fases;
    }

    public List<EvtOSSobEncomendaEquip> getEquipamentosEvento(Long idFaseProdutiva) {
        ArrayList<EvtOSSobEncomendaEquip> result = new ArrayList<EvtOSSobEncomendaEquip>();
        FaseProdutiva faseProdutiva = (FaseProdutiva)this.serviceFaseProdutiva.get(idFaseProdutiva);
        if (faseProdutiva != null && faseProdutiva.getEquipamentos() != null) {
            for (FaseProdutivaEquip fe : faseProdutiva.getEquipamentos()) {
                if (!TMethods.isAffirmative((Number)fe.getCelProdutivaEquip().getAtivo())) continue;
                EvtOSSobEncomendaEquip evtEq = new EvtOSSobEncomendaEquip();
                evtEq.setFaseProdutivaEquip(fe);
                result.add(evtEq);
            }
        }
        return result;
    }

    public List<EventoOsProdSobEnc> getEventos(OrdemServicoProdSobEnc osSobEnc) {
        return ((DaoEventoOsProdSobEncImpl)this.getDao()).getEventos(osSobEnc);
    }

    public DTOEventoOsProdSobEnc calcularTotalHorasEvento(OpcoesPCP opcoesPCP, DTOEventoOsProdSobEnc evento) throws ExceptionInvalidData {
        EventoOsProdSobEnc vo = (EventoOsProdSobEnc)this.buildToEntity(evento);
        this.eventoOSSobEnc.build(vo).calculaHoras(vo, opcoesPCP);
        return this.buildToDTO(vo, DTOEventoOsProdSobEnc.class);
    }
}

