/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.model.vo.ClassificacaoEvtOsPCP;
import com.touchcomp.basementor.model.vo.ColabEvtOsProdLinhaProd;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConfiguracaoPCPAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdLinProdEquip;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FaseProdutivaEquip;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.TipoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.impl.classificacaoevtoslinprod.ServiceClassificacaoEvtOsPCPImpl;
import com.touchcomp.basementorservice.service.impl.colaborador.ServiceColaboradorImpl;
import com.touchcomp.basementorservice.service.impl.configuracaopcpativo.ServiceConfiguracaoPCPAtivoImpl;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.ServiceEventoOsProducaoLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.horariotrabalho.ServiceHorarioTrabalhoImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod.ServiceSubdivisaoOSProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceFaseProdutivaImpl;
import com.touchcomp.basementorservice.service.impl.roteiroproducao.ServiceRoteiroProdFaseProdEquipImpl;
import com.touchcomp.basementorservice.service.impl.tipoevento.ServiceTipoEventoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.impl.eventoosproducaolinhaprod.ValidEventoOsProducaoLinhaProd;
import com.touchcomp.touchvomodel.vo.eventooslinhaprod.simplificado.DTOEventoOSLinhaProdSimples;
import java.util.Date;

public class AuxEventoOSProducaoLinha {
    final ServiceRoteiroProdFaseProdEquipImpl serviceEquipamento;
    final ServiceColaboradorImpl serviceColaborador;
    final ServiceSubdivisaoOSProdLinhaProdImpl serviceSubOs;
    final ServiceTipoEventoImpl serviceTipoEvento;
    final ServiceHorarioTrabalhoImpl serviceHorarioTraballho;
    final ServiceFaseProdutivaImpl serviceFaseProdutiva;
    final ValidEventoOsProducaoLinhaProd validEvento;
    final ServiceEventoOsProducaoLinhaProdImpl serviceEvtOsLinhaProd;
    final ServiceClassificacaoEvtOsPCPImpl serviceClassificacaoEvento;
    final ServiceConfiguracaoPCPAtivoImpl serviceConfiguracaoPCPAtivo;

    public AuxEventoOSProducaoLinha(ServiceRoteiroProdFaseProdEquipImpl serviceEquipamento, ServiceColaboradorImpl serviceColaborador, ServiceSubdivisaoOSProdLinhaProdImpl serviceSubOs, ServiceTipoEventoImpl serviceTipoEvento, ServiceHorarioTrabalhoImpl serviceHorarioTraballho, ServiceFaseProdutivaImpl serviceFaseProdutiva, ValidEventoOsProducaoLinhaProd validEvento, ServiceEventoOsProducaoLinhaProdImpl serviceEvtOsLinhaProd, ServiceClassificacaoEvtOsPCPImpl serviceClassificacaoEvento, ServiceConfiguracaoPCPAtivoImpl serviceConfiguracaoPCPAtivo) {
        this.serviceEquipamento = serviceEquipamento;
        this.serviceColaborador = serviceColaborador;
        this.serviceSubOs = serviceSubOs;
        this.serviceTipoEvento = serviceTipoEvento;
        this.serviceHorarioTraballho = serviceHorarioTraballho;
        this.serviceFaseProdutiva = serviceFaseProdutiva;
        this.validEvento = validEvento;
        this.serviceEvtOsLinhaProd = serviceEvtOsLinhaProd;
        this.serviceClassificacaoEvento = serviceClassificacaoEvento;
        this.serviceConfiguracaoPCPAtivo = serviceConfiguracaoPCPAtivo;
    }

    EventoOsProducaoLinhaProd getEvento(DTOEventoOSLinhaProdSimples input, Empresa empresa, OpcoesPCP opcoes) throws ExceptionInvalidData, ExceptionObjNotFound {
        Colaborador colaborador = this.serviceColaborador.pesquisarColaboradorPorNumeroRegistro(input.getNumeroRegistroColaborador());
        if (colaborador == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0516.002", new String[]{input.getNumeroRegistroColaborador()}));
        }
        TipoEvento tipoEvento = (TipoEvento)this.serviceTipoEvento.get(input.getIdentificadorTipoEvento());
        if (tipoEvento == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0533.001", new Object[]{input.getIdentificadorTipoEvento()}));
        }
        SubdivisaoOSProdLinhaProd subOS = (SubdivisaoOSProdLinhaProd)this.serviceSubOs.get(input.getIdentificadorSubOs());
        if (subOS == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0431.004", new Object[]{input.getIdentificadorSubOs()}));
        }
        FaseProdutiva fase = (FaseProdutiva)this.serviceFaseProdutiva.get(input.getIdentificadorFaseProdutiva());
        if (fase == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0129.001", new Object[]{input.getIdentificadorSubOs()}));
        }
        HorarioTrabalho hor = this.serviceHorarioTraballho.getHorarioTrabalho(empresa, input.getDataAbertura(), ToolDate.getHorasEmNumero((Date)input.getDataAbertura()));
        EventoOsProducaoLinhaProd evento = new EventoOsProducaoLinhaProd();
        evento.setOrigemEvento(EnumConstOrigemEventoOSProd.SIMPLIFICADO.getValue());
        evento.setDataAbertura(input.getDataAbertura());
        evento.setDataFechamento(input.getDataEncerramento());
        evento.setDataCadastro(new Date());
        evento.setEmpresa(empresa);
        evento.setFaseProdutiva(fase);
        if (ToolMethods.isWithData((Number)input.getIdentificadorColaborador())) {
            ColabEvtOsProdLinhaProd colab = new ColabEvtOsProdLinhaProd();
            colab.setColaborador(colaborador);
            evento.setColaboradoresEvtProd(ToolMethods.toList((Object[])new Object[]{colab}));
        }
        if (ToolMethods.isWithData((Number)input.getIdentificadorFaseProdEquip())) {
            FaseProdutivaEquip faseProdutivaEquip = (FaseProdutivaEquip)this.serviceEquipamento.get(input.getIdentificadorFaseProdEquip());
            if (faseProdutivaEquip == null) {
                throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.0129.001", new Object[]{input.getIdentificadorFaseProdEquip()}));
            }
            EventoOsProdLinProdEquip evtEquip = new EventoOsProdLinProdEquip();
            evtEquip.setFaseProdutivaEquip(faseProdutivaEquip);
            evento.setEquipamentos(ToolMethods.toList((Object[])new Object[]{evtEquip}));
            if (ToolMethods.isWithData((Number)input.getIdentificadorConfiguracaoEquipamento())) {
                evtEquip.setConfiguracaoAtivo((ConfiguracaoPCPAtivo)this.serviceConfiguracaoPCPAtivo.get(input.getIdentificadorConfiguracaoEquipamento()));
            }
        }
        if (ToolMethods.isWithData((Number)input.getIdentificadorClassificacaoEvento())) {
            evento.setClassificacaoEvento((ClassificacaoEvtOsPCP)this.serviceClassificacaoEvento.get(input.getIdentificadorClassificacaoEvento()));
        }
        evento.setSubdivisaoOSProd(subOS);
        evento.setTipoEvento(tipoEvento);
        if (hor != null) {
            evento.setTurnoDeTrabalho(hor.getTurnoDeTrabalho());
        }
        return evento;
    }
}

