/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod;

import com.google.common.util.concurrent.AtomicDouble;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.EmbalagemProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.TipoEvento;
import com.touchcomp.basementor.model.vo.TiposDefeitos;
import com.touchcomp.basementor.model.vo.TurnoDeTrabalho;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.model.TempSaveObj;
import com.touchcomp.basementorservice.service.ServiceGenericImpl;
import com.touchcomp.basementorservice.service.impl.embalagemproducao.ServiceEmbalagemProducaoImpl;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.SCompEventoOsProducaoLinhaProd;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.ServiceEventoOsProducaoLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod.ServiceSubdivisaoOSProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.tipoevento.ServiceTipoEventoImpl;
import com.touchcomp.basementorservice.service.impl.tipoproducao.ServiceTipoProducaoImpl;
import com.touchcomp.basementorservice.service.impl.tiposdefeitos.ServiceTiposDefeitosImpl;
import com.touchcomp.basementorservice.service.impl.turnodetrabalho.ServiceTurnoDeTrabalhoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementorvalidator.entities.impl.eventoosproducaolinhaprod.ValidEventoOsProducaoLinhaProd;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SCompEventosOSEmbProducao
extends ServiceGenericImpl {
    final ServiceEmbalagemProducaoImpl serviceEmbalagemProducaoImpl;
    final SCompEventoOsProducaoLinhaProd scompEventoOsProducaoLinhaProd;
    final ServiceEventoOsProducaoLinhaProdImpl serviceEventoOsProducaoLinhaProdImpl;
    final ServiceTurnoDeTrabalhoImpl serviceTurnoDeTrabalhoImpl;
    final ServiceTipoProducaoImpl serviceTipoProducaoImpl;
    final ServiceTiposDefeitosImpl serviceTiposDefeitosImpl;
    final ServiceTipoEventoImpl serviceTipoEventoImpl;
    final ServiceSubdivisaoOSProdLinhaProdImpl serviceSubdivisaoOSProdLinhaProdImpl;
    final ValidEventoOsProducaoLinhaProd validEventoOsProducaoLinhaProd;

    public SCompEventosOSEmbProducao(ServiceEmbalagemProducaoImpl serviceEmbalagemProducaoImpl, SCompEventoOsProducaoLinhaProd scompEventoOsProducaoLinhaProd, ServiceEventoOsProducaoLinhaProdImpl serviceEventoOsProducaoLinhaProdImpl, ServiceTurnoDeTrabalhoImpl serviceTurnoDeTrabalhoImpl, ServiceTipoProducaoImpl serviceTipoProducaoImpl, ServiceTiposDefeitosImpl serviceTiposDefeitosImpl, ServiceTipoEventoImpl serviceTipoEventoImpl, ServiceSubdivisaoOSProdLinhaProdImpl serviceSubdivisaoOSProdLinhaProdImpl, ValidEventoOsProducaoLinhaProd validEventoOsProducaoLinhaProd) {
        this.serviceEmbalagemProducaoImpl = serviceEmbalagemProducaoImpl;
        this.scompEventoOsProducaoLinhaProd = scompEventoOsProducaoLinhaProd;
        this.serviceEventoOsProducaoLinhaProdImpl = serviceEventoOsProducaoLinhaProdImpl;
        this.serviceTurnoDeTrabalhoImpl = serviceTurnoDeTrabalhoImpl;
        this.serviceTipoProducaoImpl = serviceTipoProducaoImpl;
        this.serviceTiposDefeitosImpl = serviceTiposDefeitosImpl;
        this.serviceTipoEventoImpl = serviceTipoEventoImpl;
        this.serviceSubdivisaoOSProdLinhaProdImpl = serviceSubdivisaoOSProdLinhaProdImpl;
        this.validEventoOsProducaoLinhaProd = validEventoOsProducaoLinhaProd;
    }

    public Result getEventos(Date dataProcessamento, CentroCusto centroCusto, Empresa empresa, CentroEstoque centroEstoque, Produto produto) throws ExceptionBase {
        List<EmbalagemProducao> listEmbalagemProducao = this.serviceEmbalagemProducaoImpl.pesquisarEmbalagemProduzidasPorDataCentroCustoEmpresa(dataProcessamento, centroCusto, empresa);
        ArrayList<EventoOsProducaoLinhaProd> listEventoOsProducaoLinhaProd = new ArrayList<EventoOsProducaoLinhaProd>();
        ArrayList<Dados> dados = new ArrayList<Dados>();
        LinkedList<String> msgsErro = new LinkedList<String>();
        LinkedList<String> msgsSucesso = new LinkedList<String>();
        for (EmbalagemProducao eb : listEmbalagemProducao) {
            for (ItemEmbalagemProducao item : eb.getItemEmbalagemProducao()) {
                Dados d;
                if (produto != null && !ToolMethods.isEquals((Object)item.getGradeCor().getProdutoGrade().getProduto(), (Object)produto)) continue;
                Optional<Dados> found = dados.stream().filter(i -> ToolMethods.isEquals((Object)i.gradeCor, (Object)item.getGradeCor()) && ToolMethods.isEquals((Object)i.loteFabricacao, (Object)item.getLoteFabricacao())).findFirst();
                if (found.isPresent()) {
                    d = found.get();
                } else {
                    d = new Dados(item.getGradeCor(), item.getLoteFabricacao(), new AtomicDouble());
                    dados.add(d);
                }
                d.qtdTotal.addAndGet(item.getQuantidade().doubleValue());
            }
        }
        for (Dados d : dados) {
            SubdivisaoOSProdLinhaProd sub = this.serviceSubdivisaoOSProdLinhaProdImpl.getSubOSAberta(d.gradeCor);
            if (sub == null) {
                msgsErro.add("Nenhum ordem/subos aberta encontrada para " + String.valueOf(d.gradeCor));
                continue;
            }
            EventoOsProducaoLinhaProd eventoOsProducaoLinhaProd = this.scompEventoOsProducaoLinhaProd.gerarEvento(empresa, dataProcessamento, dataProcessamento, (TipoEvento)this.serviceTipoEventoImpl.getFirst(), new Date(), sub, (FaseProdutiva)sub.getRoteiroProducao().getFasesProdutivas().get(0), 0.0, (TurnoDeTrabalho)this.serviceTurnoDeTrabalhoImpl.getFirst(), false, this.serviceTipoProducaoImpl.getFirstTipoProducao(EnumConstTipoProducao.PRODUCAO), (TiposDefeitos)this.serviceTiposDefeitosImpl.getFirst(), centroEstoque, d.qtdTotal().doubleValue(), d.loteFabricacao);
            listEventoOsProducaoLinhaProd.add(eventoOsProducaoLinhaProd);
            msgsSucesso.add("Evento gerado com sucesso para o produto " + String.valueOf(sub.getGradeCor()));
        }
        if (ToolMethods.isWithData(msgsErro)) {
            return new Result(msgsErro, msgsSucesso, new LinkedList<EventoOsProducaoLinhaProd>());
        }
        LinkedList<EventoOsProducaoLinhaProd> evts = new LinkedList<EventoOsProducaoLinhaProd>();
        for (EventoOsProducaoLinhaProd evt : listEventoOsProducaoLinhaProd) {
            this.validEventoOsProducaoLinhaProd.clearContainer();
            TempSaveObj<EventoOsProducaoLinhaProd> t = this.serviceEventoOsProducaoLinhaProdImpl.saveOrUpdateValidate(evt, this.validEventoOsProducaoLinhaProd);
            if (t.getStatus().isErro()) {
                throw new ExceptionInvalidData("V.ERP.0428.014", new Object[]{t.getValidErrors().asString()});
            }
            evts.add(evt);
        }
        return new Result(msgsErro, msgsSucesso, evts);
    }

    record Dados(GradeCor gradeCor, LoteFabricacao loteFabricacao, AtomicDouble qtdTotal) {
    }

    public record Result(List<String> msgsErro, List<String> msgsSucesso, List<EventoOsProducaoLinhaProd> listEventoOsProducaoLinhaProd) {
    }
}

