/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.constants.enums.opcoespcp.EnumConstOpcoesPCPOP;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.ColabEvtOsProdLinhaProd;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdLinProdEquip;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.PreEventoOsLinhaProducao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorrules.opcoesdinamicas.interfaces.ModelOpDinamicasInterface;
import com.touchcomp.basementorservice.dao.impl.DaoEventoOsProducaoLinhaProdImpl;
import com.touchcomp.basementorservice.helpers.impl.eventoosproducaolinhaprod.HelperEventoOsProducaoLinhaProd;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespcp.HelperOpcoesPCP;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoQtd;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoTipoEvento;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.ServiceComunicadoProducaoImpl;
import com.touchcomp.basementorservice.service.impl.eventoosproducaolinhaprod.AuxAvaliacaoTempo;
import com.touchcomp.basementorservice.service.impl.ordemservicoprodlinhaprod.ServiceSubdivisaoOSProdLinhaProdImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.preeventooslinhaproducao.ServicePreEventoOsLinhaProducaoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.eventooslinhaprod.simplificado.DTOEventoOSLinhaProdSimples;
import com.touchcomp.touchvomodel.web.WebDTOObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEventoOsProducaoLinhaProdImpl
extends ServiceGenericEntityImpl<EventoOsProducaoLinhaProd, Long, DaoEventoOsProducaoLinhaProdImpl> {
    @Autowired
    ServicePedidoImpl servicePedido;
    @Autowired
    ServiceSubdivisaoOSProdLinhaProdImpl serviceSubOS;
    @Autowired
    ServiceComunicadoProducaoImpl serviceComunicadoProducaoImpl;
    @Autowired
    ServicePreEventoOsLinhaProducaoImpl servicePreEvento;
    HelperRequisicao helperRequisicao;
    private final HelperOpcoesPCP helperOpcoesPCP;

    @Autowired
    public ServiceEventoOsProducaoLinhaProdImpl(DaoEventoOsProducaoLinhaProdImpl genericDao, ServiceComunicadoProducaoImpl serviceComunicadoProducaoImpl, HelperRequisicao helperRequisicao, HelperOpcoesPCP helperOpcoesPCP) {
        super(genericDao);
        this.serviceComunicadoProducaoImpl = serviceComunicadoProducaoImpl;
        this.helperRequisicao = helperRequisicao;
        this.helperOpcoesPCP = helperOpcoesPCP;
    }

    public List<Map<String, Object>> getQuantidadeApontadaEvt(Long idGradeCor, Date dataInicial, Date dataFinal) {
        return ((DaoEventoOsProducaoLinhaProdImpl)this.getGenericDao()).getQuantidadeApontadaEvt(idGradeCor, dataInicial, dataFinal);
    }

    @Override
    public EventoOsProducaoLinhaProd beforeSaveEntity(EventoOsProducaoLinhaProd evt) {
        for (ColabEvtOsProdLinhaProd colab : evt.getColaboradoresEvtProd()) {
            colab.setEventoOsProducao(evt);
        }
        for (EventoOsProdLinProdEquip equipamento : evt.getEquipamentos()) {
            equipamento.setEventoOsLinProd(evt);
        }
        for (PreEventoOsLinhaProducao preEvento : evt.getPreEventos()) {
            preEvento.setEventoOSProducaoLinProd(evt);
        }
        evt.setHoraEvento(ToolDate.calcularDifHoras((Date)evt.getDataAbertura(), (Date)evt.getDataFechamento()));
        OpcoesPCP opcoesPCP = this.getSharedData().getOpcoesPCP(evt.getEmpresa());
        this.avaliarTempoEstimadoConfRoteiro(evt);
        Short preencherApenasProdPrincipal = (Short)CompOpcoes.getOption(this.getBean(HelperOpcoesPCP.class).build(this.getSharedData().getOpcoesPCP(evt.getEmpresa())).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_APONT_PROD_CONJ_PROD_PRINCIPAL, Short.class);
        if (TMethods.isAffirmative((Number)preencherApenasProdPrincipal)) {
            new HelperEventoOsProducaoLinhaProd().build(evt).validarQuantidades();
        }
        if (!this.isNull(evt.getComunicadoProducao()).booleanValue()) {
            evt.getComunicadoProducao().setRequisicao(this.helperRequisicao.beforeSave(evt.getComunicadoProducao().getRequisicao()));
            evt.getComunicadoProducao().getItemComunicadoProducao().forEach(ic -> ic.getRequisicoes().forEach(r -> this.helperRequisicao.beforeSave((Requisicao)r)));
        }
        if (!this.isNull((evt = this.saveOrUpdateOnly(evt)).getComunicadoProducao()).booleanValue()) {
            evt.setComunicadoProducao(this.serviceComunicadoProducaoImpl.saveOrUpdate(evt.getComunicadoProducao()));
        }
        this.serviceSubOS.verificarFecharOs(opcoesPCP, evt.getSubdivisaoOSProd(), evt.getDataFechamento());
        for (Object preEvento : evt.getPreEventos()) {
            PreEventoOsLinhaProducao pre = (PreEventoOsLinhaProducao)preEvento;
            pre.setEventoOSProducaoLinProd(evt);
            pre.setApontado(Short.valueOf((short)1));
            this.servicePreEvento.saveOrUpdate(pre);
        }
        return evt;
    }

    @Override
    public EventoOsProducaoLinhaProd afterSaveEntity(EventoOsProducaoLinhaProd evt) {
        this.flushData();
        this.servicePedido.atualizarSitPedidoSubOSLinha(evt.getSubdivisaoOSProd().getOrdemServicoProdLinhaProd());
        return evt;
    }

    public void populateStaticOptionsWeb(OpcoesPCP opcoes, WebDTOObject t) {
        if (this.isNotNull(opcoes).booleanValue()) {
            this.reload(opcoes);
            List<ModelOpDinamicasInterface> itens = this.helperOpcoesPCP.build(opcoes).getItens();
            t.addStaticOption("apontarEquipamentos", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.APONTAR_EQUIPAMENTOS, Short.class));
            t.addStaticOption("fecharautoEvtAnt", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.FECHAR_AUTO_EVT_ANT, Short.class));
            t.addStaticOption("informarConfiguracaoAtivo", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.INFORMAR_CONFIGURACAO_ATIVO, Short.class));
            t.addStaticOption("informarClassificacaoEvento", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.INFORMAR_CLASSIFICACAO_EVENTO, Short.class));
            t.addStaticOption("validarColaborador", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.VALIDAR_COLABORADOR, Short.class));
            t.addStaticOption("permitirApontamento", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_APONTAMENTO, Short.class));
            t.addStaticOption("permitirAberturaOS", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_ABERTURA_OS, Short.class));
            t.addStaticOption("permitirFechamentoOS", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_FECHAMENTO_OS, Short.class));
            t.addStaticOption("permitirApontamentoProducao", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_APONTAMENTO_PRODUCAO, Short.class));
            t.addStaticOption("permitirApontamentoTipoProducao", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_TIPO_PRODUCAO, Short.class));
            t.addStaticOption("permitirApontamentoTipoDefeito", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_TIPO_DEFEITO, Short.class));
            t.addStaticOption("permitirCentroEstoque", CompOpcoes.getOption(itens, (EnumOpDinamicasInterface)EnumConstOpcoesPCPOP.PERMITIR_CENTRO_ESTOQUE, Short.class));
        }
    }

    public void reprocessaEventos(Date dataInicial, Date dataFinal, OpcoesPCP opcoesPCP) {
        List<EventoOsProducaoLinhaProd> eventos = ((DaoEventoOsProducaoLinhaProdImpl)this.getDao()).getEventosPeriodo(dataInicial, dataFinal, opcoesPCP.getEmpresa());
        for (EventoOsProducaoLinhaProd evt : eventos) {
            this.saveOrUpdate(evt);
        }
    }

    public boolean validaSubOS(SubdivisaoOSProdLinhaProd subDivisaoOSProd) {
        List<EventoOsProducaoLinhaProd> eventos = ((DaoEventoOsProducaoLinhaProdImpl)this.getGenericDao()).pesquisarEventosSubOS(subDivisaoOSProd);
        return eventos.isEmpty();
    }

    public EventoOsProducaoLinhaProd getEvtOSByCodSincronizacao(String codSincronizacao, SubdivisaoOSProdLinhaProd sub) {
        return ((DaoEventoOsProducaoLinhaProdImpl)this.getDao()).getEvtOSByCodSincronizacao(codSincronizacao, sub);
    }

    public EventoOsProducaoLinhaProd getEventoAberto(String numeroRegistro, Empresa empresa, EnumConstOrigemEventoOSProd origemEvento) {
        if (numeroRegistro == null || empresa == null) {
            return null;
        }
        return ((DaoEventoOsProducaoLinhaProdImpl)this.getDao()).getEventoAberto(numeroRegistro, empresa.getIdentificador(), origemEvento);
    }

    public DTOEventoOSLinhaProdSimples getEventoSimplificadoAberto(String numeroRegistro, Empresa empresa) {
        EventoOsProducaoLinhaProd ev = this.getEventoAberto(numeroRegistro, empresa, EnumConstOrigemEventoOSProd.SIMPLIFICADO);
        if (ev == null) {
            return null;
        }
        DTOEventoOSLinhaProdSimples d = new DTOEventoOSLinhaProdSimples();
        d.setCelulaProdutiva(ev.getFaseProdutiva().getCelulaProdutiva().getDescricao());
        d.setIdentificadorFaseProdutiva(ev.getFaseProdutiva().getIdentificador());
        d.setDescricaoAuxiliarFaseProdutiva(ev.getFaseProdutiva().getDescricaoAuxiliar());
        d.setCodigoOS(ev.getSubdivisaoOSProd().getOrdemServicoProdLinhaProd().getCodigo());
        d.setSubcodigoOS(ev.getSubdivisaoOSProd().getNrOrdem());
        d.setIdentificadorSubOs(ev.getSubdivisaoOSProd().getIdentificador());
        d.setDataAbertura(ev.getDataAbertura());
        d.setDataEncerramento(ev.getDataFechamento());
        if (ev.getClassificacaoEvento() != null) {
            d.setIdentificadorClassificacaoEvento(ev.getClassificacaoEvento().getIdentificador());
            d.setDescricaoClassificacaoEvento(ev.getClassificacaoEvento().getDescricao());
        }
        if (ev.getTipoEvento() != null) {
            d.setIdentificadorTipoEvento(ev.getTipoEvento().getIdentificador());
            d.setDescricaoTipoEvento(ev.getTipoEvento().getDescricao());
        }
        if (ev.getTurnoDeTrabalho() != null) {
            d.setIdentificadorTurnoTrabalho(ev.getTurnoDeTrabalho().getIdentificador());
            d.setDescricaoTurnoTrabalho(ev.getTurnoDeTrabalho().getDescricao());
        }
        if (ev.getEquipamentos().size() >= 1) {
            EventoOsProdLinProdEquip equip = (EventoOsProdLinProdEquip)ev.getEquipamentos().get(0);
            d.setCodigoEquipamento(equip.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getCodigo());
            d.setEquipamento(equip.getFaseProdutivaEquip().getCelProdutivaEquip().getEquipamento().getNome());
            d.setIdentificadorFaseProdEquip(equip.getFaseProdutivaEquip().getIdentificador());
            if (equip.getConfiguracaoAtivo() != null) {
                d.setDescricaoConfiguracaoEquipamento(equip.getConfiguracaoAtivo().getDescricao());
                d.setIdentificadorConfiguracaoEquipamento(equip.getConfiguracaoAtivo().getIdentificador());
            }
        }
        if (ev.getColaboradoresEvtProd().size() >= 1) {
            ColabEvtOsProdLinhaProd colab = (ColabEvtOsProdLinhaProd)ev.getColaboradoresEvtProd().get(0);
            d.setNomeColaborador(colab.getColaborador().getPessoa().getNome());
            d.setIdentificadorColaborador(colab.getColaborador().getIdentificador());
            d.setNumeroRegistroColaborador(colab.getColaborador().getNumeroRegistro());
        }
        if (ev.getSubdivisaoOSProd().getGradeCor() != null) {
            d.setIdentificadorProduto(ev.getSubdivisaoOSProd().getGradeCor().getProdutoGrade().getProduto().getIdentificador());
            d.setCodigoAuxiliarProduto(ev.getSubdivisaoOSProd().getGradeCor().getProdutoGrade().getProduto().getCodigoAuxiliar());
            d.setNomeProduto(ev.getSubdivisaoOSProd().getGradeCor().getProdutoGrade().getProduto().getNome());
            d.setUnidadeMedidaProduto(ev.getSubdivisaoOSProd().getGradeCor().getProdutoGrade().getProduto().getUnidadeMedida().getSigla());
        }
        return d;
    }

    public void avaliarTempoEstimadoConfRoteiro(EventoOsProducaoLinhaProd evt) {
        new AuxAvaliacaoTempo().avaliarEvento(evt);
    }

    public List<GenericMapValues<GenMapEvtProducaoQtd>> getApontamentosProducaoQtd(short filtrarCelula, Long idCelula, short filtrarEquipamento, Long idEquipamento, short filtrarTipoProducao, EnumConstTipoProducao tipoProducao, Date dataInicial, Date dataFinal, boolean usarQtdReferencia) {
        return ((DaoEventoOsProducaoLinhaProdImpl)this.getDao()).getApontamentosProducaoQtd(filtrarCelula, idCelula, filtrarEquipamento, idEquipamento, filtrarTipoProducao, tipoProducao, dataInicial, dataFinal, usarQtdReferencia);
    }

    public List<GenericMapValues<GenMapEvtProducaoQtd>> getApontamentosProducaoProdSubosQtd(short filtrarCelula, Long idCelula, short filtrarEquipamento, Long idEquipamento, short filtrarTipoProducao, EnumConstTipoProducao tipoProducao, Date dataInicial, Date dataFinal, boolean usarQtdReferencia) {
        return ((DaoEventoOsProducaoLinhaProdImpl)this.getDao()).getApontamentosProducaoProdSubosQtd(filtrarCelula, idCelula, filtrarEquipamento, idEquipamento, filtrarTipoProducao, tipoProducao, dataInicial, dataFinal, usarQtdReferencia);
    }

    public List<GenericMapValues<GenMapEvtProducaoTipoEvento>> getApontamentosTipoEvento(short filtrarCelula, Long idCelula, Date dataInicial, Date dataFinal, Short ... tipoEvento) {
        return ((DaoEventoOsProducaoLinhaProdImpl)this.getDao()).getApontamentosTipoEvento(filtrarCelula, idCelula, dataInicial, dataFinal, tipoEvento);
    }
}

