/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.evtctedesacordo;

import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.EvtCTeDesacordo;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.components.cte400.evtctedesacordo.CompCTeEvtDesacordo;
import com.touchcomp.basementorservice.dao.impl.DaoEvtCTeDesacordoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementortools.tools.string.TString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceEvtCTeDesacordoImpl
extends ServiceGenericEntityImpl<EvtCTeDesacordo, Long, DaoEvtCTeDesacordoImpl> {
    @Autowired
    CompCTeEvtDesacordo compCteEvtDesacordo;

    public ServiceEvtCTeDesacordoImpl(DaoEvtCTeDesacordoImpl dao) {
        super(dao);
    }

    public void enviarEventoSefaz(Long idEvento) throws ExceptionObjNotFound, ExceptionInvalidState {
        EvtCTeDesacordo aux = (EvtCTeDesacordo)this.get(idEvento);
        if (aux == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1956.003", new Object[]{idEvento}));
        }
        if (NFeConstStatusEventoNFe.isStatusFinal((Short)aux.getStatus())) {
            return;
        }
        ConfiguracaoCertificado conf = this.getSharedData().getConfiguracaoCertificado(aux.getEmpresa());
        if (conf == null) {
            throw new ExceptionObjNotFound(new ExcepCodeDetail("E.ERP.1396.001", new Object[]{aux.getEmpresa()}));
        }
        try {
            this.compCteEvtDesacordo.enviaEvtDesacordo(aux, conf);
        }
        catch (Exception ex) {
            this.logError(ex);
            aux.setMotivo(TString.cut((String)ex.getMessage(), (int)1000));
            throw new ExceptionInvalidState("E.ERP.1956.001", new Object[]{ex.getMessage()});
        }
        finally {
            this.saveOrUpdate(aux);
        }
    }

    public boolean isAllowedEditDelete(Long id) {
        EvtCTeDesacordo found = (EvtCTeDesacordo)this.get(id);
        if (found == null) {
            return true;
        }
        return NFeConstStatusEventoNFe.isStatusFinal((Short)found.getStatus());
    }
}

