/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.exameperiodo;

import com.touchcomp.basementor.model.vo.ExamePeriodo;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.ItemControleExamesFuncao;
import com.touchcomp.basementor.model.vo.ItemControleExamesPessoas;
import com.touchcomp.basementor.model.vo.ItemControleExamesVeiculos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Veiculo;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoExamePeriodoImpl;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.funcao.ServiceFuncaoImpl;
import com.touchcomp.basementorservice.service.impl.pessoa.ServicePessoaImpl;
import com.touchcomp.basementorservice.service.impl.veiculo.ServiceVeiculoImpl;
import com.touchcomp.touchvomodel.vo.exameperiodo.web.DTOExamePeriodo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceExamePeriodoImpl
extends ServiceGenericEntityImpl<ExamePeriodo, Long, DaoExamePeriodoImpl> {
    private ServiceFuncaoImpl serviceFuncao;
    private ServicePessoaImpl servicePessoa;
    private ServiceVeiculoImpl serviceVeiculo;

    @Autowired
    public ServiceExamePeriodoImpl(DaoExamePeriodoImpl dao, ServiceFuncaoImpl serviceFuncao, ServicePessoaImpl servicePessoa, ServiceVeiculoImpl serviceVeiculo) {
        super(dao);
        this.serviceFuncao = serviceFuncao;
        this.servicePessoa = servicePessoa;
        this.serviceVeiculo = serviceVeiculo;
    }

    public DTOExamePeriodo.DTOItemControleExamesFuncao getNovoItemFuncao(Long idFuncao) {
        Funcao funcao = (Funcao)this.serviceFuncao.get(idFuncao);
        if (this.isNull(funcao).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1197.001"));
        }
        DTOExamePeriodo.DTOItemControleExamesFuncao item = new DTOExamePeriodo.DTOItemControleExamesFuncao();
        item.setFuncao(funcao.toString());
        item.setFuncaoIdentificador(funcao.getIdentificador());
        item.setCbo(funcao.getCbo().getDescricao());
        return item;
    }

    @Override
    public ExamePeriodo beforeSave(ExamePeriodo aux) {
        for (ItemControleExamesFuncao funcoe : aux.getFuncoes()) {
            funcoe.setRotinaPeriodica(aux);
        }
        for (ItemControleExamesPessoas pessoa : aux.getPessoas()) {
            pessoa.setRotinaPeriodica(aux);
        }
        for (ItemControleExamesVeiculos veiculo : aux.getVeiculos()) {
            veiculo.setExamePeriodo(aux);
        }
        return aux;
    }

    public DTOExamePeriodo.DTOItemControleExamesPessoas getNovoItemPessoa(Long idPessoa) {
        Pessoa pessoa = (Pessoa)this.servicePessoa.get(idPessoa);
        if (this.isNull(pessoa).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1197.002"));
        }
        DTOExamePeriodo.DTOItemControleExamesPessoas item = new DTOExamePeriodo.DTOItemControleExamesPessoas();
        item.setPessoa(pessoa.toString());
        item.setPessoaIdentificador(pessoa.getIdentificador());
        item.setCpf(pessoa.getComplemento().getCnpj());
        return item;
    }

    public DTOExamePeriodo.DTOItemControleExamesVeiculos getNovoItemVeiculo(Long idVeiculo) {
        Veiculo veiculo = (Veiculo)this.serviceVeiculo.get(idVeiculo);
        if (this.isNull(veiculo).booleanValue()) {
            throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1197.003"));
        }
        DTOExamePeriodo.DTOItemControleExamesVeiculos item = new DTOExamePeriodo.DTOItemControleExamesVeiculos();
        item.setVeiculo(veiculo.toString());
        item.setVeiculoIdentificador(veiculo.getIdentificador());
        item.setMarcaModelo(veiculo.getMarcaModelo());
        return item;
    }
}

