/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.exclusaocoleta;

import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.AtivoTipoPontoControle;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ExclusaoColeta;
import com.touchcomp.basementor.model.vo.LogColeta;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.RelacaoEquipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.dao.impl.DaoExclusaoColetaImpl;
import com.touchcomp.basementorservice.helpers.impl.coleta.HelperLogColeta;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.ativotipopontocontrole.ServiceAtivoTipoPontoControleImpl;
import com.touchcomp.basementorservice.service.impl.coleta.ServiceColetaImpl;
import com.touchcomp.basementorservice.service.impl.equipamento.ServiceEquipamentoImpl;
import com.touchcomp.basementorservice.service.impl.planomanutencaoativo.ServicePlanoManutencaoAtivoImpl;
import com.touchcomp.basementorservice.service.impl.tipopontocontrole.ServiceTipoPontoControleImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceExclusaoColetaImpl
extends ServiceGenericEntityImpl<ExclusaoColeta, Long, DaoExclusaoColetaImpl> {
    ServiceEquipamentoImpl serviceEquipamento;
    ServiceTipoPontoControleImpl serviceTipoPontoControle;
    ServiceColetaImpl serviceColeta;
    HelperLogColeta helperLogColeta;
    ServiceAtivoTipoPontoControleImpl serviceAtivoTipoPontoControle;
    ServicePlanoManutencaoAtivoImpl servicePlanoManutencaoAtivo;

    @Autowired
    public ServiceExclusaoColetaImpl(DaoExclusaoColetaImpl dao, ServiceEquipamentoImpl serviceEquipamento, ServiceTipoPontoControleImpl serviceTipoPontoControle, ServiceColetaImpl serviceColeta, HelperLogColeta helperLogColeta, ServiceAtivoTipoPontoControleImpl serviceAtivoTipoPontoControle, ServicePlanoManutencaoAtivoImpl servicePlanoManutencaoAtivo) {
        super(dao);
        this.serviceEquipamento = serviceEquipamento;
        this.serviceTipoPontoControle = serviceTipoPontoControle;
        this.serviceColeta = serviceColeta;
        this.helperLogColeta = helperLogColeta;
        this.serviceAtivoTipoPontoControle = serviceAtivoTipoPontoControle;
        this.servicePlanoManutencaoAtivo = servicePlanoManutencaoAtivo;
    }

    public List<LogColeta> newLogColeta(Long idEquipamento, Long idTipoPontoControle) {
        Coleta coleta;
        ArrayList<LogColeta> result = new ArrayList<LogColeta>();
        Equipamento ativo = (Equipamento)this.serviceEquipamento.get(idEquipamento);
        TipoPontoControle tipoPontoControle = (TipoPontoControle)this.serviceTipoPontoControle.get(idTipoPontoControle);
        if (ativo != null && tipoPontoControle != null && (coleta = this.serviceColeta.findColetaAnterior(ativo, tipoPontoControle)) != null) {
            result.add(this.helperLogColeta.build((LogColeta)null).build(coleta));
            if (ativo.getAtivos() != null && !ativo.getAtivos().isEmpty()) {
                for (RelacaoEquipamento subComponente : ativo.getAtivos()) {
                    if (subComponente.getEquipamentoFilho() == null || (coleta = this.serviceColeta.findColetaAnterior(subComponente.getEquipamentoFilho(), tipoPontoControle)) == null) continue;
                    result.add(this.helperLogColeta.build((LogColeta)null).build(coleta));
                }
            }
            return result;
        }
        return null;
    }

    public void atualizaValoresPlanosManAtivo(ExclusaoColeta vo) throws ExceptionValidacaoDados {
        ArrayList<Coleta> coletas = new ArrayList<Coleta>();
        for (LogColeta log : vo.getColetas()) {
            Coleta coleta = this.serviceColeta.findByNumero(Long.parseLong(log.getColeta()), log.getAtivoIdentificador());
            if (coleta == null) continue;
            this.validaPlanoManutencaoVinculado(coleta);
            coletas.add(coleta);
        }
        List<PlanoManutencaoAtivo> planos = this.servicePlanoManutencaoAtivo.getPlanosVinculadosColeta(coletas);
        this.atualizaValoresPlanosVinculados(coletas, planos);
        this.serviceColeta.deleteCollection(coletas);
        if (planos != null && !planos.isEmpty()) {
            this.servicePlanoManutencaoAtivo.saveOrUpdate(planos);
        }
    }

    private void atualizaValoresPlanosVinculados(List<Coleta> coletas, List<PlanoManutencaoAtivo> planos) {
        for (Coleta c : coletas) {
            for (PlanoManutencaoAtivo p : planos) {
                for (AtivoDataUltimaManutencao ativo : p.getAtivos()) {
                    if (!c.getAtivo().equals((Object)ativo.getAtivo()) || !c.getTipoPontoControle().equals((Object)p.getTipoPontoControle())) continue;
                    if (c.getColetaAnterior() != null && c.getNumeroColeta() > ativo.getNumeroColetaGerada()) {
                        ativo.setValorAcumulado(Integer.valueOf(ativo.getValorAcumulado() + (c.getColetaAnterior().getValorColeta() - c.getValorColeta())));
                        ativo.setValorUltimaManutencao(c.getColetaAnterior().getValorColeta());
                        continue;
                    }
                    if (c.getColetaAnterior() != null && c.getNumeroColeta() <= ativo.getNumeroColetaGerada()) {
                        ativo.setValorAcumulado(this.serviceColeta.getValorAcumuladoColetaAtivo(c));
                        ativo.setValorUltimaManutencao(c.getColetaAnterior().getValorColeta());
                        Coleta ultimaColetaAtivo = this.serviceColeta.getUltimaColetaAtivoComExclusao(c);
                        if (ultimaColetaAtivo != null) {
                            ativo.setNumeroColetaGerada(ultimaColetaAtivo.getNumeroColeta());
                            continue;
                        }
                        ativo.setNumeroColetaGerada(Long.valueOf(0L));
                        continue;
                    }
                    ativo.setValorAcumulado(Integer.valueOf(0));
                    ativo.setValorUltimaManutencao(Integer.valueOf(0));
                    ativo.setNumeroColetaGerada(Long.valueOf(0L));
                }
            }
        }
    }

    private void validaPlanoManutencaoVinculado(Coleta coleta) throws ExceptionValidacaoDados {
        List<AtivoTipoPontoControle> listAtivo = this.serviceAtivoTipoPontoControle.findByColetaLimite(coleta);
        if (listAtivo != null && !listAtivo.isEmpty()) {
            Object planosManutencao = "";
            for (AtivoTipoPontoControle a : listAtivo) {
                if (a.getPlanoManutencaoAtivoAtivo() == null || a.getPlanoManutencaoAtivoAtivo().getGeracaoOrdemServicoPlanoManutencao() == null) continue;
                planosManutencao = (String)planosManutencao + a.getPlanoManutencaoAtivoAtivo().getGeracaoOrdemServicoPlanoManutencao().getIdentificador() + ", ";
            }
            throw new ExceptionValidacaoDados("E.ERP.1073.002", new Object[]{planosManutencao});
        }
    }

    @Override
    public ExclusaoColeta afterSaveEntity(ExclusaoColeta entity) {
        try {
            this.atualizaValoresPlanosManAtivo(entity);
            return entity;
        }
        catch (ExceptionValidacaoDados ex) {
            throw new ExceptionRuntimeBase(ex.getErrorCode());
        }
    }
}

