/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.service.impl.exclusaoeventosesocial;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.dao.impl.DaoExclusaoEventosEsocialImpl;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperEsocPreEvento;
import com.touchcomp.basementorservice.helpers.impl.esocpreevento.HelperExclusaoEventosEsocial;
import com.touchcomp.basementorservice.service.ServiceGenericEntityImpl;
import com.touchcomp.basementorservice.service.impl.esocpreevento.ServiceEsocPreEventoImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.touchvomodel.vo.exclusaoeventosesocial.web.DTOExclusaoEventosEsocial;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceExclusaoEventosEsocialImpl
extends ServiceGenericEntityImpl<ExclusaoEventosEsocial, Long, DaoExclusaoEventosEsocialImpl> {
    ServiceEsocPreEventoImpl serviceEsocPreEventoImpl;
    HelperEsocPreEvento helperEsocPreEvento;
    HelperExclusaoEventosEsocial helperExclusaoEventos;

    @Autowired
    public ServiceExclusaoEventosEsocialImpl(DaoExclusaoEventosEsocialImpl dao, ServiceEsocPreEventoImpl serviceEsocPreEventoImpl, HelperEsocPreEvento helperEsocPreEvento, HelperExclusaoEventosEsocial helperExclusaoEventos) {
        super(dao);
        this.serviceEsocPreEventoImpl = serviceEsocPreEventoImpl;
        this.helperEsocPreEvento = helperEsocPreEvento;
        this.helperExclusaoEventos = helperExclusaoEventos;
    }

    public void buildEsocEventos(ExclusaoEventosEsocial vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial {
        if (this.isEquals(vo.getTipoEventoEsocial().getIdentificador().shortValue(), EnumConstTipoEventoESocial.PROCESSO_TRABALHISTA.getEnumId()) && (vo.getPreEventosEsocial() == null || vo.getPreEventosEsocial().isEmpty())) {
            vo.setPreEventosEsocial(new ArrayList());
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
            vo.getPreEventosEsocial().add(this.helperEsocPreEvento.getEvento(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO, (Short)EnumConstantsMentorSimNao.NAO.getValue()));
        }
    }

    public DTOExclusaoEventosEsocial getEvento(Long idEsocPreEvento, Empresa empresa) throws ExceptionObjNotFound {
        EsocPreEvento esocPreEvento = (EsocPreEvento)this.serviceEsocPreEventoImpl.getOrThrow(idEsocPreEvento);
        if (this.isNull(esocPreEvento.getEsocEvento()).booleanValue() || !this.isEquals(esocPreEvento.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO.getEnumId()) && !this.isEquals(esocPreEvento.getEsocEvento().getStatus(), EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getEnumId())) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.1691.001"));
        }
        return this.buildEventos(esocPreEvento, empresa);
    }

    private DTOExclusaoEventosEsocial buildEventos(EsocPreEvento esocPreEvento, Empresa empresa) {
        ExclusaoEventosEsocial dto = new ExclusaoEventosEsocial();
        dto.setEmpresa(empresa);
        dto.setDataCadastro(new Date());
        dto.setEsocEventoAExcluir(esocPreEvento.getEsocEvento());
        dto.setNumeroRecibo(esocPreEvento.getEsocEvento().getNrRecibo());
        dto.setTipoEventoEsocial(esocPreEvento.getTipoEventoEsocial());
        dto.setPeriodoApuracao(this.getPeriodo(esocPreEvento));
        if (this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador().shortValue(), EnumConstRegistroESocial.REGISTRO_2190.getEnumId())) {
            dto.setCpf(esocPreEvento.getAdmissaoPreLiminar().getCpf());
        }
        if (this.isNotNull(esocPreEvento.getColaborador()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getColaborador().getDataAdmissao()));
            dto.setCpf(esocPreEvento.getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getAfastamentoColaborador()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getAfastamentoColaborador().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getAfastamentoColaborador().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getAfastamentoColaborador().getDataInicio()));
            dto.setCpf(esocPreEvento.getAfastamentoColaborador().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getEmissaoAviso()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getEmissaoAviso().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getEmissaoAviso().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getEmissaoAviso().getDataEmissaoAviso()));
            dto.setCpf(esocPreEvento.getEmissaoAviso().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getRecisao()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getRecisao().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getRecisao().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getRecisao().getDataAfastamento()));
            dto.setCpf(esocPreEvento.getRecisao().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getLancamentoAtestado()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getLancamentoAtestado().getColaborador());
            dto.setInformacoesEvento("ATESTADO");
        } else if (this.isNotNull(esocPreEvento.getFeriasColaborador()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getFeriasColaborador().getPeriodoAqFeriasColab().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getFeriasColaborador().getPeriodoAqFeriasColab().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getFeriasColaborador().getDataGozoInicial()));
            dto.setCpf(esocPreEvento.getFeriasColaborador().getPeriodoAqFeriasColab().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getTransferenciaColaborador()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getTransferenciaColaborador().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getTransferenciaColaborador().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getTransferenciaColaborador().getDataTransferencia()));
            dto.setCpf(esocPreEvento.getTransferenciaColaborador().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getEsocS1200()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getEsocS1200().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getEsocS1200().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao()));
            dto.setCpf(esocPreEvento.getEsocS1200().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getEsocS1210()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getEsocS1210().getColaborador());
            dto.setInformacoesEvento(esocPreEvento.getEsocS1210().getColaborador().toString() + " - " + ToolDate.dateToStr((Date)esocPreEvento.getEsocS1210().getEsocFechamento().getPeriodoApuracao()));
            dto.setCpf(esocPreEvento.getEsocS1210().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getConvocacao()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getConvocacao().getColaborador());
            dto.setCpf(esocPreEvento.getConvocacao().getColaborador().getPessoa().getComplemento().getCnpj());
        } else if (this.isNotNull(esocPreEvento.getMonitoramento()).booleanValue()) {
            dto.setColaborador(esocPreEvento.getMonitoramento().getColaborador());
            dto.setCpf(esocPreEvento.getMonitoramento().getColaborador().getPessoa().getComplemento().getCnpj());
        } else {
            dto.setInformacoesEvento(esocPreEvento.getDescricaoEntidade());
        }
        return this.buildToDTOGeneric(dto, DTOExclusaoEventosEsocial.class);
    }

    private Date getPeriodo(EsocPreEvento esocPreEvento) {
        if (this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador().shortValue(), EnumConstRegistroESocial.REGISTRO_1210.getEnumId())) {
            return esocPreEvento.getEsocS1210().getEsocFechamento().getPeriodoApuracao();
        }
        if (this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador().shortValue(), EnumConstRegistroESocial.REGISTRO_1200.getEnumId())) {
            if (this.isNotNull(esocPreEvento.getEsocS1200()).booleanValue()) {
                return esocPreEvento.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao();
            }
            if (this.isNotNull(esocPreEvento.getRecisao()).booleanValue()) {
                return esocPreEvento.getRecisao().getDataPagamento();
            }
        } else {
            if (this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador().shortValue(), EnumConstRegistroESocial.REGISTRO_1250.getEnumId())) {
                return esocPreEvento.getAquisicaoProducaoRural().getPeriodoReferencia();
            }
            if (this.isEquals(esocPreEvento.getTipoEventoEsocial().getIdentificador().shortValue(), EnumConstRegistroESocial.REGISTRO_1280.getEnumId())) {
                return esocPreEvento.getEsocFechamentoFolha().getPeriodoApuracao();
            }
        }
        return new Date();
    }

    public ExclusaoEventosEsocial criarExclusaoEvento1200(EsocPreEvento e) {
        ExclusaoEventosEsocial vo = this.helperExclusaoEventos.criarExclusaoEvento1200(e);
        vo = this.saveOrUpdate(vo);
        return vo;
    }

    public ExclusaoEventosEsocial criarExclusaoEvento1210(EsocPreEvento e) {
        ExclusaoEventosEsocial vo = this.helperExclusaoEventos.criarExclusaoEvento1210(e);
        vo = this.saveOrUpdate(vo);
        return vo;
    }

    public void desvincularColaboradorDaExclusaoEventosEsocial(Long idColaborador) {
        ((DaoExclusaoEventosEsocialImpl)this.getGenericDao()).desvincularColaboradorDaExclusaoEventosEsocial(idColaborador);
    }
}

